/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sfdesat.ColdBreathMod;
import com.sfdesat.config.ColdBreathConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ColdBreathConfig cached = null;

    private ConfigManager() {
    }

    public static ColdBreathConfig get() {
        if (cached == null) {
            cached = ConfigManager.load();
        }
        return cached;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColdBreathConfig load() {
        Path path = ConfigManager.getConfigPath();
        if (!Files.isRegularFile(path, new LinkOption[0])) return new ColdBreathConfig();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ColdBreathConfig cfg = (ColdBreathConfig)GSON.fromJson((Reader)reader, ColdBreathConfig.class);
            if (cfg == null) return new ColdBreathConfig();
            ColdBreathConfig coldBreathConfig = cfg;
            return coldBreathConfig;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ColdBreathConfig();
    }

    public static void save() {
        if (cached == null) {
            return;
        }
        Path path = ConfigManager.getConfigPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson((Object)cached, (Appendable)writer);
            }
        }
        catch (IOException e) {
            ColdBreathMod.LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    private static Path getConfigPath() {
        return Path.of("config", "coldbreath.json");
    }
}

