/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.breath;

import com.sfdesat.config.ColdBreathConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class EnvModel {
    private EnvModel() {
    }

    public static float computeEffectiveTemperature(class_638 world, class_2338 pos, ColdBreathConfig cfg) {
        float baseTemperature;
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        float temperature = baseTemperature = biome.method_8712();
        if (cfg.altitudeAdjustmentEnabled) {
            int seaLevel = world.method_8615();
            int altitude = pos.method_10264();
            temperature = baseTemperature - (float)(altitude - seaLevel) * (float)cfg.altitudeTemperatureRate;
        }
        return temperature;
    }

    public static boolean isWithinDayWindow(long dayTime, long start, long end) {
        if (start == end) {
            return false;
        }
        return start <= end ? dayTime >= start && dayTime <= end : dayTime >= start || dayTime <= end;
    }

    public static DimensionKind getDimensionKind(class_638 world) {
        if (world.method_27983() == class_1937.field_25180) {
            return DimensionKind.NETHER;
        }
        if (world.method_27983() == class_1937.field_25181) {
            return DimensionKind.END;
        }
        if (world.method_27983() == class_1937.field_25179) {
            return DimensionKind.OVERWORLD;
        }
        class_2960 id = world.method_27983().method_29177();
        String path = id.method_12832();
        if (path.contains("nether")) {
            return DimensionKind.NETHER;
        }
        if (path.contains("end") || path.contains("the_end")) {
            return DimensionKind.END;
        }
        return DimensionKind.OTHER;
    }

    public static boolean isEligibleNow(class_638 world, class_1657 player, ColdBreathConfig cfg) {
        boolean isColdHere;
        if (!cfg.enabled) {
            return false;
        }
        if (player.method_7325() || player.method_6113() || player.method_29504()) {
            return false;
        }
        if (!cfg.visibleInCreative && player.method_31549().field_7477) {
            return false;
        }
        if (player.method_5869()) {
            return cfg.underwaterEnabled;
        }
        DimensionKind dim = EnvModel.getDimensionKind(world);
        if (dim == DimensionKind.NETHER) {
            return cfg.visibleInNether;
        }
        if (dim == DimensionKind.END) {
            return cfg.visibleInEnd;
        }
        class_2338 pos = player.method_24515();
        float temp = EnvModel.computeEffectiveTemperature(world, pos, cfg);
        boolean bl = isColdHere = (double)temp <= cfg.alwaysBreathTemperature;
        if (!cfg.onlyInColdBiomes) {
            return true;
        }
        if (isColdHere) {
            return true;
        }
        if (cfg.morningBreathEnabled) {
            long dayTime = world.method_8532() % 24000L;
            boolean inWindow = EnvModel.isWithinDayWindow(dayTime, cfg.morningBreathStartTick, cfg.morningBreathEndTick);
            boolean goodTemp = (double)temp > cfg.alwaysBreathTemperature && (double)temp <= cfg.maxMorningBreathTemperature;
            return inWindow && goodTemp;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DimensionKind {
        OVERWORLD,
        NETHER,
        END,
        OTHER;

    }
}

