/*
 * Decompiled with CFR 0.152.
 */
package com.atl.skb;

import com.atl.skb.SecondaryKeyBind;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class SecondaryKeyBindConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("secondarykeybind.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map config = (Map)GSON.fromJson((Reader)reader, type);
                if (config != null) {
                    for (Map.Entry entry : config.entrySet()) {
                        class_3675.class_306 key;
                        class_304 keyBinding = SecondaryKeyBindConfig.findKeyBindingByTranslationKey((String)entry.getKey());
                        if (keyBinding == null || entry.getValue() == null || (key = class_3675.method_15981((String)((String)entry.getValue()))) == null) continue;
                        SecondaryKeyBind.setSecondaryKey(keyBinding, key);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        HashMap<String, String> config = new HashMap<String, String>();
        Iterator<Map.Entry<class_304, class_3675.class_306>> iterator = SecondaryKeyBind.secondaryKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_304, class_3675.class_306> entry = iterator.next();
            if (entry.getValue() != null) {
                config.put(entry.getKey().method_1431(), entry.getValue().method_1441());
                continue;
            }
            iterator.remove();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class_304 findKeyBindingByTranslationKey(String translationKey) {
        for (class_304 keyBinding : FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? class_310.method_1551().field_1690.field_1839 : new class_304[]{}) {
            if (!keyBinding.method_1431().equals(translationKey)) continue;
            return keyBinding;
        }
        return null;
    }
}

