/*
 * Decompiled with CFR 0.152.
 */
package com.funguyman10.expandedequipment.datagen;

import com.funguyman10.expandedequipment.item.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "expandedequipment", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)ModItems.RAW_CHORUNDUM.get());
        this.basicItem((Item)ModItems.CHORUNDUM.get());
        this.basicItem((Item)ModItems.ENERGETIC_ROCK.get());
        this.basicItem((Item)ModItems.CHORUNDUM_UPGRADE_TEMPLATE.get());
        this.handheldItem((Item)ModItems.COPPER_PICKAXE.get());
        this.handheldItem((Item)ModItems.COPPER_AXE.get());
        this.handheldItem((Item)ModItems.COPPER_SHOVEL.get());
        this.handheldItem((Item)ModItems.COPPER_HOE.get());
        this.handheldItem((Item)ModItems.COPPER_SWORD.get());
        this.handheldItem((Item)ModItems.COPPER_PAXEL.get());
        this.handheldItem((Item)ModItems.CHORUNDUM_PICKAXE.get());
        this.handheldItem((Item)ModItems.CHORUNDUM_AXE.get());
        this.handheldItem((Item)ModItems.CHORUNDUM_SHOVEL.get());
        this.handheldItem((Item)ModItems.CHORUNDUM_HOE.get());
        this.handheldItem((Item)ModItems.CHORUNDUM_SWORD.get());
        this.handheldItem((Item)ModItems.CHORUNDUM_PAXEL.get());
        this.trimmedArmorItem(ModItems.CHORUNDUM_HELMET);
        this.trimmedArmorItem(ModItems.CHORUNDUM_CHESTPLATE);
        this.trimmedArmorItem(ModItems.CHORUNDUM_LEGGINGS);
        this.trimmedArmorItem(ModItems.CHORUNDUM_BOOTS);
        this.trimmedArmorItem(ModItems.COPPER_HELMET);
        this.trimmedArmorItem(ModItems.COPPER_CHESTPLATE);
        this.trimmedArmorItem(ModItems.COPPER_LEGGINGS);
        this.trimmedArmorItem(ModItems.COPPER_BOOTS);
        this.handheldItem((Item)ModItems.WOODEN_PAXEL.get());
        this.handheldItem((Item)ModItems.IRON_PAXEL.get());
        this.handheldItem((Item)ModItems.STONE_PAXEL.get());
        this.handheldItem((Item)ModItems.GOLDEN_PAXEL.get());
        this.handheldItem((Item)ModItems.DIAMOND_PAXEL.get());
        this.handheldItem((Item)ModItems.NETHERITE_PAXEL.get());
        this.handheldItem((Item)ModItems.CHORUNDUM_SPEAR.get());
        this.handheldItem((Item)ModItems.COPPER_SPEAR.get());
        this.handheldItem((Item)ModItems.WOODEN_SPEAR.get());
        this.handheldItem((Item)ModItems.STONE_SPEAR.get());
        this.handheldItem((Item)ModItems.GOLDEN_SPEAR.get());
        this.handheldItem((Item)ModItems.IRON_SPEAR.get());
        this.handheldItem((Item)ModItems.DIAMOND_SPEAR.get());
        this.handheldItem((Item)ModItems.NETHERITE_SPEAR.get());
    }

    private ItemModelBuilder handheldItem(DeferredItem<?> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"expandedequipment", (String)("item/" + item.getId().getPath())));
    }

    private void trimmedArmorItem(DeferredItem<ArmorItem> itemDeferredItem) {
        String MOD_ID = "expandedequipment";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"expandedequipment", (String)("item/" + itemDeferredItem.getId().getPath())));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

