/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh;

import com.mojang.brigadier.CommandDispatcher;
import eu.midnightdust.lib.config.MidnightConfig;
import ivkond.mc.mods.eh.client.HomeKeyPressedHandler;
import ivkond.mc.mods.eh.commands.DelHomeCommand;
import ivkond.mc.mods.eh.commands.HomeCommand;
import ivkond.mc.mods.eh.commands.HomesCommand;
import ivkond.mc.mods.eh.commands.RenHomeCommand;
import ivkond.mc.mods.eh.commands.SetHomeCommand;
import ivkond.mc.mods.eh.config.EasyHomesConfig;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.Log;
import ivkond.mc.mods.eh.utils.PathUtils;
import java.nio.file.Path;
import net.minecraft.class_2168;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;

public final class EasyHomesMod {
    public static final String MOD_ID = "easy_homes";
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void init() {
        Log.info("Initializing Easy Homes Mod");
        MidnightConfig.init((String)MOD_ID, EasyHomesConfig.class);
    }

    public static void onServerStared(MinecraftServer server) {
        Path dataDir = PathUtils.getOrCreateDataDir(server);
        Log.info("Initializing Easy Homes storage");
        homes.init(dataDir);
    }

    public static void onServerStopping() {
        homes.unload();
    }

    public static void onClientTick(class_310 minecraft) {
        HomeKeyPressedHandler.handle(minecraft);
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        Log.debug("Player {} logged in. Now load configuration", player.method_5476().getString());
        homes.loadPlayerConfig(player.method_5845());
    }

    public static void onPlayerLoggedOut(class_3222 player) {
        Log.debug("Player {} logged out. Now persist and clear configuration", player.method_5476().getString());
        homes.unloadPlayerConfig(player.method_5845());
    }

    public static class_437 createConfigurationScreen(class_437 parent) {
        return MidnightConfig.getScreen((class_437)parent, (String)MOD_ID);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        HomeCommand.register(dispatcher);
        HomesCommand.register(dispatcher);
        SetHomeCommand.register(dispatcher);
        RenHomeCommand.register(dispatcher);
        DelHomeCommand.register(dispatcher);
    }
}

