/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.HomeNameSuggestionProvider;
import ivkond.mc.mods.eh.utils.HomeUtils;
import ivkond.mc.mods.eh.utils.I18N;
import ivkond.mc.mods.eh.utils.Log;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public class DelHomeCommand {
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder home = (LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).executes(DelHomeCommand::deleteHome));
        dispatcher.register(home);
    }

    private static int deleteHome(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String playerId = player.method_5845();
        String name = (String)context.getArgument("name", String.class);
        Log.info("Delete players {} home {}", player.method_5476().getString(), name);
        if (HomeUtils.isInvalidName(name)) {
            player.method_43496(I18N.errorInvalidHomeName(name));
            return 0;
        }
        if (!homes.exists(playerId, name)) {
            player.method_7353(I18N.errorHomeNotFound(name), true);
            return 0;
        }
        homes.deleteHome(playerId, name);
        player.method_7353(I18N.commandDelHomeSuccess(name), true);
        return 1;
    }
}

