/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import ivkond.mc.mods.eh.domain.HomeLocation;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.HomeNameSuggestionProvider;
import ivkond.mc.mods.eh.utils.HomeUtils;
import ivkond.mc.mods.eh.utils.I18N;
import ivkond.mc.mods.eh.utils.Log;
import java.time.Duration;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class HomeCommand {
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder home = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").executes(HomeCommand::teleportToDefaultHome)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).executes(HomeCommand::teleportToHome));
        dispatcher.register(home);
    }

    private static int teleportToDefaultHome(CommandContext<class_2168> context) throws CommandSyntaxException {
        return HomeCommand.doTeleport(context, "main");
    }

    private static int teleportToHome(CommandContext<class_2168> context) throws CommandSyntaxException {
        String homeName = (String)context.getArgument("name", String.class);
        return HomeCommand.doTeleport(context, homeName);
    }

    private static int doTeleport(CommandContext<class_2168> context, String homeName) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String playerId = player.method_5845();
        class_3218 currentLevel = source.method_9225();
        Log.info("Teleporting {} to home {}", player.method_5477().getString(), homeName);
        if (HomeUtils.isInvalidName(homeName)) {
            player.method_43496(I18N.errorInvalidHomeName(homeName));
            return 0;
        }
        HomeLocation home = homes.findHome(playerId, homeName);
        if (home == null) {
            player.method_7353(I18N.errorHomeNotFound(homeName), true);
            return 0;
        }
        Duration cooldown = homes.getCooldown(playerId);
        if (cooldown.getSeconds() > 0L) {
            player.method_7353(I18N.commandHomeLocked(cooldown), true);
            return 0;
        }
        class_2960 levelLocation = class_2960.method_12829((String)home.dimension());
        class_5321 levelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)levelLocation);
        class_3218 targetLevel = source.method_9211().method_3847(levelKey);
        if (targetLevel == null) {
            player.method_7353(I18N.errorUnknownLevel(home.dimension()), true);
            return 0;
        }
        class_2338 blockPos = class_2338.method_49637((double)home.x(), (double)home.y(), (double)home.z());
        if (!class_3218.method_25953((class_2338)blockPos)) {
            player.method_7353(I18N.errorInvalidPosition(), true);
            return 0;
        }
        HomeCommand.playDecorations(currentLevel, player.method_24515(), class_2398.field_11214);
        player.method_14251(targetLevel, home.x(), home.y(), home.z(), home.rotY(), home.rotX());
        HomeCommand.playDecorations(targetLevel, blockPos, class_2398.field_23190);
        homes.updateLockDuration(playerId);
        player.method_7353(I18N.commandHomeSuccess(homeName), true);
        return 1;
    }

    private static void playDecorations(class_3218 level, class_2338 pos, class_2400 particles) {
        level.method_14199((class_2394)particles, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 20, 0.3, 0.3, 0.3, 0.5);
        level.method_8396(null, pos, class_3417.field_46945, class_3419.field_15248, 1.0f, 1.0f);
    }
}

