/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.HomeNameSuggestionProvider;
import ivkond.mc.mods.eh.utils.HomeUtils;
import ivkond.mc.mods.eh.utils.I18N;
import ivkond.mc.mods.eh.utils.Log;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public class RenHomeCommand {
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder home = (LiteralArgumentBuilder)class_2170.method_9247((String)"renhome").then(class_2170.method_9244((String)"old_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).then(class_2170.method_9244((String)"new_name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).executes(RenHomeCommand::renameHome)));
        dispatcher.register(home);
    }

    private static int renameHome(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String playerId = player.method_5845();
        String oldName = (String)context.getArgument("old_name", String.class);
        if (HomeUtils.isInvalidName(oldName)) {
            player.method_43496(I18N.errorInvalidHomeName(oldName));
            return 0;
        }
        String newName = (String)context.getArgument("new_name", String.class);
        if (HomeUtils.isInvalidName(newName)) {
            player.method_43496(I18N.errorInvalidHomeName(newName));
            return 0;
        }
        Log.info("Rename players {} home {} to {}", player.method_5476().getString(), oldName, newName);
        boolean oldHomeExists = homes.exists(playerId, oldName);
        if (!oldHomeExists) {
            player.method_7353(I18N.errorHomeNotFound(oldName), true);
            return 0;
        }
        homes.renameHome(playerId, oldName, newName);
        player.method_7353(I18N.commandRenHomeSuccess(oldName, newName), true);
        return 1;
    }
}

