/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import ivkond.mc.mods.eh.domain.HomeLocation;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.HomeUtils;
import ivkond.mc.mods.eh.utils.I18N;
import ivkond.mc.mods.eh.utils.Log;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class SetHomeCommand {
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder home = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").executes(SetHomeCommand::setDefaultHome)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(SetHomeCommand::setHome));
        dispatcher.register(home);
    }

    private static int setHome(CommandContext<class_2168> context) throws CommandSyntaxException {
        String home = (String)context.getArgument("name", String.class);
        return SetHomeCommand.doSetHome(context, home);
    }

    private static int setDefaultHome(CommandContext<class_2168> context) throws CommandSyntaxException {
        return SetHomeCommand.doSetHome(context, "main");
    }

    private static int doSetHome(CommandContext<class_2168> context, String homeName) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        String playerId = player.method_5845();
        if ("-".equals(homeName)) {
            homeName = SetHomeCommand.generateHomeName(player);
        }
        if (HomeUtils.isInvalidName(homeName)) {
            player.method_43496(I18N.errorInvalidHomeName(homeName));
            return 0;
        }
        Log.info("Save player {} current position as home {}", player.method_5476().getString(), homeName);
        boolean existingHome = homes.exists(playerId, homeName);
        if (!existingHome && homes.isMaxHomesReached(playerId)) {
            player.method_7353(I18N.commandSetHomeMaxHomesReached(), true);
            return 0;
        }
        class_5321 levelResourceKey = player.method_37908().method_27983();
        String level = levelResourceKey.method_29177().toString();
        HomeLocation location = new HomeLocation(level, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36455(), player.method_36454());
        homes.setHome(player.method_5845(), homeName, location);
        player.method_7353(I18N.commandSetHomeSuccess(homeName, existingHome), true);
        return 1;
    }

    private static String generateHomeName(class_3222 player) {
        String dimension = player.method_37908().method_27983().method_29177().method_12832();
        class_243 position = player.method_19538();
        return String.format("%s_%.0f_%.0f_%.0f", dimension, position.field_1352, position.field_1351, position.field_1350);
    }
}

