/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import ivkond.mc.mods.eh.network.HomeDeletedPayload;
import ivkond.mc.mods.eh.network.PacketSender;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.HomeNameSuggestionProvider;
import ivkond.mc.mods.eh.utils.HomeUtils;
import ivkond.mc.mods.eh.utils.I18N;
import ivkond.mc.mods.eh.utils.Log;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class DelHomeCommand {
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder home = (LiteralArgumentBuilder)Commands.literal((String)"delhome").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).executes(DelHomeCommand::deleteHome));
        dispatcher.register(home);
    }

    private static int deleteHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String playerId = player.getStringUUID();
        String name = (String)context.getArgument("name", String.class);
        Log.info("Delete players {} home {}", player.getDisplayName().getString(), name);
        if (HomeUtils.isInvalidName(name)) {
            player.sendSystemMessage(I18N.errorInvalidHomeName(name));
            return 0;
        }
        if (!homes.exists(playerId, name)) {
            player.displayClientMessage(I18N.errorHomeNotFound(name), true);
            return 0;
        }
        homes.deleteHome(playerId, name);
        HomeDeletedPayload payload = new HomeDeletedPayload(name);
        PacketSender.send(player, payload);
        player.displayClientMessage(I18N.commandDelHomeSuccess(name), true);
        return 1;
    }
}

