/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import ivkond.mc.mods.eh.domain.HomeLocation;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.HomeNameSuggestionProvider;
import ivkond.mc.mods.eh.utils.HomeUtils;
import ivkond.mc.mods.eh.utils.I18N;
import ivkond.mc.mods.eh.utils.Log;
import java.time.Duration;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class HomeCommand {
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder home = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").executes(HomeCommand::teleportToDefaultHome)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).executes(HomeCommand::teleportToHome));
        dispatcher.register(home);
    }

    private static int teleportToDefaultHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return HomeCommand.doTeleport(context, "main");
    }

    private static int teleportToHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String homeName = (String)context.getArgument("name", String.class);
        return HomeCommand.doTeleport(context, homeName);
    }

    private static int doTeleport(CommandContext<CommandSourceStack> context, String homeName) throws CommandSyntaxException {
        Duration cooldown;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String playerId = player.getStringUUID();
        ServerLevel currentLevel = source.getLevel();
        Log.info("Teleporting {} to home {}", player.getName().getString(), homeName);
        if (HomeUtils.isInvalidName(homeName)) {
            player.sendSystemMessage(I18N.errorInvalidHomeName(homeName));
            return 0;
        }
        HomeLocation home = homes.findHome(playerId, homeName);
        if (home == null) {
            player.displayClientMessage(I18N.errorHomeNotFound(homeName), true);
            return 0;
        }
        if (!player.isCreative() && (cooldown = homes.getCooldown(playerId)).isPositive()) {
            player.displayClientMessage(I18N.commandHomeLocked(cooldown), true);
            return 0;
        }
        ResourceLocation levelLocation = ResourceLocation.parse((String)home.dimension());
        ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)levelLocation);
        ServerLevel targetLevel = source.getServer().getLevel(levelKey);
        if (targetLevel == null) {
            player.displayClientMessage(I18N.errorUnknownLevel(home.dimension()), true);
            return 0;
        }
        BlockPos blockPos = BlockPos.containing((double)home.x(), (double)home.y(), (double)home.z());
        if (!ServerLevel.isInSpawnableBounds((BlockPos)blockPos)) {
            player.displayClientMessage(I18N.errorInvalidPosition(), true);
            return 0;
        }
        HomeCommand.playDecorations(currentLevel, player.blockPosition(), ParticleTypes.PORTAL);
        player.teleportTo(targetLevel, home.x(), home.y(), home.z(), Set.of(), home.rotY(), home.rotX(), false);
        HomeCommand.playDecorations(targetLevel, blockPos, ParticleTypes.REVERSE_PORTAL);
        homes.updateLockDuration(playerId);
        player.displayClientMessage(I18N.commandHomeSuccess(homeName), true);
        return 1;
    }

    private static void playDecorations(ServerLevel level, BlockPos pos, SimpleParticleType particles) {
        level.sendParticles((ParticleOptions)particles, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 20, 0.3, 0.3, 0.3, 0.5);
        level.playSound(null, pos, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

