/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import ivkond.mc.mods.eh.network.HomeRenamedPayload;
import ivkond.mc.mods.eh.network.PacketSender;
import ivkond.mc.mods.eh.storage.HomeRepository;
import ivkond.mc.mods.eh.utils.HomeNameSuggestionProvider;
import ivkond.mc.mods.eh.utils.HomeUtils;
import ivkond.mc.mods.eh.utils.I18N;
import ivkond.mc.mods.eh.utils.Log;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class RenHomeCommand {
    private static final HomeRepository homes = HomeRepository.INSTANCE;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder home = (LiteralArgumentBuilder)Commands.literal((String)"renhome").then(Commands.argument((String)"old_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).then(Commands.argument((String)"new_name", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)HomeNameSuggestionProvider.INSTANCE).executes(RenHomeCommand::renameHome)));
        dispatcher.register(home);
    }

    private static int renameHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String playerId = player.getStringUUID();
        String oldName = (String)context.getArgument("old_name", String.class);
        if (HomeUtils.isInvalidName(oldName)) {
            player.sendSystemMessage(I18N.errorInvalidHomeName(oldName));
            return 0;
        }
        String newName = (String)context.getArgument("new_name", String.class);
        if (HomeUtils.isInvalidName(newName)) {
            player.sendSystemMessage(I18N.errorInvalidHomeName(newName));
            return 0;
        }
        Log.info("Rename players {} home {} to {}", player.getDisplayName().getString(), oldName, newName);
        boolean oldHomeExists = homes.exists(playerId, oldName);
        if (!oldHomeExists) {
            player.displayClientMessage(I18N.errorHomeNotFound(oldName), true);
            return 0;
        }
        homes.renameHome(playerId, oldName, newName);
        HomeRenamedPayload payload = new HomeRenamedPayload(oldName, newName);
        PacketSender.send(player, payload);
        player.displayClientMessage(I18N.commandRenHomeSuccess(oldName, newName), true);
        return 1;
    }
}

