/*
 * Decompiled with CFR 0.152.
 */
package ivkond.mc.mods.eh.utils;

import ivkond.mc.mods.eh.domain.HomeLocation;
import ivkond.mc.mods.eh.domain.PlayerHomes;
import java.time.Duration;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class I18N {
    private I18N() {
    }

    public static Component commandHomeSuccess(String name) {
        return Component.translatable((String)"easy_homes.commands.home.success", (Object[])new Object[]{I18N.formatHome(name)});
    }

    public static Component commandHomeLocked(Duration lockDuration) {
        String expiration = Long.toString(lockDuration.getSeconds());
        MutableComponent expirationComponent = Component.literal((String)expiration).withStyle(ChatFormatting.GOLD);
        return Component.translatable((String)"easy_homes.commands.home.too_fast", (Object[])new Object[]{expirationComponent}).withStyle(ChatFormatting.RED);
    }

    public static Component commandHomesList(PlayerHomes playerHomes) {
        Map<String, HomeLocation> homes = playerHomes.getAllHomes();
        if (homes == null || homes.isEmpty()) {
            MutableComponent command = Component.literal((String)"/sethome <name>").withStyle(ChatFormatting.DARK_AQUA);
            return Component.translatable((String)"easy_homes.commands.list_homes.empty", (Object[])new Object[]{command});
        }
        MutableComponent response = Component.literal((String)"===== ").append((Component)Component.translatable((String)"easy_homes.commands.list_homes.header")).append(" =====\n");
        homes.forEach((name, home) -> {
            MutableComponent coordinatesComponent = Component.literal((String)home.coordinates()).withStyle(ChatFormatting.DARK_AQUA);
            MutableComponent item = Component.literal((String)" - ").append((Component)Component.translatable((String)"easy_homes.commands.list_homes.item", (Object[])new Object[]{I18N.formatHome(name), home.dimension(), coordinatesComponent})).append("\n");
            response.append((Component)item);
        });
        return response;
    }

    public static Component commandSetHomeSuccess(String homeName, boolean existingHome) {
        return Component.translatable((String)(existingHome ? "easy_homes.commands.set_home.success.existing" : "easy_homes.commands.set_home.success.new"), (Object[])new Object[]{I18N.formatHome(homeName)});
    }

    public static Component commandSetHomeMaxHomesReached() {
        return Component.translatable((String)"easy_homes.commands.set_home.max_homes_reached").withStyle(ChatFormatting.RED);
    }

    public static Component commandRenHomeSuccess(String oldName, String newName) {
        return Component.translatable((String)"easy_homes.commands.ren_home.success", (Object[])new Object[]{I18N.formatHome(oldName), I18N.formatHome(newName)});
    }

    public static Component commandDelHomeSuccess(String homeName) {
        return Component.translatable((String)"easy_homes.commands.del_home.success", (Object[])new Object[]{I18N.formatHome(homeName)});
    }

    public static Component errorHomeNotFound(String name) {
        return Component.translatable((String)"easy_homes.commands.errors.home_not_found", (Object[])new Object[]{I18N.formatHome(name)}).withStyle(ChatFormatting.RED);
    }

    public static Component errorUnknownLevel(String name) {
        MutableComponent nameComponent = Component.literal((String)name).withStyle(ChatFormatting.DARK_AQUA);
        return Component.translatable((String)"easy_homes.commands.errors.level_not_found", (Object[])new Object[]{nameComponent}).withStyle(ChatFormatting.RED);
    }

    public static Component errorInvalidPosition() {
        return Component.translatable((String)"easy_homes.commands.errors.invalid_position").withStyle(ChatFormatting.RED);
    }

    public static Component errorInvalidHomeName(String homeName) {
        return Component.translatable((String)"easy_homes.commands.errors.invalid_home_name", (Object[])new Object[]{I18N.formatHome(homeName)}).withStyle(ChatFormatting.RED);
    }

    public static Component formatHome(String homeName) {
        return Component.literal((String)homeName).withStyle(ChatFormatting.GOLD);
    }
}

