/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects.candles;

import com.mcwlights.kikoz.objects.candles.CandleHolder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WallCandle
extends CandleHolder {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape NORTH = Block.box((double)4.5, (double)3.0, (double)7.0, (double)11.5, (double)14.0, (double)16.0);
    private static final VoxelShape WEST = Block.box((double)7.0, (double)3.0, (double)4.5, (double)16.0, (double)14.0, (double)11.5);
    private static final VoxelShape SOUTH = Block.box((double)4.5, (double)3.0, (double)0.0, (double)11.5, (double)14.0, (double)9.0);
    private static final VoxelShape EAST = Block.box((double)0.0, (double)3.0, (double)4.5, (double)9.0, (double)14.0, (double)11.5);

    public WallCandle(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.getValue(FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
        }
        return WEST;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 1.0;
        double d2 = (double)pos.getZ() + 0.5;
        Direction direction = (Direction)state.getValue(FACING);
        switch (direction) {
            case NORTH: {
                d2 += 0.15;
                break;
            }
            case SOUTH: {
                d2 -= 0.15;
                break;
            }
            case EAST: {
                d0 -= 0.15;
                break;
            }
            case WEST: {
                d0 += 0.15;
                break;
            }
        }
        Boolean i = (Boolean)state.getValue((Property)LIT);
        if (i.booleanValue()) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

