/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightBaseShort
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape ONE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape BASE = Shapes.or((VoxelShape)ONE, (VoxelShape[])new VoxelShape[0]);

    public LightBaseShort(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == this.asItem()) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.cycle((Property)LIT);
        worldIn.setBlock(pos, state, 10);
        worldIn.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.levelEvent(1029, pos, 0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BASE;
    }

    protected void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block block, @Nullable Orientation dir, boolean bool) {
        boolean flag;
        if (!worldIn.isClientSide() && (flag = worldIn.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)POWERED)) {
            if ((Boolean)state.getValue((Property)LIT) != flag) {
                state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(flag));
                worldIn.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
            }
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = this.defaultBlockState();
        if (context.getLevel().hasNeighborSignal(context.getClickedPos())) {
            blockstate = (BlockState)((BlockState)blockstate.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return blockstate;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{LIT, POWERED});
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return super.updateShape(state, level, ticker, currentPos, facing, facingPos, facingState, random);
    }
}

