/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TorchObject
extends FaceAttachedHorizontalDirectionalBlock {
    protected final ParticleOptions flame;
    protected static final VoxelShape BOT = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);

    public TorchObject(BlockBehaviour.Properties properties, ParticleOptions flame) {
        super(properties);
        this.flame = flame;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return TorchObject.m_53196_((LevelReader)world, (BlockPos)pos, (Direction)TorchObject.m_53200_((BlockState)state).m_122424_()) && state.m_61143_((Property)f_53179_) != AttachFace.CEILING;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                return BOT;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return EAST;
                    }
                    case WEST: {
                        return WEST;
                    }
                    case SOUTH: {
                        return SOUTH;
                    }
                    case NORTH: {
                        return NORTH;
                    }
                    case UP: {
                        return BOT;
                    }
                    case DOWN: {
                        return BOT;
                    }
                }
            }
            case CEILING: {
                return BOT;
            }
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, f_53179_});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction direction = (Direction)stateIn.m_61143_((Property)f_54117_);
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.7;
        double d2 = (double)pos.m_123343_() + 0.5;
        Direction direction1 = direction.m_122424_();
        switch ((AttachFace)stateIn.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.m_7106_(this.flame, d0, d1, d2, 0.0, 0.0, 0.0);
                break;
            }
            case WALL: {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
                worldIn.m_7106_(this.flame, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
                break;
            }
        }
    }
}

