/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.objects.LightBaseShort;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallLamp
extends LightBaseShort {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<DyeColor> DYE_COLOR = EnumProperty.create((String)"dye_color", DyeColor.class);
    private static final VoxelShape NORTH = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SOUTH = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST = Block.box((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);

    public WallLamp(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue(DYE_COLOR, (Comparable)DyeColor.WHITE)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return Shapes.empty();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        DyeColor dyeColor = this.getDyeColor(context.getItemInHand());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(DYE_COLOR, (Comparable)dyeColor);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, FACING, DYE_COLOR, POWERED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(handIn);
        Item item = heldItem.getItem();
        if (item instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)item).getDyeColor();
            BlockState newState = (BlockState)state.setValue(DYE_COLOR, (Comparable)dyeColor);
            worldIn.setBlockAndUpdate(pos, newState);
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (item != this.asItem()) {
            state = (BlockState)state.cycle((Property)LIT);
            worldIn.setBlock(pos, state, 10);
            worldIn.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private DyeColor getDyeColor(ItemStack stack) {
        if (stack.getItem() instanceof DyeItem) {
            return ((DyeItem)stack.getItem()).getDyeColor();
        }
        return DyeColor.WHITE;
    }
}

