ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments} = event
    event.register(
        Commands.literal("eop_infinite_energy")
        .then(Commands.argument('entity', Arguments.PLAYER.create(event))
		.then(Commands.argument('on/off', Arguments.STRING.create(event))
				.suggests((ctx, builder) => {
			builder.suggest("on")
			builder.suggest("off")
			 return builder.buildFuture()
			 })
            .executes(ctx => {
				const toggle_type = Arguments.STRING.getResult(ctx, "on/off")

					let player = ctx.source.player
                    let target = Arguments.PLAYER.getResult(ctx, 'entity')

                        
					if (toggle_type == "on") {
                         player.runCommandSilent(`execute as ${target.uuid} at @s run tag @s add EOP.Inf.Energy`)
                    }
						
					if (toggle_type == "off") {
                    player.runCommandSilent(`execute as ${target.uuid} at @s run tag @s remove EOP.Inf.Energy`)
                     }        
                 return 1
                })
		)
    )
    )
})