StartupEvents.registry("palladium:abilities", event => {
    const MotionPacket = Java.loadClass("net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket")

    const PROP_SPEED_GLIDE = "glide_speed"
    const PROP_SPEED_DROP = "drop_speed"
    const PROP_GRAVITY = "gravity"
    const PROP_ELYTRA_GLIDE = "elytra_glide"

    event
        .create("sgoc:glide")
        .addProperty(PROP_ELYTRA_GLIDE, "boolean", true, "To use elytra-style gliding or not. If false, it will simply be gliding, you cannot regain altitude by dive bombing.")
        .addProperty(PROP_SPEED_GLIDE, "float", 0.99, "How fast you glide horizontally, acts as a multiplier")
        .addProperty(PROP_SPEED_DROP, "float", 0.98, "How fast you fall. If elytra_glide is enabled, it is a multiplier. Otherwise, it is the minimum force of gravity if you look straight ahead.")
        .addProperty(PROP_GRAVITY, "float", 0.08, "Base gravity.")
        .tick((entity, entry, holder, enabled) => {
            if (!enabled || entity.onGround()) return

            const elytra_glide = entry.getPropertyByName(PROP_ELYTRA_GLIDE)
            const speed_glide = entry.getPropertyByName(PROP_SPEED_GLIDE)
            const speed_drop = entry.getPropertyByName(PROP_SPEED_DROP)
            const gravity = entry.getPropertyByName(PROP_GRAVITY)
            const lookVec = entity.getLookAngle()
            let deltaMoveVec = entity.getDeltaMovement()

            if (elytra_glide) {
                const pitchRad = (entity.getPitch() * KMath.PI) / 180
                const pitchLength = JavaMath.cos(pitchRad)
                const lookMagnitude = lookVec.horizontalDistance()
                const moveMagnitude = deltaMoveVec.horizontalDistance()
                const lookLength = lookVec.length()

                pitchLength = pitchLength * pitchLength * JavaMath.min(1, lookLength / 0.4)
                deltaMoveVec = entity.getDeltaMovement().add(0, gravity * (-1 + pitchLength * 0.75), 0)

                if (deltaMoveVec.y() < 0 && lookMagnitude > 0) {
                    const newY = deltaMoveVec.y() * -pitchLength
                    deltaMoveVec = deltaMoveVec.add((lookVec.x() * newY) / lookMagnitude, newY, (lookVec.z() * newY) / lookMagnitude)
                }

                if (pitchRad < 0 && lookMagnitude > 0) {
                    const newY = moveMagnitude * -JavaMath.sin(pitchRad) * 0.04
                    deltaMoveVec = deltaMoveVec.add((-lookVec.x() * newY) / lookMagnitude, newY * 3.2, (lookVec.z() * newY) / lookMagnitude)
                }

                if (lookMagnitude > 0) {
                    deltaMoveVec = deltaMoveVec.add(((lookVec.x() / lookMagnitude) * moveMagnitude - deltaMoveVec.x()) * 0.1, 0, ((lookVec.z() / lookMagnitude) * moveMagnitude - deltaMoveVec.z()) * 0.1)
                }

                deltaMoveVec = deltaMoveVec.multiply(speed_glide, speed_drop, speed_glide)
            } else {
                const addMoveVec = lookVec.scale(speed_glide)

                deltaMoveVec = new Vec3d(deltaMoveVec.x() + addMoveVec.x(), KMath.clamp(addMoveVec.y(), -gravity, -speed_drop), deltaMoveVec.z() + addMoveVec.z()) //.add(addMoveVec.x(), 0, addMoveVec.z())
            }

            entity.fallDistance = 0
            entity.setDeltaMovement(deltaMoveVec)

            if (entity.isPlayer()) {
                entity.connection.send(new MotionPacket(entity))
            }
        })
})
