StartupEvents.registry('palladium:abilities', (event) => {

    event.create('sgoc:geo_armor_giant')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('Changes the material for the geokinetic giant. Only useful for Geokinesis')

		.addProperty('score', 'string', 'scoreboard_name', 'the scoreboard that the type is put in')
        .addProperty('needs', 'integer', 6, 'the required amount of any 1 block')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				const score = entry.getPropertyByName('score');
				const needs = entry.getPropertyByName('needs');
                let username = entity.getGameProfile().getName();
                let username_true = username.toLowerCase();

                let max_type = global.material_types;

                for (let types = 0; types <= max_type; types++) {
                    entity.persistentData['stone_type_' + types] = 0
                }
					
                for (let pos of BlockPos.betweenClosed(new BlockPos(entity.x + 5, entity.y + 5, entity.z + 5), [entity.x - 5, entity.y - 5, entity.z - 5])) {
                    
                for (let types = 0; types <= max_type; types++) {
                    let material_type = global['stone_type_' + types].toString();
                    if(entity.getLevel().getBlock(pos).id === material_type) {
                        entity.persistentData['stone_type_' + types] = entity.persistentData['stone_type_' + types] + 1
                        }
                    }
                }
                // select rock type
                let check_type = -1	
                for (let types = 0; types <= max_type; types++) {
                    let total = entity.persistentData['stone_type_' + types]
                         if (total >= needs) {
                            if (types > check_type) {
                                check_type = types
                        }
                    }
                }
                entity.server.runCommandSilent("execute as " + username + " at @s run execute if entity @s run scoreboard players set @e[tag=EOP.Earth.Giant,type=piglin,sort=nearest,distance=..2,limit=1] " + score + " " + check_type + "");

            }
        })
});
