StartupEvents.registry('palladium:abilities', (event) => {
    event.create('sgoc:take_damage')
        .icon(palladium.createItemIcon('minecraft:iron_sword'))
        .documentationDescription('Removes 1 durability from an item')
        .addProperty("item", "string", "sgoc:item", "the item that you are using")
        .addProperty("max_durability", "string", "4", "max durability of the item")

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                let username = entity.getGameProfile().getName();
                let item = entry.getPropertyByName('item');
                let max = entry.getPropertyByName('max_durability');
                entity.persistentData.sgocitemdamage = entity.mainHandItem.nbt.Damage;
                entity.persistentData.sgocitemdamage += 1;
                let item_damage = entity.persistentData.sgocitemdamage;
                entity.server.runCommandSilent("execute as " + username + " at @s run item modify entity @s weapon.mainhand with " + item + "{Damage:" + item_damage + "}");
                if (entity.persistentData.sgocitemdamage == max) {
                    entity.server.runCommandSilent("execute as " + username + " at @s run item replace entity @s weapon.mainhand with minecraft:air");
                    entity.server.runCommandSilent("execute as " + username + " at @s run playsound minecraft:item.shield.break ambient @s ~ ~ ~ 1 1");
				}



            }
        });
});