StartupEvents.registry('palladium:abilities', event => {


    function rayTrace(entity, distance, has_entity)
    {
        if (!has_entity)
            {
                return entity.rayTrace(distance)
            } else {
                return true;
            }
    }

    function passCriteria(hitEntity, max_hearts)
    {
        return hitEntity && hitEntity.maxHealth <= max_hearts && !hitEntity.isPlayer()
    }

    let hitEntity;

    event.create('sgoc:telekinesis')
    .addProperty("distance", "integer", 16, "Distance of the Raytrace")
    .addProperty("multiplier", "float", 1.0, "Power of the Magnetism")
    .addProperty("max_hearts", "integer", 20, "The Max Amount of Hearts an Entity Can Have Before You Can't Pick Them Up.")
    .addUniqueProperty("has_entity", "boolean", false)
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled)
            {
                let distance = entry.getPropertyByName("distance");
                let has_entity = entry.getPropertyByName("has_entity");
                let rayTraceResult = rayTrace(entity, distance, has_entity);
                if (rayTraceResult.entity)
                    {
                        hitEntity = rayTraceResult.entity;
                        entry.setUniquePropertyByName("has_entity", true)
                    }
            }
    })
    .tick((entity, entry, holder, enabled) => {
        if (enabled)
            {

                let has_entity = entry.getPropertyByName("has_entity");
                let lookAngle = entity.getLookAngle().scale(5);

                let playerLocation = Vec3d(entity.getX(), 
                (entity.getY() + 1.0), entity.getZ());

                let targetLocation = Vec3d(
                    (playerLocation.x() + lookAngle.x()), 
                    (playerLocation.y() + lookAngle.y()), 
                    (playerLocation.z() + lookAngle.z()));
                

                if (has_entity && passCriteria(hitEntity, entry.getPropertyByName("max_hearts")) && hitEntity.type !== 'minecraft:armor_stand')
                    {
                        let Multiplier = entry.getPropertyByName("multiplier")
                        let Target = Vec3d(
                            (hitEntity.getX() - targetLocation.x()), 
                            (hitEntity.getY() - targetLocation.y()), 
                            (hitEntity.getZ() - targetLocation.z())).scale(-1)

                        hitEntity.setNoGravity(true);
                        hitEntity.resetFallDistance();
                        hitEntity.setDeltaMovement(Target.scale(Target.length() * Multiplier));
                    }
                    
                
            }
    }).lastTick((entity, entry, holder, enabled) => {
        if (enabled && passCriteria(hitEntity, entry.getPropertyByName("max_hearts")))
            {
                entry.setUniquePropertyByName("has_entity", false);
                hitEntity.setNoGravity(false);
            }
    })
})