(function () {
    let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');


StartupEvents.registry('palladium:abilities', (event) => {

    event.create('sgoc:wall_climb')

        .icon(palladium.createItemIcon('sgoc:logo'))
	.documentationDescription('Allows you to climb walls.')

        .addProperty('climb_speed', 'float', 0.1, 'Climbing speed.')
		.addProperty("data_name", "string", "climb", "Persistent data used")


		.lastTick((entity, entry, holder, enabled) => {
				if (enabled) {
					let data_name = entry.getPropertyByName('data_name');
					entity.persistentData[data_name] = 0;
					}
					})
					
					
        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
				let climb_speed = entry.getPropertyByName('climb_speed');
				let data_name = entry.getPropertyByName('data_name');
		let head_rotation = entity.pitch	
        let level = entity.level;
		entity.persistentData[data_name] = 0;
		let climb_block = 0
		
			let currentPosup = new BlockPos(rayTrace(entity, 1).x, rayTrace(entity, 1).y, rayTrace(entity, 1).z);

            let blockState = level.getBlock(currentPosup).blockState;
            if (!blockState.isAir() && blockState.isCollisionShapeFullBlock(level, currentPosup)) {
				entity.persistentData[data_name] = 1;
				entity.setMotion(0, 0, 0);
				entity.persistentData[data_name] = 1;
				
				if (head_rotation <= -70 && head_rotation >= -90) {
					entity.persistentData[data_name] = 4;
				entity.setMotion(0, climb_speed, 0);
				}
				if (head_rotation <= 90 && head_rotation >= 70) {
					entity.persistentData[data_name] = 4;
				entity.setMotion(0, (climb_speed * -1), 0);
					}
			
				entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
						}
			}

        })
});
})();

function containsTag(tags, tag) {
    for (let i = 0; i < tags.length; i++) {
        if(tags[i].equals(tag)) {
            return true;
        }
    }
    return false;
}


function rayTrace(entity, distance) {

    const x_rad = 0
    const y_rad = entity.yaw * JavaMath.PI / 180;

    const dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    };

    const PosVec = {
        x: entity.x + (distance * dirV.x),
        y: (entity.y + 1) + (distance * dirV.y) + 0.4,
        z: entity.z + (distance * dirV.z)
    }

    for (let i = -1; i < distance * 2; i++) {
        let delta = i / 10 / distance
        let x = (1 - delta) * entity.x + delta * (PosVec.x)
        let y = (1 - delta) * entity.y + 1.52 + delta * (PosVec.y)
        let z = (1 - delta) * entity.z + delta * (PosVec.z)

        let block = entity.serverLevel().getBlock(x, y, z)
        if (!block.equals('minecraft:air')) {

            return {
                block: block,
                x: PosVec.x,
                y: PosVec.y,
                z: PosVec.z
            }
        }
    }

    return {
        x: PosVec.x,
        y: PosVec.y,
        z: PosVec.z
    }
}
