StartupEvents.registry("palladium:abilities", event => {
  event.create("sgoc:ender_chest")
    .icon(palladium.createItemIcon("minecraft:ender_chest"))
    .documentationDescription("Open your Ender Chest once when enabled.")
    .tick((entity, entry, holder, enabled) => {
      if (!entity || !entity.isPlayer()) return;

      // Server-only guard (Fabric dedicated server has no client context)
      const level = entity.level;
      if (!level || level.isClientSide()) return;

      // Open once per enable; reset when disabled
      const flagKey = "fsang.enderchest.did_open";

      if (!enabled) {
        if (entity.persistentData.getBoolean(flagKey)) {
          entity.persistentData.remove(flagKey);
        }
        return;
      }

      if (!entity.persistentData.getBoolean(flagKey)) {
        entity.openInventoryGUI(
          entity.enderChestInventory,
          Component.translatable("container.enderchest")
        );
        entity.persistentData.putBoolean(flagKey, true);
      }
    });
});