ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event

    let blacklist = ['command_block', 'bedrock', 'light', 'jigsaw', 'structure', 'barrier', 'debug_stick', 'spawner',
        'spawn_egg', 'spawner', 'awakening_crystal', 'power_randomizer', 'awakening_cleanser', 'awakening_crystal_a',
        'awakening_crystal_e', 'awakening_crystal_re', 'awakening_crystal_rm', 'awakening_crystal_ex', 'awakening_crystal_s',
        'chimera_orb', 'fusion_catalyst', 'pocket_floor', 'diff_diamond_block', 'diff_magma_block', 'dna_capsule'
    ]

    event.register(
        Commands.literal('eop_reality_items')
            .then(Commands.argument('entity', Arguments.PLAYER.create(event))
                .then(Commands.argument('item', Arguments.STRING.create(event))
                    .then(Commands.argument('count', Arguments.INTEGER.create(event))
                        .executes(ctx => {
                            let item = Arguments.STRING.getResult(ctx, 'item');
                            let count = Arguments.INTEGER.getResult(ctx, 'count');
                            let target = Arguments.PLAYER.getResult(ctx, 'entity');
                            let player = ctx.source.player;
                            if (blacklist.some(string => item.includes(string))) {
                                ctx.source.sendFailure(Text.of(`§fThis item's power is too immense for you to create`));
                                return 0;
                            } else if (abilityUtil.hasPower(player, 'sgoc:warper')) {
                                if (!player.tags.contains('EOP.RM.Awakened')) {
                                    ctx.source.sendFailure(Text.of(`§fYou have not awakened the full power of §4Reality Manipulation§f, which means you cannot use this feature`));
                                    return 0;
                                } else if (player.tags.contains('EOP.RM.Awakened')) {
                                    target.give(Item.of(`${item}`, count))
                                    let targetName = target.getGameProfile().getName();
                                    let successMessage = `Gave ${count} of ${item} to ${targetName}`;
                                    ctx.source.sendSuccess(Text.of(successMessage), true);
                                    return 1;
                                }
                            } else {
                                ctx.source.sendFailure(Text.of('§fYou do not have §4Reality Manipulation§f, which means you cannot use this feature'));
                                return 0;
                            }
                        })
                    ))
            ))
});