ServerEvents.commandRegistry(event => {
const { commands: Commands, arguments: Arguments} = event

    event.register(
        Commands.literal("echoesofpower")
        .then(Commands.argument('entity', Arguments.PLAYER.create(event))
		.then(Commands.argument('power', Arguments.WORD.create(event))
		.suggests((ctx, builder) => {
		let powers = global.eoppowers;
		for (let power_list = 0; power_list <= powers; power_list++) {
		let power_lim = global['eoppower_' + power_list].toString();
		builder.suggest(power_lim.toString())
		}
		return builder.buildFuture()
		})
		.then(Commands.argument('number', Arguments.STRING.create(event))
		.suggests((ctx, builder) => {
		builder.suggest("1")
		builder.suggest("0")
		return builder.buildFuture()
		})
        .executes(ctx => {
        const power = Arguments.WORD.getResult(ctx, "power")
        const number = Arguments.STRING.getResult(ctx, "number")


		let server = ctx.source.getServer()	
		let target = Arguments.PLAYER.getResult(ctx, 'entity')
		let player = ctx.source.player	
		player.runCommandSilent(`execute as ${target.uuid} as @s run scoreboard players set @s EOP.Powers.${power} ${number}`)		
        return 1
        })
		)
		)
	)
    )
})