ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments} = event
    event.register(
        Commands.literal("eop_dimension_denied")
		.then(Commands.argument('on/off', Arguments.STRING.create(event))
			.suggests((ctx, builder) => {
		builder.suggest("on")
		builder.suggest("off")
		 return builder.buildFuture()
			})
                .executes(ctx => {
					const toggle_type = Arguments.STRING.getResult(ctx, "on/off")

					let player = ctx.source.player
					let username = player.getGameProfile().getName();
                      let server = ctx.source.getServer()
                       let position = ctx.source.getPosition()
                       let dimension = ctx.source.getLevel().getDimension()
                        
					if (toggle_type == "on") {
                      server.runCommandSilent(`execute as ${username} at @s run execute unless entity @s[palladium.power=sgoc:drifter] run tag @s add PD.Permission.Denied`)
					server.runCommandSilent(`execute as ${username} at @s run tellraw @s [\"\",{\"text\":\"You deny people permission to teleport you to their Pocket Dimension.\",\"color\":\"white\"}]`)
                      }
						
						if (toggle_type == "off") {
                        server.runCommandSilent(`execute as ${username} at @s run execute unless entity @s[palladium.power=sgoc:drifter] run tag @s remove PD.Permission.Denied`)
						server.runCommandSilent(`execute as ${username} at @s run tellraw @s [\"\",{\"text\":\"You allow people to teleport you to their Pocket Dimension.\",\"color\":\"white\"}]`)
                        }
						
						
                    return 1
                })
		)
    )
})