ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments} = event
    event.register(
        Commands.literal("eop_wiki")
		.then(Commands.argument('link', Arguments.STRING.create(event))
				.suggests((ctx, builder) => {
			builder.suggest("link")
			
			 return builder.buildFuture()
			 })
                    .executes(ctx => {
						const toggle_type = Arguments.STRING.getResult(ctx, "link")

						let player = ctx.source.player
						let username = player.getGameProfile().getName();
                        let server = ctx.source.getServer()
                        let position = ctx.source.getPosition()
                        let dimension = ctx.source.getLevel().getDimension()
                        
						if (toggle_type == "link") {
                        server.runCommandSilent(`execute as ${username} at @s run tellraw @s ["",{"text":"All the information you could ever want can be found by clicking ","color":"aqua"},{"text":"here!","clickEvent":{"action":"open_url","value":"https://echoes-of-power.fandom.com/wiki/Echoes_of_Power_Wiki"},"color":"light_purple"},{"text":" Otherwise, ask in my ","color":"aqua"},{"text":"discord!","clickEvent":{"action":"open_url","value":"https://discord.gg/2K7quhrdrr"},"color":"dark_purple"}]`)    
                        }
                    return 1
                })
		)
    )
})