/*
 * Decompiled with CFR 0.152.
 */
package com.kasetoatz.hungryfrog.task;

import com.google.common.collect.ImmutableMap;
import com.kasetoatz.hungryfrog.HungryFrog;
import com.kasetoatz.hungryfrog.mixin.EntityAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4050;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_7102;

public class FrogEatBlockTask
extends class_4097<class_7102> {
    public static final class_3414 TONGUE_SOUND = class_3417.field_37320;
    public static final class_3414 EAT_SOUND = class_3417.field_37315;
    private int eatTick;
    private int moveToTargetTick;
    private Phase phase = Phase.DONE;

    public FrogEatBlockTask() {
        super((Map)ImmutableMap.of(HungryFrog.BLOCK_TO_EAT, (Object)class_4141.field_18456), 100);
    }

    protected boolean shouldRun(class_3218 world, class_7102 frog) {
        Optional memory = frog.method_18868().method_18904(HungryFrog.BLOCK_TO_EAT);
        if (memory.isEmpty()) {
            return false;
        }
        class_2338 pos = (class_2338)memory.get();
        boolean reachable = this.isBlockReachable(frog, pos);
        if (!reachable) {
            frog.method_18868().method_18875(HungryFrog.BLOCK_TO_EAT);
            this.markTargetAsUnreachable(frog, pos);
        }
        return reachable && frog.method_18376() != class_4050.field_37422 && frog.method_18868().method_18904(class_4140.field_22355).isEmpty();
    }

    protected boolean shouldKeepRunning(class_3218 world, class_7102 frog, long time) {
        return frog.method_18868().method_18896(HungryFrog.BLOCK_TO_EAT) && this.phase != Phase.DONE && !frog.method_18868().method_18896(class_4140.field_39408);
    }

    protected void run(class_3218 world, class_7102 frog, long time) {
        Optional value = frog.method_18868().method_18904(HungryFrog.BLOCK_TO_EAT);
        if (value.isEmpty()) {
            return;
        }
        class_2338 pos = (class_2338)value.get();
        frog.method_5702(class_2183.class_2184.field_9851, class_243.method_24954((class_2382)pos));
        frog.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(pos, 2.0f, 0));
        this.moveToTargetTick = 10;
        this.phase = Phase.MOVE_TO_TARGET;
    }

    protected void finishRunning(class_3218 world, class_7102 frog, long time) {
        frog.method_18868().method_18875(HungryFrog.BLOCK_TO_EAT);
        frog.method_18380(class_4050.field_18076);
    }

    private void absorb(class_3218 world, class_2338 pos) {
        class_2338.method_49925((class_2338)pos, (int)6, (int)65, (currentPos, queuer) -> {
            for (class_2350 direction : class_2350.values()) {
                queuer.accept(currentPos.method_10093(direction));
            }
        }, currentPos -> {
            class_2263 fluidDrainable;
            if (currentPos.equals((Object)pos)) {
                return class_2338.class_10384.field_55165;
            }
            class_2680 blockState = world.method_8320(currentPos);
            class_3610 fluidState = world.method_8316(currentPos);
            if (!fluidState.method_15767(class_3486.field_15517) && !fluidState.method_15767(class_3486.field_15518)) {
                return class_2338.class_10384.field_55166;
            }
            class_2248 patt0$temp = blockState.method_26204();
            if (patt0$temp instanceof class_2263 && !(fluidDrainable = (class_2263)patt0$temp).method_9700(null, (class_1936)world, currentPos, blockState).method_7960()) {
                return class_2338.class_10384.field_55165;
            }
            if (blockState.method_26204() instanceof class_2404) {
                world.method_8652(currentPos, class_2246.field_10124.method_9564(), 3);
            } else {
                if (!(blockState.method_27852(class_2246.field_9993) || blockState.method_27852(class_2246.field_10463) || blockState.method_27852(class_2246.field_10376) || blockState.method_27852(class_2246.field_10238))) {
                    return class_2338.class_10384.field_55166;
                }
                world.method_8652(currentPos, class_2246.field_10124.method_9564(), 3);
            }
            return class_2338.class_10384.field_55165;
        });
    }

    private void eat(class_3218 world, class_7102 frog, class_2338 pos) {
        world.method_43129(null, (class_1297)frog, EAT_SOUND, class_3419.field_15254, 2.0f, 1.0f);
        class_2680 state = world.method_8320(pos);
        class_1792 item = (class_1792)class_1792.field_8003.get(state.method_26204());
        if (state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10164)) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            this.absorb(world, pos);
        } else {
            world.method_8650(pos, false);
        }
        if (item == null) {
            return;
        }
        class_1799 stack = new class_1799((class_1935)item);
        class_1542 entity = new class_1542((class_1937)world, frog.method_23317(), frog.method_23318(), frog.method_23321(), stack);
        world.method_8649((class_1297)entity);
    }

    protected void keepRunning(class_3218 world, class_7102 frog, long time) {
        Optional memory = frog.method_18868().method_18904(HungryFrog.BLOCK_TO_EAT);
        if (memory.isEmpty()) {
            return;
        }
        class_2338 pos = (class_2338)memory.get();
        switch (this.phase.ordinal()) {
            case 0: {
                if (((EntityAccessor)frog).getPos().method_1022(class_243.method_24954((class_2382)pos)) < 1.75) {
                    world.method_43129(null, (class_1297)frog, TONGUE_SOUND, class_3419.field_15254, 2.0f, 1.0f);
                    frog.method_18380(class_4050.field_37423);
                    this.eatTick = 0;
                    this.phase = Phase.CATCH_ANIMATION;
                    break;
                }
                if (this.moveToTargetTick <= 0) {
                    frog.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(pos, 2.0f, 0));
                    this.moveToTargetTick = 10;
                    break;
                }
                --this.moveToTargetTick;
                break;
            }
            case 1: {
                if (this.eatTick++ < 6) break;
                this.phase = Phase.EAT_ANIMATION;
                this.eat(world, frog, pos);
                break;
            }
            case 2: {
                if (this.eatTick >= 10) {
                    this.phase = Phase.DONE;
                    break;
                }
                ++this.eatTick;
            }
        }
    }

    private boolean isBlockReachable(class_7102 frog, class_2338 pos) {
        class_11 path = frog.method_5942().method_6348(pos, 0);
        return path != null && path.method_21656() < 1.75f;
    }

    private void markTargetAsUnreachable(class_7102 frog, class_2338 pos) {
        try {
            boolean contains;
            List list = frog.method_18868().method_18904(HungryFrog.UNREACHABLE_BLOCK_TARGETS).orElse(new ArrayList());
            boolean bl = contains = !list.contains(pos);
            if (list.size() == 5 && contains) {
                list.removeFirst();
            }
            if (contains) {
                list.add(pos);
            }
            frog.method_18868().method_24525(HungryFrog.UNREACHABLE_BLOCK_TARGETS, (Object)list, 100L);
        }
        catch (Exception e) {
            frog.method_18868().method_18875(HungryFrog.UNREACHABLE_BLOCK_TARGETS);
        }
    }

    private static enum Phase {
        MOVE_TO_TARGET,
        CATCH_ANIMATION,
        EAT_ANIMATION,
        DONE;

    }
}

