/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11;

import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.event.KeyInputHandler;
import de.thecoolcraft11.packet.AddressPayload;
import de.thecoolcraft11.packet.ScreenshotResponsePayload;
import de.thecoolcraft11.screen.WebGalleryScreen;
import de.thecoolcraft11.util.ReceivePackets;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_2556;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import net.minecraft.class_7471;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotUploaderClient
implements ClientModInitializer {
    private final Logger logger = LoggerFactory.getLogger(ScreenshotUploaderClient.class);

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(AddressPayload.ID, this::registerAddressReceiver);
        ClientPlayNetworking.registerGlobalReceiver(ScreenshotResponsePayload.ID, this::registerScreenshotReceiver);
        ClientPlayConnectionEvents.DISCONNECT.register(this::registerDisconnectEvent);
        ClientPlayConnectionEvents.JOIN.register(this::registerJoinEvent);
        this.createConfig();
        KeyInputHandler.register();
        ClientReceiveMessageEvents.CHAT.register(this::regsiterChatEvent);
        ClientCommandRegistrationCallback.EVENT.register(this::regsiterCommands);
    }

    private void createConfig() {
        File configDir = new File("config/screenshotUploader");
        if (!configDir.exists() && configDir.mkdir()) {
            this.logger.info("Created Config Dir");
        }
        ConfigManager.initialize(configDir, true);
    }

    private void registerScreenshotReceiver(ScreenshotResponsePayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> ReceivePackets.receiveScreenshotRes(JsonParser.parseString((String)payload.json()).getAsJsonObject(), context.client()));
    }

    private void registerAddressReceiver(AddressPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> ReceivePackets.receiveAddress(context.client(), payload.message()));
    }

    private void regsiterCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"open-gallery").then(ClientCommandManager.argument((String)"server", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"image", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String value = StringArgumentType.getString((CommandContext)context, (String)"server");
            String value2 = StringArgumentType.getString((CommandContext)context, (String)"image");
            class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
            client.method_18858(() -> client.method_1507((class_437)new WebGalleryScreen(null, value, value2)));
            return 1;
        }))));
    }

    private void regsiterChatEvent(class_2561 message, @Nullable class_7471 signedMessage, @Nullable GameProfile gameProfile, class_2556.class_7602 parameters, Instant instant) {
        class_310 client = class_310.method_1551();
        boolean hasServerSaved = false;
        String serverName = "";
        if (ScreenshotUploaderClient.extractUrl(message.getString()) != null) {
            try {
                if (ReceivePackets.homeSiteAddress != null) {
                    URI savedEntry = new URI(ReceivePackets.homeSiteAddress);
                    URI uRI = new URI(Objects.requireNonNull(ScreenshotUploaderClient.extractUrl(message.getString())));
                    if (savedEntry.getHost().equals(uRI.getHost())) {
                        serverName = ReceivePackets.gallerySiteAddress;
                        hasServerSaved = true;
                    }
                }
            }
            catch (URISyntaxException savedEntry) {
                // empty catch block
            }
            if (!hasServerSaved) {
                for (Map map : ConfigManager.getClientConfig().upload_urls.values()) {
                    if (!map.containsKey("home")) continue;
                    try {
                        URI savedEntry = new URI((String)map.get("home"));
                        URI messageEntry = new URI(Objects.requireNonNull(ScreenshotUploaderClient.extractUrl(message.getString())));
                        if (!savedEntry.getHost().equals(messageEntry.getHost())) continue;
                        serverName = (String)map.get("gallery");
                        hasServerSaved = true;
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
        }
        if (hasServerSaved) {
            String finalServerName = serverName;
            class_5250 class_52502 = class_2561.method_43471((String)"message.screenshot_uploader.shared_saved").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/open-gallery \"" + finalServerName + "\" \"" + ScreenshotUploaderClient.extractUrl(message.getString()) + "\"")).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1075));
            client.field_1705.method_1743().method_1812((class_2561)class_52502);
        }
    }

    private void registerDisconnectEvent(class_634 playNetworkHandler, class_310 minecraftClient) {
        ReceivePackets.gallerySiteAddress = null;
        ReceivePackets.serverSiteAddress = null;
        ReceivePackets.homeSiteAddress = null;
    }

    private void registerJoinEvent(class_634 playNetworkHandler, PacketSender packetSender, class_310 minecraftClient) {
        class_5250 uploadMessageString = class_2561.method_43473();
        Map<String, Map<String, String>> uploadUrls = ScreenshotUploaderClient.getStringMapMap();
        int index = 0;
        int totalKeys = uploadUrls.size();
        for (String key : uploadUrls.keySet()) {
            uploadMessageString = uploadMessageString.method_27661().method_10852((class_2561)class_2561.method_43470((String)key).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, (String)((Map)uploadUrls.get(key)).get("home"))).method_10977(class_124.field_1075).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"message.screenshot_uploader.next_upload_server_description", (Object[])new Object[]{class_2561.method_43470((String)key).method_27694(style2 -> style2.method_10977(class_124.field_1075)), ((Map)uploadUrls.get(key)).get("upload"), ((Map)uploadUrls.get(key)).get("home"), class_2561.method_43472((String)"key.screenshot_uploader.gallery")})))));
            if (++index >= totalKeys) continue;
            uploadMessageString = uploadMessageString.method_27661().method_10852((class_2561)class_2561.method_43470((String)", ").method_27694(style -> style.method_10977(class_124.field_1075)));
        }
        minecraftClient.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.next_upload", (Object[])new Object[]{uploadMessageString}));
    }

    private static Map<String, Map<String, String>> getStringMapMap() {
        Map<String, Map<String, String>> uploadUrls = ConfigManager.getClientConfig().upload_urls;
        if (ReceivePackets.gallerySiteAddress != null) {
            HashMap<String, String> thisServerMap = new HashMap<String, String>();
            thisServerMap.put("home", ReceivePackets.homeSiteAddress);
            thisServerMap.put("upload", ReceivePackets.serverSiteAddress);
            thisServerMap.put("gallery", ReceivePackets.gallerySiteAddress);
            uploadUrls.put("This Server", thisServerMap);
        }
        return uploadUrls;
    }

    private static String extractUrl(String message) {
        String urlPattern = "https?://[\\w.-]+(:\\d+)?(/[\\w.-]*)*";
        Pattern pattern = Pattern.compile(urlPattern);
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

