/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11;

import com.google.gson.JsonObject;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.packet.AddressPayload;
import de.thecoolcraft11.packet.ScreenshotPayload;
import de.thecoolcraft11.util.ReceivePackets;
import de.thecoolcraft11.util.WebServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotUploaderServer
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "screenshot-uploader";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"screenshot-uploader");

    public void onInitializeServer() {
        this.createConfig();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarting);
        this.prepareWebServerStart();
        ServerPlayConnectionEvents.JOIN.register(this::registerJoinEvent);
    }

    private void registerJoinEvent(class_3244 serverPlayNetworkHandler, PacketSender player, MinecraftServer minecraftServer) {
        if (ConfigManager.getServerConfig().sendUrlToClient) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("upload", "mcserver://this");
            if (ConfigManager.getServerConfig().senGalleryUrlToClient) {
                Object urlString = ScreenshotUploaderServer.getServerIp();
                if (!((String)urlString).matches("^https?://.*")) {
                    urlString = "http://" + (String)urlString;
                }
                if (!((String)urlString).matches(".*:\\d+.*")) {
                    urlString = ((String)urlString).replaceFirst("^(https?://[^/]+)", "$1:" + ConfigManager.getServerConfig().port);
                }
                jsonObject.addProperty("home", (String)urlString);
                urlString = (String)urlString + "/screenshot-list";
                jsonObject.addProperty("gallery", (String)urlString);
            }
            if (ConfigManager.getServerConfig().useCustomWebURL) {
                jsonObject.remove("upload");
                jsonObject.addProperty("upload", ConfigManager.getServerConfig().customWebURL);
            }
            ServerPlayNetworking.send((class_3222)serverPlayNetworkHandler.method_32311(), (class_8710)new AddressPayload(jsonObject.toString()));
        }
        ServerPlayNetworking.registerGlobalReceiver(ScreenshotPayload.ID, (payload, context) -> {
            byte[] bytes = payload.bytes();
            String json = payload.json();
            context.server().execute(() -> ReceivePackets.handleReceivedScreenshot(bytes, json, context.player()));
        });
    }

    private void createConfig() {
        File configDir = new File("config/screenshotUploader");
        if (!configDir.exists() && configDir.mkdir()) {
            LOGGER.info("Created Config Folder");
        }
        ConfigManager.initialize(configDir, false);
    }

    private void prepareWebServerStart() {
        if (ConfigManager.getServerConfig().screenshotWebserver) {
            String ipAddress = "127.0.0.1";
            int port = ConfigManager.getServerConfig().port;
            LOGGER.info("Starting web server on {}:{} ...", (Object)ipAddress, (Object)port);
            this.startWebServer();
        }
    }

    private void startWebServer() {
        String ipAddress = "127.0.0.1";
        int port = ConfigManager.getServerConfig().port;
        Object urlString = ScreenshotUploaderServer.getServerIp();
        if (!((String)urlString).matches("^https?://.*")) {
            urlString = "http://" + (String)urlString;
        }
        if (!((String)urlString).matches(".*:\\d+.*")) {
            urlString = ((String)urlString).replaceFirst("^(https?://[^/]+)", "$1:" + ConfigManager.getServerConfig().port);
        }
        try {
            WebServer.startWebServer(ipAddress, port, (String)urlString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onServerStarting(MinecraftServer server) {
        this.copyResourceToServerDir("/static/js/script.js", "screenshotUploader/static/js/script.js");
        this.copyResourceToServerDir("/static/css/style.css", "screenshotUploader/static/css/style.css");
    }

    private void copyResourceToServerDir(String resourcePath, String targetPath) {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path targetFile = gameDir.resolve(targetPath);
        try (InputStream resourceStream = this.getClass().getResourceAsStream(resourcePath);){
            if (resourceStream == null) {
                LOGGER.error("Resource not found: {}", (Object)resourcePath);
                return;
            }
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            Files.copy(resourceStream, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Error while copying resource: {}", (Object)e.getMessage());
        }
    }

    public static String getServerIp() {
        return ConfigManager.getServerConfig().websiteURL;
    }
}

