/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.screen.ConfirmationScreen;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(ConfigScreen.class);
    private final Path configPath = Paths.get("config/screenshotUploader/config.json", new String[0]);
    private JsonObject config;
    private final Map<String, class_342> inputFields = new LinkedHashMap<String, class_342>();
    private int scrollOffset = 0;
    private final int entryHeight = 30;
    private final Map<String, class_364> scrollableButtons = new LinkedHashMap<String, class_364>();
    private boolean isConfigSaved = true;
    private class_4185 saveButton;

    public ConfigScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.title"));
        this.loadConfig();
    }

    protected void method_25426() {
        this.inputFields.clear();
        this.method_37067();
        int yOffsetStart = 40;
        int inputXOffset = this.field_22789 / 2;
        int currentYOffset = yOffsetStart;
        for (Map.Entry entry : this.config.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                class_342 textField = new class_342(this.field_22793, inputXOffset, currentYOffset, 200, 20, (class_2561)class_2561.method_43470((String)key));
                textField.method_1880(1024);
                textField.method_1852(value.getAsString());
                textField.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)key)));
                textField.method_1863(s -> {
                    this.isConfigSaved = false;
                });
                this.inputFields.put(key, textField);
                this.scrollableButtons.put(key, (class_364)textField);
                this.method_25429((class_364)textField);
            } else if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
                class_342 textField = new class_342(this.field_22793, inputXOffset, currentYOffset, 200, 20, (class_2561)class_2561.method_43470((String)key));
                textField.method_1880(1024);
                textField.method_1852(value.getAsString());
                textField.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)key)));
                textField.method_1863(s -> {
                    this.isConfigSaved = false;
                });
                this.inputFields.put(key, textField);
                this.scrollableButtons.put(key, (class_364)textField);
                this.method_25429((class_364)textField);
            } else if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
                boolean currentValue = value.getAsBoolean();
                class_4185 widget = class_4185.method_46430((class_2561)class_2561.method_43471((String)(currentValue ? "gui.screenshot_uploader.config.true" : "gui.screenshot_uploader.config.false")), button -> {
                    this.isConfigSaved = false;
                    boolean newValue = !this.config.get(key).getAsBoolean();
                    this.config.addProperty(key, Boolean.valueOf(newValue));
                    button.method_25355((class_2561)class_2561.method_43471((String)(newValue ? "gui.screenshot_uploader.config.true" : "gui.screenshot_uploader.config.false")));
                }).method_46434(inputXOffset, currentYOffset, 200, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_30163((String)key))).method_46431();
                this.method_37063((class_364)widget);
                this.scrollableButtons.put(key, (class_364)widget);
            } else if (value.isJsonNull() || value.isJsonArray() || value.isJsonObject()) {
                class_4185 widget = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.not_edit"), button -> {}).method_46434(inputXOffset, currentYOffset, 200, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_30163((String)(key + "\nHead to /config/screenshotUploader/config.json to edit servers")))).method_46431();
                widget.field_22763 = false;
                this.method_37063((class_364)widget);
                this.scrollableButtons.put(key, (class_364)widget);
            }
            currentYOffset += 30;
        }
        int buttonYOffset = Math.max(currentYOffset + 10, this.field_22790 - 60);
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.save"), button -> this.saveConfig()).method_46434(this.field_22789 / 2, buttonYOffset, 200, 20).method_46431();
        this.saveButton.field_22763 = !this.isConfigSaved;
        this.saveButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.nothing_changed")));
        this.method_37063((class_364)this.saveButton);
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.close"), button -> this.method_25419()).method_46434(this.field_22789 / 2, buttonYOffset + 30, 200, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)backButton);
        this.scrollableButtons.put("Save", (class_364)this.saveButton);
        this.scrollableButtons.put("Close", (class_364)backButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
        for (class_342 field : this.inputFields.values()) {
            field.method_25394(context, mouseX, mouseY, delta);
        }
        int currentYOffset = 40 + this.scrollOffset;
        int labelXOffset = this.field_22789 / 4;
        for (Map.Entry entry : this.config.entrySet()) {
            String key = (String)entry.getKey();
            int labelY = currentYOffset;
            if (labelY >= 20 && labelY <= this.field_22790 - 40) {
                context.method_25303(this.field_22793, key, labelXOffset, labelY + 6, 0xCCCCCC);
            }
            currentYOffset += 30;
        }
        this.saveButton.field_22763 = !this.isConfigSaved;
        this.saveButton.method_47400(!this.isConfigSaved ? class_7919.method_47407((class_2561)class_2561.method_30163((String)"In order for the changed config values to take effect, please restart the game")) : class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.nothing_changed")));
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount, double horizontalAmount) {
        this.scrollOffset += (int)(horizontalAmount * 10.0);
        int maxScroll = Math.max((this.scrollableButtons.size() + 2) * 30 - 2 * (this.field_22790 - 60), 0);
        this.scrollOffset = Math.max(this.scrollOffset, -((this.scrollableButtons.size() + 2) * 30 - (this.field_22790 - 60)));
        this.scrollOffset = Math.min(this.scrollOffset, maxScroll);
        this.updateWidgetPositions();
        return true;
    }

    private void updateWidgetPositions() {
        int yOffsetStart = 40 + this.scrollOffset;
        int inputXOffset = this.field_22789 / 2;
        int currentYOffset = yOffsetStart;
        for (Map.Entry<String, class_364> entry : this.scrollableButtons.entrySet()) {
            class_364 class_3642 = entry.getValue();
            if (class_3642 instanceof class_4185) {
                class_4185 field = (class_4185)class_3642;
                field.method_46421(inputXOffset);
                field.method_46419(currentYOffset);
                currentYOffset += 30;
                continue;
            }
            class_3642 = entry.getValue();
            if (!(class_3642 instanceof class_342)) continue;
            class_342 field = (class_342)class_3642;
            field.method_46421(inputXOffset);
            field.method_46419(currentYOffset);
            currentYOffset += 30;
        }
    }

    private void loadConfig() {
        try {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                this.config = new JsonObject();
                this.config.addProperty("exampleString", "DefaultValue");
                this.config.addProperty("exampleNumber", (Number)0);
                this.config.addProperty("exampleBoolean", Boolean.valueOf(true));
                this.saveConfigFile();
            } else {
                String jsonString = Files.readString(this.configPath);
                this.config = JsonParser.parseString((String)jsonString).getAsJsonObject();
            }
        }
        catch (IOException e) {
            logger.error("Error loading config file {}: {}", (Object)this.configPath, (Object)e.getMessage());
            this.config = new JsonObject();
        }
    }

    private void saveConfig() {
        for (Map.Entry<String, class_342> entry : this.inputFields.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().method_1882();
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.config.addProperty(key, Boolean.valueOf(Boolean.parseBoolean(value)));
                continue;
            }
            if (value.matches("-?\\d+(\\.\\d+)?")) {
                this.config.addProperty(key, (Number)Double.parseDouble(value));
                continue;
            }
            this.config.addProperty(key, value);
        }
        this.saveConfigFile();
        ConfigManager.reloadConfig(new File("config/screenshotUploader/"), true);
        this.isConfigSaved = true;
    }

    private void saveConfigFile() {
        try {
            Files.writeString(this.configPath, (CharSequence)this.config.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Error saving config file {}: {}", (Object)this.configPath, (Object)e.getMessage());
        }
    }

    public void method_25419() {
        if (this.isConfigSaved) {
            super.method_25419();
        } else {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new ConfirmationScreen(confirmed -> {
                if (confirmed.booleanValue()) {
                    this.isConfigSaved = true;
                    super.method_25419();
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.unsaved"), (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.config.unsaved_detail")));
        }
    }
}

