/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(EditScreen.class);
    private final class_437 parent;
    private final Path imagePath;
    private class_1011 image;
    private final Stack<class_1011> editHistory = new Stack();
    private int cropStartX = -1;
    private int cropStartY = -1;
    private int cropEndX = -1;
    private int cropEndY = -1;
    private boolean isSelecting = false;
    private class_342 textInputField;
    private class_342 fontSizeWidget;
    private int textX = 0;
    private int textY = 0;
    private class_2960 textureId;
    int previewX;
    int previewY;
    int previewSize;
    class_342 colorField;
    Consumer<class_1011> onClose;

    public EditScreen(class_437 parent, Path imagePath, class_1011 nativeImage, Consumer<class_1011> onClose) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.title"));
        this.parent = parent;
        if (imagePath == null) {
            this.allocateImage(nativeImage);
        }
        this.imagePath = imagePath;
        this.onClose = onClose;
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 120;
        int buttonHeight = 20;
        int padding = 10;
        int imageX = this.field_22789 / 4;
        int imageY = this.field_22790 / 4;
        int imageWidth = this.field_22789 / 2;
        int imageHeight = this.field_22790 / 2;
        int startX = imageX;
        int startY = imageY - (buttonHeight + padding);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.crop"), button -> this.cropImage()).method_46434(startX, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.rotate"), button -> this.rotateImage()).method_46434(startX + buttonWidth + padding, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.sepia"), button -> this.applySepia()).method_46434(startX + 2 * (buttonWidth + padding), startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.back"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
            if (this.onClose != null) {
                this.onClose.accept(this.image);
            }
        }).method_46434(startX + 3 * (buttonWidth + padding), startY, buttonWidth, buttonHeight).method_46431());
        startX = imageX + imageWidth + padding;
        startY = imageY;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.undo"), button -> this.undo()).method_46434(startX, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.brightness"), button -> this.adjustBrightnessContrast()).method_46434(startX, startY + buttonHeight + padding, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.grayscale"), button -> this.applyGrayscale()).method_46434(startX, startY + 2 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.hue_shift"), button -> this.applyHueShift()).method_46434(startX, startY + 3 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.pixel_averaging"), button -> this.applyPixelAveraging()).method_46434(startX, startY + 4 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.invert_colors"), button -> this.applyInvert()).method_46434(startX, startY + 5 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.posterize"), button -> this.applyPosterize()).method_46434(startX, startY + 6 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.vignette"), button -> this.applyVignette()).method_46434(startX, startY + 7 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.emboss"), button -> this.applyEmboss()).method_46434(startX, startY + 8 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.solarize"), button -> this.applySolarize()).method_46434(startX, startY + 9 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.noise"), button -> this.applyNoise()).method_46434(startX, startY + 10 * (buttonHeight + padding), buttonWidth, buttonHeight).method_46431());
        startX = imageX;
        startY = imageY + imageHeight + padding;
        this.textInputField = new class_342(this.field_22793, startX, startY, 200, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.enter_text"));
        this.textInputField.method_1880(1024);
        this.fontSizeWidget = new class_342(this.field_22793, startX + 210, startY, 60, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.font_size"));
        this.fontSizeWidget.method_1880(3);
        class_342 colorField = new class_342(this.field_22793, startX + 280, startY, 100, buttonHeight, (class_2561)class_2561.method_43470((String)"#FFFFFF"));
        this.fontSizeWidget.method_1852("128");
        colorField.method_1852("#FFFFFF");
        colorField.method_1880(7);
        this.method_37063((class_364)this.textInputField);
        this.method_37063((class_364)this.fontSizeWidget);
        this.method_37063((class_364)colorField);
        int previewX = startX + 390;
        int previewY = startY;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.apply_text"), button -> {
            Object hexColor = colorField.method_1882();
            if (!((String)hexColor).contains("#")) {
                hexColor = "#" + (String)hexColor;
            }
            this.applyText((String)hexColor);
        }).method_46434(startX, startY += buttonHeight + padding, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.set_text_pos"), button -> this.setTextPosition()).method_46434(startX + buttonWidth + padding, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.fill_image"), button -> {
            Object hexColor = colorField.method_1882();
            if (!((String)hexColor).contains("#")) {
                hexColor = "#" + (String)hexColor;
            }
            this.fillImage((String)hexColor);
        }).method_46434(startX + 2 * (buttonWidth + padding), startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.editor.blur"), button -> this.applyBlur()).method_46434(startX, startY += buttonHeight + padding, buttonWidth, buttonHeight).method_46431());
        this.loadImage();
        this.colorField = colorField;
        this.previewX = previewX;
        this.previewY = previewY;
        this.previewSize = buttonHeight;
    }

    private void applyText(String hexColor) {
        if (this.image == null || this.textInputField == null) {
            return;
        }
        this.saveStateForUndo();
        String text = this.textInputField.method_1882();
        if (text == null || text.isEmpty()) {
            return;
        }
        int fillColor = new Color(255, 255, 255).getRGB();
        if (hexColor != null && hexColor.matches("#[0-9A-Fa-f]{6}")) {
            int b = Integer.parseInt(hexColor.substring(1, 3), 16);
            int g = Integer.parseInt(hexColor.substring(3, 5), 16);
            int r = Integer.parseInt(hexColor.substring(5, 7), 16);
            fillColor = new Color(r, g, b).getRGB();
        }
        try {
            BufferedImage textImage = new BufferedImage(this.image.method_4307(), this.image.method_4323(), 2);
            Graphics2D g2d = textImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setFont(new Font("Minecraft", 0, Integer.parseInt(this.fontSizeWidget.method_1882())));
            g2d.setColor(new Color(fillColor));
            g2d.drawString(text, this.textX, this.textY);
            g2d.dispose();
            for (int y = 0; y < textImage.getHeight(); ++y) {
                for (int x = 0; x < textImage.getWidth(); ++x) {
                    int color = textImage.getRGB(x, y);
                    if (color >> 24 == 0) continue;
                    this.image.method_4305(x, y, color);
                }
            }
            this.saveImage();
            logger.info("Text '{}' applied to the image at position ({}, {})", new Object[]{text, this.textX, this.textY});
        }
        catch (Exception e) {
            logger.error("Failed to apply text to the image: {}", (Object)e.getMessage());
        }
    }

    private void setTextPosition() {
        if (this.cropStartX < 0 || this.cropStartY < 0 || this.cropEndX < 0 || this.cropEndY < 0 || this.image == null) {
            return;
        }
        int x1 = Math.max(0, Math.min(Math.min(this.cropStartX, this.cropEndX), this.image.method_4307() - 1));
        int y1 = Math.max(0, Math.min(Math.min(this.cropStartY, this.cropEndY), this.image.method_4323() - 1));
        this.textX = x1;
        this.textY = y1;
        logger.info("Text position set to: X={}, Y={}", (Object)this.textX, (Object)this.textY);
    }

    private void loadImage() {
        block3: {
            if (this.imagePath != null) {
                try {
                    this.image = class_1011.method_4309((InputStream)Files.newInputStream(this.imagePath, new OpenOption[0]));
                }
                catch (IOException e) {
                    logger.error("Failed to load image for editing: {}", (Object)e.getMessage());
                    if (this.field_22787 == null) break block3;
                    this.field_22787.method_1507(this.parent);
                }
            }
        }
    }

    private void cropImage() {
        if (this.cropStartX < 0 || this.cropStartY < 0 || this.cropEndX < 0 || this.cropEndY < 0 || this.image == null) {
            return;
        }
        this.saveStateForUndo();
        int x1 = Math.max(0, Math.min(Math.min(this.cropStartX, this.cropEndX), this.image.method_4307() - 1));
        int y1 = Math.max(0, Math.min(Math.min(this.cropStartY, this.cropEndY), this.image.method_4323() - 1));
        int x2 = Math.max(0, Math.min(Math.max(this.cropStartX, this.cropEndX), this.image.method_4307()));
        int y2 = Math.max(0, Math.min(Math.max(this.cropStartY, this.cropEndY), this.image.method_4323()));
        int width = x2 - x1;
        int height = y2 - y1;
        class_1011 croppedImage = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                croppedImage.method_4305(x, y, this.image.method_4315(x1 + x, y1 + y));
            }
        }
        this.image.close();
        this.image = croppedImage;
        this.cropEndY = -1;
        this.cropEndX = -1;
        this.cropStartY = -1;
        this.cropStartX = -1;
        this.saveImage();
    }

    private void fillImage(String hexColor) {
        if (this.cropStartX < 0 || this.cropStartY < 0 || this.cropEndX < 0 || this.cropEndY < 0 || this.image == null) {
            return;
        }
        this.saveStateForUndo();
        int fillColor = new Color(255, 255, 255).getRGB();
        if (hexColor != null && hexColor.matches("#[0-9A-Fa-f]{6}")) {
            int b = Integer.parseInt(hexColor.substring(1, 3), 16);
            int g = Integer.parseInt(hexColor.substring(3, 5), 16);
            int r = Integer.parseInt(hexColor.substring(5, 7), 16);
            fillColor = new Color(r, g, b).getRGB();
        }
        int x1 = Math.max(0, Math.min(Math.min(this.cropStartX, this.cropEndX), this.image.method_4307() - 1));
        int y1 = Math.max(0, Math.min(Math.min(this.cropStartY, this.cropEndY), this.image.method_4323() - 1));
        int x2 = Math.max(0, Math.min(Math.max(this.cropStartX, this.cropEndX), this.image.method_4307()));
        int y2 = Math.max(0, Math.min(Math.max(this.cropStartY, this.cropEndY), this.image.method_4323()));
        int width = x2 - x1;
        int height = y2 - y1;
        if (width <= 0 || height <= 0) {
            logger.warn("Invalid fill area: width={}, height={}", (Object)width, (Object)height);
            return;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.image.method_4305(x1 + x, y1 + y, fillColor);
            }
        }
        this.cropEndY = -1;
        this.cropEndX = -1;
        this.cropStartY = -1;
        this.cropStartX = -1;
        this.saveImage();
    }

    private void rotateImage() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        class_1011 rotatedImage = new class_1011(this.image.method_4323(), this.image.method_4307(), false);
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                rotatedImage.method_4305(this.image.method_4323() - y - 1, x, this.image.method_4315(x, y));
            }
        }
        this.image.close();
        this.image = rotatedImage;
        this.saveImage();
    }

    private void applySepia() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int newColor = EditScreen.getNewColor(color);
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private static int getNewColor(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int tr = (int)(0.393 * (double)r + 0.769 * (double)g + 0.189 * (double)b);
        int tg = (int)(0.349 * (double)r + 0.686 * (double)g + 0.168 * (double)b);
        int tb = (int)(0.272 * (double)r + 0.534 * (double)g + 0.131 * (double)b);
        r = Math.min(tr, 255);
        g = Math.min(tg, 255);
        b = Math.min(tb, 255);
        return color & 0xFF000000 | r << 16 | g << 8 | b;
    }

    private void saveImage() {
        if (this.imagePath != null) {
            try {
                this.image.method_4314(this.imagePath);
                logger.info("Image saved: {}", (Object)this.imagePath);
                this.textureId = null;
                if (this.field_22787 != null) {
                    this.field_22787.method_1531().method_4615(this.textureId);
                }
            }
            catch (IOException e) {
                logger.error("Failed to save edited image: {}", (Object)e.getMessage());
            }
        } else {
            this.textureId = null;
            if (this.field_22787 != null) {
                this.field_22787.method_1531().method_4615(this.textureId);
            }
        }
    }

    private void saveStateForUndo() {
        if (this.image != null) {
            class_1011 imageCopy = new class_1011(this.image.method_4307(), this.image.method_4323(), false);
            for (int y = 0; y < this.image.method_4323(); ++y) {
                for (int x = 0; x < this.image.method_4307(); ++x) {
                    imageCopy.method_4305(x, y, this.image.method_4315(x, y));
                }
            }
            this.editHistory.push(imageCopy);
        }
    }

    private void allocateImage(class_1011 newImage) {
        if (newImage != null) {
            class_1011 imageCopy = new class_1011(newImage.method_4307(), newImage.method_4323(), false);
            for (int y = 0; y < newImage.method_4323(); ++y) {
                for (int x = 0; x < newImage.method_4307(); ++x) {
                    imageCopy.method_4305(x, y, newImage.method_4315(x, y));
                }
            }
            this.image = imageCopy;
        }
    }

    private void undo() {
        if (!this.editHistory.isEmpty()) {
            if (this.image != null) {
                this.image.close();
            }
            this.image = this.editHistory.pop();
            this.saveImage();
        }
    }

    private void adjustBrightnessContrast() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                r = (int)((float)(r - 128) * 1.2f + 128.0f);
                g = (int)((float)(g - 128) * 1.2f + 128.0f);
                b = (int)((float)(b - 128) * 1.2f + 128.0f);
                r = (int)((float)r + 20.0f);
                g = (int)((float)g + 20.0f);
                b = (int)((float)b + 20.0f);
                r = Math.min(Math.max(r, 0), 255);
                g = Math.min(Math.max(g, 0), 255);
                b = Math.min(Math.max(b, 0), 255);
                int newColor = color & 0xFF000000 | r << 16 | g << 8 | b;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private void applyGrayscale() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int gray = (r + g + b) / 3;
                int newColor = color & 0xFF000000 | gray << 16 | gray << 8 | gray;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private void applyHueShift() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int newR = (int)((float)r + 20.0f);
                int newG = (int)((float)g + 20.0f);
                int newB = (int)((float)b + 20.0f);
                newR = Math.min(Math.max(newR, 0), 255);
                newG = Math.min(Math.max(newG, 0), 255);
                newB = Math.min(Math.max(newB, 0), 255);
                int newColor = color & 0xFF000000 | newR << 16 | newG << 8 | newB;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private void applyBlur() {
        if (this.image == null || this.cropStartX < 0 || this.cropStartY < 0 || this.cropEndX < 0 || this.cropEndY < 0) {
            return;
        }
        this.saveStateForUndo();
        int x1 = Math.max(0, Math.min(Math.min(this.cropStartX, this.cropEndX), this.image.method_4307() - 1));
        int y1 = Math.max(0, Math.min(Math.min(this.cropStartY, this.cropEndY), this.image.method_4323() - 1));
        int x2 = Math.max(0, Math.min(Math.max(this.cropStartX, this.cropEndX), this.image.method_4307()));
        int y2 = Math.max(0, Math.min(Math.max(this.cropStartY, this.cropEndY), this.image.method_4323()));
        if (x2 <= x1 || y2 <= y1) {
            logger.warn("Invalid blur area: width={}, height={}", (Object)(x2 - x1), (Object)(y2 - y1));
            return;
        }
        int kernelSize = 10;
        int iterations = 10;
        for (int i = 0; i < iterations; ++i) {
            int x;
            int y;
            class_1011 blurredImage = new class_1011(this.image.method_4307(), this.image.method_4323(), false);
            for (y = 0; y < this.image.method_4323(); ++y) {
                for (x = 0; x < this.image.method_4307(); ++x) {
                    blurredImage.method_4305(x, y, this.image.method_4315(x, y));
                }
            }
            for (y = y1; y < y2; ++y) {
                for (x = x1; x < x2; ++x) {
                    int colorSumR = 0;
                    int colorSumG = 0;
                    int colorSumB = 0;
                    int count = 0;
                    for (int dy = -kernelSize / 2; dy <= kernelSize / 2; ++dy) {
                        for (int dx = -kernelSize / 2; dx <= kernelSize / 2; ++dx) {
                            int nx = x + dx;
                            int ny = y + dy;
                            if (nx < 0 || nx >= this.image.method_4307() || ny < 0 || ny >= this.image.method_4323()) continue;
                            int color = this.image.method_4315(nx, ny);
                            colorSumR += color >> 16 & 0xFF;
                            colorSumG += color >> 8 & 0xFF;
                            colorSumB += color & 0xFF;
                            ++count;
                        }
                    }
                    int avgR = colorSumR / count;
                    int avgG = colorSumG / count;
                    int avgB = colorSumB / count;
                    int avgColor = 0xFF000000 | avgR << 16 | avgG << 8 | avgB;
                    blurredImage.method_4305(x, y, avgColor);
                }
            }
            this.image.close();
            this.image = blurredImage;
        }
        this.cropEndY = -1;
        this.cropEndX = -1;
        this.cropStartY = -1;
        this.cropStartX = -1;
        this.saveImage();
        this.cropEndY = -1;
        this.cropEndX = -1;
        this.cropStartY = -1;
        this.cropStartX = -1;
        this.saveImage();
    }

    private void applyPixelAveraging() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        class_1011 blurredImage = new class_1011(this.image.method_4307(), this.image.method_4323(), false);
        for (int y = 1; y < this.image.method_4323() - 1; ++y) {
            for (int x = 1; x < this.image.method_4307() - 1; ++x) {
                int colorSum = 0;
                int count = 0;
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        colorSum += this.image.method_4315(x + dx, y + dy);
                        ++count;
                    }
                }
                int avgColor = colorSum / count;
                blurredImage.method_4305(x, y, avgColor);
            }
        }
        this.image.close();
        this.image = blurredImage;
        this.saveImage();
    }

    private void applyInvert() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int r = 255 - (color >> 16 & 0xFF);
                int g = 255 - (color >> 8 & 0xFF);
                int b = 255 - (color & 0xFF);
                int newColor = color & 0xFF000000 | r << 16 | g << 8 | b;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private void applyPosterize() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        int step = 63;
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                r = r / step * step;
                g = g / step * step;
                b = b / step * step;
                int newColor = color & 0xFF000000 | r << 16 | g << 8 | b;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private void applyVignette() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        int centerX = this.image.method_4307() / 2;
        int centerY = this.image.method_4323() / 2;
        int maxDistance = (int)Math.sqrt(centerX * centerX + centerY * centerY);
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int dx = x - centerX;
                int dy = y - centerY;
                int distance = (int)Math.sqrt(dx * dx + dy * dy);
                float intensity = 1.0f - Math.min((float)distance / (float)maxDistance, 1.0f);
                int r = (int)((float)(color >> 16 & 0xFF) * intensity);
                int g = (int)((float)(color >> 8 & 0xFF) * intensity);
                int b = (int)((float)(color & 0xFF) * intensity);
                r = Math.min(r, 255);
                g = Math.min(g, 255);
                b = Math.min(b, 255);
                int newColor = color & 0xFF000000 | r << 16 | g << 8 | b;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private void applyEmboss() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        class_1011 embossedImage = new class_1011(this.image.method_4307(), this.image.method_4323(), false);
        for (int y = 1; y < this.image.method_4323() - 1; ++y) {
            for (int x = 1; x < this.image.method_4307() - 1; ++x) {
                int color1 = this.image.method_4315(x, y);
                int color2 = this.image.method_4315(x + 1, y + 1);
                int newColor = EditScreen.getNewColor(color1, color2);
                embossedImage.method_4305(x, y, newColor);
            }
        }
        this.image.close();
        this.image = embossedImage;
        this.saveImage();
    }

    private static int getNewColor(int color1, int color2) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = Math.min(Math.max(r1 - r2 + 128, 0), 255);
        int g = Math.min(Math.max(g1 - g2 + 128, 0), 255);
        int b = Math.min(Math.max(b1 - b2 + 128, 0), 255);
        return color1 & 0xFF000000 | r << 16 | g << 8 | b;
    }

    private void applySolarize() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                if (r > 128) {
                    r = 255 - r;
                }
                if (g > 128) {
                    g = 255 - g;
                }
                if (b > 128) {
                    b = 255 - b;
                }
                int newColor = color & 0xFF000000 | r << 16 | g << 8 | b;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    private void applyNoise() {
        if (this.image == null) {
            return;
        }
        this.saveStateForUndo();
        for (int y = 0; y < this.image.method_4323(); ++y) {
            for (int x = 0; x < this.image.method_4307(); ++x) {
                int color = this.image.method_4315(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                r += (int)(Math.random() * 2.0 * 20.0 - 20.0);
                g += (int)(Math.random() * 2.0 * 20.0 - 20.0);
                b += (int)(Math.random() * 2.0 * 20.0 - 20.0);
                r = Math.min(Math.max(r, 0), 255);
                g = Math.min(Math.max(g, 0), 255);
                b = Math.min(Math.max(b, 0), 255);
                int newColor = color & 0xFF000000 | r << 16 | g << 8 | b;
                this.image.method_4305(x, y, newColor);
            }
        }
        this.saveImage();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        Object hexColor;
        super.method_25394(context, mouseX, mouseY, delta);
        this.textInputField.method_25394(context, mouseX, mouseY, delta);
        if (this.textureId != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.textureId);
            context.method_25290(this.textureId, this.field_22789 / 4, this.field_22790 / 4, 0.0f, 0.0f, this.field_22789 / 2, this.field_22790 / 2, this.field_22789 / 2, this.field_22790 / 2);
        } else if (this.image != null && this.field_22787 != null) {
            this.textureId = this.field_22787.method_1531().method_4617("edit_image", new class_1043(this.image));
        }
        if (this.isSelecting || this.cropStartX >= 0 && this.cropStartY >= 0 && this.cropEndX >= 0 && this.cropEndY >= 0) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            if (this.image != null) {
                scaleX = (float)this.image.method_4307() / ((float)this.field_22789 / 2.0f);
                scaleY = (float)this.image.method_4323() / ((float)this.field_22790 / 2.0f);
            }
            int x1 = (int)((float)Math.min(this.cropStartX, this.cropEndX) / scaleX + (float)this.field_22789 / 4.0f);
            int y1 = (int)((float)Math.min(this.cropStartY, this.cropEndY) / scaleY + (float)this.field_22790 / 4.0f);
            int x2 = (int)((float)Math.max(this.cropStartX, this.cropEndX) / scaleX + (float)this.field_22789 / 4.0f);
            int y2 = (int)((float)Math.max(this.cropStartY, this.cropEndY) / scaleY + (float)this.field_22790 / 4.0f);
            context.method_25294(x1, y1, x2, y2, -2130706433);
        }
        if (this.colorField != null && (hexColor = this.colorField.method_1882()) != null) {
            if (!((String)hexColor).contains("#")) {
                hexColor = "#" + (String)hexColor;
            }
            if (((String)hexColor).matches("#[0-9A-Fa-f]{6}")) {
                int r = Integer.parseInt(((String)hexColor).substring(1, 3), 16);
                int g = Integer.parseInt(((String)hexColor).substring(3, 5), 16);
                int b = Integer.parseInt(((String)hexColor).substring(5, 7), 16);
                int color = new Color(r, g, b).getRGB();
                context.method_25294(this.previewX, this.previewY, this.previewX + this.previewSize, this.previewY + this.previewSize, color);
            } else {
                context.method_25294(this.previewX, this.previewY, this.previewX + this.previewSize, this.previewY + this.previewSize, -1);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (class_364 buttonWidget : this.method_25396()) {
                if (buttonWidget == null || !buttonWidget.method_25405(mouseX, mouseY)) continue;
                return super.method_25402(mouseX, mouseY, button);
            }
            this.isSelecting = true;
            if (this.image != null) {
                float scaleX = (float)this.image.method_4307() / ((float)this.field_22789 / 2.0f);
                float scaleY = (float)this.image.method_4323() / ((float)this.field_22790 / 2.0f);
                this.cropStartX = (int)((mouseX - (double)this.field_22789 / 4.0) * (double)scaleX);
                this.cropStartY = (int)((mouseY - (double)this.field_22790 / 4.0) * (double)scaleY);
                this.cropStartX = Math.max(0, Math.min(this.cropStartX, this.image.method_4307()));
                this.cropStartY = Math.max(0, Math.min(this.cropStartY, this.image.method_4323()));
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isSelecting) {
            if (this.image != null) {
                float scaleX = (float)this.image.method_4307() / ((float)this.field_22789 / 2.0f);
                float scaleY = (float)this.image.method_4323() / ((float)this.field_22790 / 2.0f);
                this.cropEndX = (int)((mouseX - (double)this.field_22789 / 4.0) * (double)scaleX);
                this.cropEndY = (int)((mouseY - (double)this.field_22790 / 4.0) * (double)scaleY);
                this.cropEndX = Math.max(0, Math.min(this.cropEndX, this.image.method_4307()));
                this.cropEndY = Math.max(0, Math.min(this.cropEndY, this.image.method_4323()));
            }
            this.isSelecting = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isSelecting && button == 0 && this.image != null) {
            float scaleX = (float)this.image.method_4307() / ((float)this.field_22789 / 2.0f);
            float scaleY = (float)this.image.method_4323() / ((float)this.field_22790 / 2.0f);
            this.cropEndX = (int)((mouseX - (double)this.field_22789 / 4.0) * (double)scaleX);
            this.cropEndY = (int)((mouseY - (double)this.field_22790 / 4.0) * (double)scaleY);
            this.cropEndX = Math.max(0, Math.min(this.cropEndX, this.image.method_4307()));
            this.cropEndY = Math.max(0, Math.min(this.cropEndY, this.image.method_4323()));
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_25419() {
        if (this.onClose != null) {
            this.onClose.accept(this.image);
        }
        if (this.image != null) {
            this.image.close();
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

