/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.screen.ConfigScreen;
import de.thecoolcraft11.screen.EditScreen;
import de.thecoolcraft11.screen.WebGalleryScreen;
import de.thecoolcraft11.util.ReceivePackets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleryScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(GalleryScreen.class);
    private static final List<class_2960> imageIds = new ArrayList<class_2960>();
    private static final List<Path> imagePaths = new ArrayList<Path>();
    private static final int IMAGES_PER_ROW = ConfigManager.getClientConfig().imagesPerRow;
    private static int IMAGE_WIDTH = 192;
    private static int IMAGE_HEIGHT = 108;
    private static int GAP = ConfigManager.getClientConfig().imageGap;
    private static int TOP_PADDING = ConfigManager.getClientConfig().imageTopPadding;
    private boolean isImageClicked = false;
    private int clickedImageIndex = -1;
    private int scrollOffset = 0;
    private double zoomLevel = 2.0;
    private double imageOffsetX = 0.0;
    private double imageOffsetY = 0.0;
    private class_4185 saveButton;
    private class_4185 deleteButton;
    private class_4185 openInAppButton;
    private class_4185 editButton;
    private class_4185 configButton;
    private final List<class_4185> navigatorButtons = new ArrayList<class_4185>();
    private final List<class_4185> buttonsToHideOnOverlap = new ArrayList<class_4185>();

    public GalleryScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.title"));
    }

    protected void method_25426() {
        super.method_25426();
        imageIds.clear();
        imagePaths.clear();
        this.navigatorButtons.clear();
        int scaledHeight = this.field_22790 / 6;
        int scaledWidth = scaledHeight * 16 / 9;
        int scaledGap = scaledHeight / 10;
        TOP_PADDING = this.field_22790 / 20;
        IMAGE_WIDTH = scaledWidth;
        IMAGE_HEIGHT = scaledHeight;
        GAP = scaledGap;
        this.loadAllImagesAsync();
        int buttonWidth = this.field_22789 / 8;
        int buttonHeight = this.field_22790 / 25;
        int buttonSpacing = buttonWidth / 5;
        int xPosition = (this.field_22789 - (buttonWidth * (this.navigatorButtons.size() + 1) + buttonSpacing * (this.navigatorButtons.size() - 1))) / 5;
        int buttonY = (int)((double)this.field_22790 * 0.9);
        int navigatorY = (int)((double)this.field_22790 * 0.01);
        this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"), button -> {}).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
        xPosition += buttonWidth + buttonSpacing;
        if (ReceivePackets.gallerySiteAddress != null) {
            this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.server_gallery"), button -> {
                String webserverUrl = ReceivePackets.gallerySiteAddress;
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                } else {
                    logger.error("Failed to get client trying to open Server Gallery with URL {}", (Object)webserverUrl);
                }
            }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            xPosition += buttonWidth + buttonSpacing;
        }
        for (Map.Entry<String, Map<String, String>> entry : ConfigManager.getClientConfig().upload_urls.entrySet()) {
            String webserverUrl = entry.getValue().get("gallery");
            String buttonLabel = entry.getKey();
            this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonLabel), button -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                } else {
                    logger.error("Failed to get client trying to open Gallery for {}", (Object)webserverUrl);
                }
            }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            xPosition += buttonWidth + buttonSpacing;
        }
        this.navigatorButtons.forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        this.navigatorButtons.stream().filter(buttonWidget -> buttonWidget.method_25369().equals((Object)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"))).forEach(buttonWidget -> {
            buttonWidget.field_22763 = false;
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.save"), button -> this.saveImage()).method_46434(5, buttonY, buttonWidth, buttonHeight).method_46431();
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.delete"), button -> this.deleteImage()).method_46434(buttonWidth + 10, buttonY, buttonWidth, buttonHeight).method_46431();
        this.openInAppButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_app"), button -> this.openImageInApp()).method_46434(2 * buttonWidth + 15, buttonY, buttonWidth, buttonHeight).method_46431();
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.edit"), button -> {
            if (this.clickedImageIndex >= 0 && this.clickedImageIndex < imagePaths.size()) {
                Path imagePath = imagePaths.get(this.clickedImageIndex);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new EditScreen(this, imagePath, null, image -> {}));
                }
            }
        }).method_46434(3 * buttonWidth + 20, buttonY, buttonWidth, buttonHeight).method_46431();
        this.configButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.config"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ConfigScreen());
            }
        }).method_46434(5, 5, buttonWidth / 2, buttonHeight).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.deleteButton);
        this.method_37063((class_364)this.openInAppButton);
        this.method_37063((class_364)this.configButton);
        this.method_37063((class_364)this.editButton);
        this.saveButton.field_22764 = false;
        this.deleteButton.field_22764 = false;
        this.openInAppButton.field_22764 = false;
        this.editButton.field_22764 = false;
        this.configButton.field_22764 = true;
        this.buttonsToHideOnOverlap.add(this.saveButton);
        this.buttonsToHideOnOverlap.add(this.deleteButton);
        this.buttonsToHideOnOverlap.add(this.openInAppButton);
        this.buttonsToHideOnOverlap.add(this.editButton);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isImageClicked) {
                int imageWidth = (int)(1920.0 * this.zoomLevel);
                int imageHeight = (int)(1080.0 * this.zoomLevel);
                if (this.field_22787 != null) {
                    imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
                    imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
                }
                int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
                int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
                if (mouseX >= (double)x && mouseX <= (double)(x + imageWidth) && mouseY >= (double)y && mouseY <= (double)(y + imageHeight)) {
                    return false;
                }
                for (class_364 buttonWidget : this.method_25396()) {
                    if (buttonWidget == null || !buttonWidget.method_25405(mouseX, mouseY)) continue;
                    return super.method_25402(mouseX, mouseY, button);
                }
                this.isImageClicked = false;
                this.clickedImageIndex = -1;
                return true;
            }
            int totalImages = imageIds.size();
            for (int i = 0; i < totalImages; ++i) {
                int row = i / IMAGES_PER_ROW;
                int col = i % IMAGES_PER_ROW;
                int x = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2 + col * (IMAGE_WIDTH + GAP);
                int y = TOP_PADDING + 20 + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + IMAGE_WIDTH)) || !(mouseY > (double)y) || !(mouseY < (double)(y + IMAGE_HEIGHT))) continue;
                this.isImageClicked = true;
                this.clickedImageIndex = i;
                this.zoomLevel = 1.0;
                this.imageOffsetX = 0.0;
                this.imageOffsetY = 0.0;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.isImageClicked && this.clickedImageIndex >= 0) {
            double mouseXRelative = mouseX - (double)this.field_22789 / 2.0;
            double mouseYRelative = mouseY - (double)this.field_22790 / 2.0;
            double imageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double imageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            double mouseXInImage = -(mouseXRelative - this.imageOffsetX);
            double mouseYInImage = -(mouseYRelative - this.imageOffsetY);
            this.zoomLevel = Math.min(Math.max(this.zoomLevel + (verticalAmount > 0.0 ? 0.1 : -0.1), 0.5), 10.0);
            double newImageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double newImageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            this.imageOffsetX += mouseXInImage * (newImageWidth / imageWidth - 1.0);
            this.imageOffsetY += mouseYInImage * (newImageHeight / imageHeight - 1.0);
            return true;
        }
        if (verticalAmount < 0.0) {
            this.scrollOffset += GAP + IMAGE_HEIGHT;
        } else if (verticalAmount > 0.0) {
            this.scrollOffset -= GAP + IMAGE_HEIGHT;
        }
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, (imageIds.size() / IMAGES_PER_ROW + 2) * (IMAGE_HEIGHT + GAP) - this.field_22790 + TOP_PADDING));
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.isImageClicked && this.clickedImageIndex >= 0) {
            this.renderEnlargedImage(context);
            this.saveButton.field_22764 = true;
            this.deleteButton.field_22764 = true;
            this.openInAppButton.field_22764 = true;
            this.editButton.field_22764 = true;
            this.configButton.field_22764 = false;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = false;
            });
        } else {
            this.renderGallery(context, mouseX, mouseY);
            this.saveButton.field_22764 = false;
            this.deleteButton.field_22764 = false;
            this.openInAppButton.field_22764 = false;
            this.editButton.field_22764 = false;
            this.configButton.field_22764 = true;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = true;
            });
        }
        boolean isImageOverlappingButtons = this.clickedImageIndex >= 0 && this.isImageOverlappingButtons();
        for (class_364 button : this.method_25396()) {
            if (!(button instanceof class_4185) || !this.buttonsToHideOnOverlap.contains(button)) continue;
            if (this.isImageClicked) {
                ((class_4185)button).field_22764 = !isImageOverlappingButtons;
                continue;
            }
            ((class_4185)button).field_22764 = false;
        }
    }

    private void renderGallery(class_332 context, int mouseX, int mouseY) {
        int startX = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2;
        int startY = TOP_PADDING + 20;
        for (int i = 0; i < imageIds.size(); ++i) {
            int row = i / IMAGES_PER_ROW;
            int col = i % IMAGES_PER_ROW;
            int x = startX + col * (IMAGE_WIDTH + GAP);
            int y = startY + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
            context.method_25294(x - 2, y - 2, x + IMAGE_WIDTH + 2, y + IMAGE_HEIGHT + 2, -7829368);
            class_2960 imageId = imageIds.get(i);
            RenderSystem.setShaderTexture((int)0, (class_2960)imageId);
            context.method_25290(imageId, x, y, 0.0f, 0.0f, IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_WIDTH, IMAGE_HEIGHT);
            if (mouseX <= x || mouseX >= x + IMAGE_WIDTH || mouseY <= y || mouseY >= y + IMAGE_HEIGHT) continue;
            context.method_25294(x, y, x + IMAGE_WIDTH, y + IMAGE_HEIGHT, -2130706433);
        }
    }

    private void renderEnlargedImage(class_332 context) {
        if (this.clickedImageIndex < 0 || this.clickedImageIndex >= imageIds.size()) {
            return;
        }
        class_2960 clickedImageId = imageIds.get(this.clickedImageIndex);
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        } else {
            logger.info("Failed to get client while trying to get screen resolution while rendering large image, proceeding with 1920x1080");
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int borderWidth = 5;
        context.method_25294(x - borderWidth, y - borderWidth, x + imageWidth + borderWidth, y + imageHeight + borderWidth, -1);
        RenderSystem.setShaderTexture((int)0, (class_2960)clickedImageId);
        RenderSystem.enableBlend();
        context.method_25290(clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        RenderSystem.disableBlend();
    }

    private void loadAllImagesAsync() {
        Path screenshotsDir = Paths.get(System.getProperty("user.dir"), "screenshots");
        CompletableFuture.runAsync(() -> {
            try (Stream<Path> paths = Files.list(screenshotsDir);){
                paths.filter(path -> path.toString().endsWith(".png")).forEach(imagePaths::add);
                this.loadImagesAsync();
            }
            catch (IOException e) {
                logger.error("Failed to load images: {}", (Object)e.getMessage());
            }
        });
    }

    private void loadImagesAsync() {
        CompletableFuture.runAsync(() -> {
            for (Path path : imagePaths) {
                try {
                    class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(path, new OpenOption[0]));
                    class_2960 textureId = class_2960.method_60655((String)"gallery", (String)("textures/" + path.getFileName().toString()));
                    class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(image));
                    imageIds.add(textureId);
                }
                catch (IOException e) {
                    logger.error("Failed to load image '{}': {}", (Object)path, (Object)e.getMessage());
                }
            }
        });
    }

    private void saveImage() {
        if (this.clickedImageIndex >= 0 && this.clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(this.clickedImageIndex);
            Path savePath = Paths.get(System.getProperty("user.home"), "Desktop", "Saved_" + imagePath.getFileName().toString());
            try {
                Files.copy(imagePath, savePath, new CopyOption[0]);
                logger.info("Image saved to: {}", (Object)savePath);
            }
            catch (IOException e) {
                logger.error("Failed to save image: {}", (Object)e.getMessage());
            }
        }
    }

    private void deleteImage() {
        if (this.clickedImageIndex >= 0 && this.clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(this.clickedImageIndex);
            try {
                Files.delete(imagePath);
                imagePaths.remove(this.clickedImageIndex);
                imageIds.remove(this.clickedImageIndex);
                logger.info("Image deleted: {}", (Object)imagePath);
                this.clickedImageIndex = -1;
                this.isImageClicked = false;
            }
            catch (IOException e) {
                logger.error("Failed to delete image: {}", (Object)e.getMessage());
            }
        }
    }

    private void openImageInApp() {
        if (this.clickedImageIndex >= 0 && this.clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(this.clickedImageIndex);
            try {
                ProcessBuilder processBuilder;
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("win")) {
                    processBuilder = new ProcessBuilder("explorer", imagePath.toAbsolutePath().toString());
                } else if (os.contains("mac")) {
                    processBuilder = new ProcessBuilder("open", imagePath.toAbsolutePath().toString());
                } else if (os.contains("nix") || os.contains("nux")) {
                    processBuilder = new ProcessBuilder("xdg-open", imagePath.toAbsolutePath().toString());
                } else {
                    logger.error("Unsupported operating system for opening the image.");
                    return;
                }
                processBuilder.start();
            }
            catch (IOException e) {
                logger.error("Failed to open image with external application: {}", (Object)e.getMessage());
            }
        }
    }

    private boolean isImageOverlappingButtons() {
        if (!this.isImageClicked || this.clickedImageIndex < 0) {
            return false;
        }
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        for (class_364 button : this.method_25396()) {
            if (!this.isButtonCoveredByImage((class_4185)button, x, y, imageWidth, imageHeight)) continue;
            return true;
        }
        return false;
    }

    private boolean isButtonCoveredByImage(class_4185 button, int imageX, int imageY, int imageWidth, int imageHeight) {
        int buttonX = button.method_46426();
        int buttonY = button.method_46427();
        int buttonWidth = button.method_25368();
        int buttonHeight = button.method_25364();
        return buttonX + buttonWidth >= imageX && buttonX <= imageX + imageWidth && buttonY + buttonHeight >= imageY && buttonY <= imageY + imageHeight;
    }

    public void method_25410(class_310 client, int width, int height) {
        client.method_1507(null);
        super.method_25410(client, width, height);
    }

    public void method_25419() {
        if (this.isImageClicked) {
            this.isImageClicked = false;
            this.clickedImageIndex = -1;
        } else {
            super.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }
}

