/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.screen.GalleryScreen;
import de.thecoolcraft11.util.ReceivePackets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGalleryScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(WebGalleryScreen.class);
    private static final List<class_2960> imageIds = new ArrayList<class_2960>();
    private static final List<String> imagePaths = new ArrayList<String>();
    private static final int IMAGES_PER_ROW = 5;
    private static int IMAGE_WIDTH = 192;
    private static int IMAGE_HEIGHT = 108;
    private static int GAP = 10;
    private static int TOP_PADDING = 35;
    private boolean isImageClicked = false;
    private int clickedImageIndex = -1;
    private int scrollOffset = 0;
    private double zoomLevel = 1.0;
    private double imageOffsetX = 0.0;
    private double imageOffsetY = 0.0;
    private final class_437 parent;
    private final String webserverUrl;
    private final String initialImageName;
    private class_4185 openInBrowserButton;
    private final List<class_4185> navigatorButtons = new ArrayList<class_4185>();
    private final List<class_4185> buttonsToHideOnOverlap = new ArrayList<class_4185>();
    private class_4185 saveButton;
    private class_4185 openInAppButton;
    private class_4185 shareButton;
    private static final List<JsonObject> metaDatas = new ArrayList<JsonObject>();

    public WebGalleryScreen(class_437 parent, String webserverUrl, String initialImageName) {
        super((class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.screenshot_gallery.web_title", (Object[])new Object[]{webserverUrl}));
        this.parent = Objects.requireNonNullElseGet(parent, GalleryScreen::new);
        this.webserverUrl = webserverUrl;
        this.initialImageName = initialImageName;
    }

    protected void method_25426() {
        super.method_25426();
        imageIds.clear();
        imagePaths.clear();
        this.navigatorButtons.clear();
        int scaledHeight = this.field_22790 / 6;
        int scaledWidth = scaledHeight * 16 / 9;
        int scaledGap = scaledHeight / 10;
        TOP_PADDING = this.field_22790 / 20;
        IMAGE_WIDTH = scaledWidth;
        IMAGE_HEIGHT = scaledHeight;
        GAP = scaledGap;
        WebGalleryScreen.loadScreenshotsFromServer(this.webserverUrl);
        int buttonWidth = this.field_22789 / 8;
        int buttonHeight = this.field_22790 / 25;
        int buttonSpacing = buttonWidth / 5;
        int xPosition = (this.field_22789 - (buttonWidth * (this.navigatorButtons.size() + 1) + buttonSpacing * (this.navigatorButtons.size() - 1))) / 5;
        int buttonY = (int)((double)this.field_22790 * 0.9);
        int navigatorY = (int)((double)this.field_22790 * 0.01);
        this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.my_gallery"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            } else {
                logger.error("Failed to get client");
            }
        }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
        xPosition += buttonWidth + buttonSpacing;
        if (ReceivePackets.gallerySiteAddress != null) {
            if (!ReceivePackets.gallerySiteAddress.equals(this.webserverUrl)) {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.server_gallery"), button -> {
                    String webserverUrl = ReceivePackets.gallerySiteAddress;
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                    } else {
                        logger.error("Failed to get client trying to open Server Gallery with URL {}", (Object)webserverUrl);
                    }
                }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            } else {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"), button -> {}).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
                this.openInBrowserButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_browser"), button -> this.openBrowser(ReceivePackets.homeSiteAddress)).method_46434(this.field_22789 - buttonWidth, buttonY, buttonWidth, buttonHeight).method_46431();
            }
            xPosition += buttonWidth + buttonSpacing;
        }
        for (Map.Entry<String, Map<String, String>> entry : ConfigManager.getClientConfig().upload_urls.entrySet()) {
            String webserverUrl = entry.getValue().get("gallery");
            String webserverUrlHome = entry.getValue().get("home");
            String buttonLabel = entry.getKey();
            if (webserverUrl == null || webserverUrl.isEmpty() || webserverUrlHome == null || webserverUrlHome.isEmpty()) continue;
            if (!this.webserverUrl.equals(webserverUrl)) {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonLabel), button -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                    } else {
                        logger.error("Failed to get client trying to open Gallery for {}", (Object)webserverUrl);
                    }
                }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            } else {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"), button -> {}).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            }
            if (this.openInBrowserButton == null) {
                this.openInBrowserButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_browser"), button -> this.openBrowser(webserverUrlHome)).method_46434(this.field_22789 - buttonWidth, buttonY, buttonWidth, buttonHeight).method_46431();
            }
            xPosition += buttonWidth + buttonSpacing;
        }
        this.navigatorButtons.forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        this.method_37063((class_364)this.openInBrowserButton);
        this.navigatorButtons.forEach(buttonWidget -> {
            buttonWidget.field_22764 = true;
        });
        this.navigatorButtons.stream().filter(buttonWidget -> buttonWidget.method_25369().equals((Object)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"))).forEach(buttonWidget -> {
            buttonWidget.field_22763 = false;
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.save"), button -> this.downloadImage()).method_46434(5, buttonY, buttonWidth, buttonHeight).method_46431();
        this.openInAppButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_sc_in_browser"), button -> this.openInBrowser()).method_46434(buttonWidth + 10, buttonY, buttonWidth, buttonHeight).method_46431();
        this.shareButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.share_screenshot"), button -> this.shareScreenshot()).method_46434(buttonWidth * 2 + 15, buttonY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.openInAppButton);
        this.method_37063((class_364)this.shareButton);
        this.saveButton.field_22764 = false;
        this.openInAppButton.field_22764 = false;
        this.shareButton.field_22764 = false;
        this.buttonsToHideOnOverlap.add(this.saveButton);
        this.buttonsToHideOnOverlap.add(this.openInAppButton);
        this.buttonsToHideOnOverlap.add(this.shareButton);
        int initialImageIndex = imagePaths.indexOf(this.initialImageName);
        if (initialImageIndex >= 0) {
            this.isImageClicked = true;
            this.clickedImageIndex = initialImageIndex;
            this.zoomLevel = 1.0;
            this.imageOffsetX = 0.0;
            this.imageOffsetY = 0.0;
        }
    }

    private void shareScreenshot() {
        StringBuilder template = new StringBuilder(ConfigManager.getClientConfig().shareText);
        String message = template.toString().contains("{sharedLink}") ? template.replace(template.indexOf("{sharedLink}"), "{sharedLink}".length(), imagePaths.get(this.clickedImageIndex)).toString() : template.toString();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.method_1562() != null) {
            client.method_1562().method_45729(message);
            client.method_1507(null);
        }
    }

    private void openBrowser(String url) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            ProcessBuilder processBuilder;
            if (os.contains("win")) {
                processBuilder = new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url);
            } else if (os.contains("mac")) {
                processBuilder = new ProcessBuilder("open", url);
            } else if (os.contains("nix") || os.contains("nux")) {
                processBuilder = new ProcessBuilder("xdg-open", url);
            } else {
                logger.error("Unsupported operating system for opening the home URL.");
                return;
            }
            processBuilder.start();
        }
        catch (IOException e) {
            logger.error("Failed to open the home URL {}: {}", (Object)url, (Object)e.getMessage());
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isImageClicked) {
                int imageWidth = (int)(1920.0 * this.zoomLevel);
                int imageHeight = (int)(1080.0 * this.zoomLevel);
                if (this.field_22787 != null) {
                    imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
                    imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
                }
                int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
                int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
                if (mouseX >= (double)x && mouseX <= (double)(x + imageWidth) && mouseY >= (double)y && mouseY <= (double)(y + imageHeight)) {
                    return false;
                }
                for (class_364 buttonWidget : this.method_25396()) {
                    if (buttonWidget == null || !buttonWidget.method_25405(mouseX, mouseY)) continue;
                    return super.method_25402(mouseX, mouseY, button);
                }
                this.isImageClicked = false;
                this.clickedImageIndex = -1;
                return true;
            }
            int totalImages = imageIds.size();
            for (int i = 0; i < totalImages; ++i) {
                int row = i / 5;
                int col = i % 5;
                int x = (this.field_22789 - (5 * IMAGE_WIDTH + 4 * GAP)) / 2 + col * (IMAGE_WIDTH + GAP);
                int y = TOP_PADDING + 20 + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + IMAGE_WIDTH)) || !(mouseY > (double)y) || !(mouseY < (double)(y + IMAGE_HEIGHT))) continue;
                this.isImageClicked = true;
                this.clickedImageIndex = i;
                this.zoomLevel = 1.0;
                this.imageOffsetX = 0.0;
                this.imageOffsetY = 0.0;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.isImageClicked && this.clickedImageIndex >= 0) {
            this.zoomAndRepositionImage(mouseX, mouseY, verticalAmount);
            return true;
        }
        this.scrollOffset += verticalAmount > 0.0 ? -(IMAGE_HEIGHT + GAP) : IMAGE_HEIGHT + GAP;
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.calculateMaxScrollOffset()));
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void zoomAndRepositionImage(double mouseX, double mouseY, double verticalAmount) {
        double mouseXRelative = mouseX - (double)this.field_22789 / 2.0;
        double mouseYRelative = mouseY - (double)this.field_22790 / 2.0;
        double imageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
        double imageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
        double mouseXInImage = -(mouseXRelative - this.imageOffsetX);
        double mouseYInImage = -(mouseYRelative - this.imageOffsetY);
        this.zoomLevel = Math.min(Math.max(this.zoomLevel + (verticalAmount > 0.0 ? 0.1 : -0.1), 0.5), 10.0);
        double newImageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
        double newImageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
        this.imageOffsetX += mouseXInImage * (newImageWidth / imageWidth - 1.0);
        this.imageOffsetY += mouseYInImage * (newImageHeight / imageHeight - 1.0);
    }

    private int calculateMaxScrollOffset() {
        return (imageIds.size() / 5 + 2) * (IMAGE_HEIGHT + GAP) - this.field_22790 + TOP_PADDING;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.isImageClicked && this.clickedImageIndex >= 0) {
            this.saveButton.field_22764 = true;
            this.openInAppButton.field_22764 = true;
            this.shareButton.field_22764 = true;
            this.renderEnlargedImage(context);
            this.openInBrowserButton.field_22764 = false;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = false;
            });
        } else {
            this.saveButton.field_22764 = false;
            this.openInAppButton.field_22764 = false;
            this.shareButton.field_22764 = false;
            this.renderGallery(context, mouseX, mouseY);
            this.openInBrowserButton.field_22764 = true;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = true;
            });
        }
        boolean isImageOverlappingButtons = this.clickedImageIndex >= 0 && this.isImageOverlappingButtons();
        for (class_364 button : this.method_25396()) {
            if (!(button instanceof class_4185) || !this.buttonsToHideOnOverlap.contains(button)) continue;
            if (this.isImageClicked) {
                ((class_4185)button).field_22764 = !isImageOverlappingButtons;
                continue;
            }
            ((class_4185)button).field_22764 = false;
        }
    }

    private boolean isImageOverlappingButtons() {
        if (!this.isImageClicked || this.clickedImageIndex < 0) {
            return false;
        }
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        for (class_364 button : this.method_25396()) {
            if (!this.isButtonCoveredByImage((class_4185)button, x, y, imageWidth, imageHeight)) continue;
            return true;
        }
        return false;
    }

    private boolean isButtonCoveredByImage(class_4185 button, int imageX, int imageY, int imageWidth, int imageHeight) {
        int buttonX = button.method_46426();
        int buttonY = button.method_46427();
        int buttonWidth = button.method_25368();
        int buttonHeight = button.method_25364();
        return buttonX + buttonWidth >= imageX && buttonX <= imageX + imageWidth && buttonY + buttonHeight >= imageY && buttonY <= imageY + imageHeight;
    }

    private void renderGallery(class_332 context, int mouseX, int mouseY) {
        int startX = (this.field_22789 - (5 * IMAGE_WIDTH + 4 * GAP)) / 2;
        int startY = TOP_PADDING + 20;
        for (int i = 0; i < imageIds.size(); ++i) {
            int row = i / 5;
            int col = i % 5;
            int x = startX + col * (IMAGE_WIDTH + GAP);
            int y = startY + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
            context.method_25294(x - 2, y - 2, x + IMAGE_WIDTH + 2, y + IMAGE_HEIGHT + 2, -7829368);
            class_2960 imageId = imageIds.get(i);
            RenderSystem.setShaderTexture((int)0, (class_2960)imageId);
            context.method_25290(imageId, x, y, 0.0f, 0.0f, IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_WIDTH, IMAGE_HEIGHT);
            if (mouseX > x && mouseX < x + IMAGE_WIDTH && mouseY > y && mouseY < y + IMAGE_HEIGHT) {
                context.method_25294(x, y, x + IMAGE_WIDTH, y + IMAGE_HEIGHT, -2130706433);
            }
            String username = WebGalleryScreen.getString(i);
            if (this.field_22787 == null) continue;
            int textX = x + 5;
            int textY = y + IMAGE_HEIGHT - 10;
            context.method_51433(this.field_22787.field_1772, username, textX, textY, 0xFFFFFF, false);
        }
    }

    private static String getString(int i) {
        String username = "Unknown";
        if (metaDatas.get(i) != null) {
            JsonObject metaData = metaDatas.get(i);
            if (metaData.has("username") && !metaData.get("username").isJsonNull()) {
                username = metaData.get("username").getAsString();
            } else if (metaData.has("fileUsername") && !metaData.get("fileUsername").isJsonNull()) {
                username = metaData.get("fileUsername").getAsString();
            }
        }
        return username;
    }

    private void renderEnlargedImage(class_332 context) {
        if (this.clickedImageIndex < 0 || this.clickedImageIndex >= imageIds.size()) {
            return;
        }
        class_2960 clickedImageId = imageIds.get(this.clickedImageIndex);
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int borderWidth = 5;
        context.method_25294(x - borderWidth, y - borderWidth, x + imageWidth + borderWidth, y + imageHeight + borderWidth, -1);
        RenderSystem.setShaderTexture((int)0, (class_2960)clickedImageId);
        RenderSystem.enableBlend();
        context.method_25290(clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        RenderSystem.disableBlend();
        int sidebarWidth = 300;
        int sidebarHeight = imageHeight;
        int sidebarX = x - sidebarWidth > 0 ? x - sidebarWidth : x + imageWidth;
        context.method_25294(sidebarX, y, sidebarX + sidebarWidth, y + sidebarHeight, -872415232);
        if (this.clickedImageIndex >= 0 && this.clickedImageIndex < metaDatas.size()) {
            LinkedHashMap<class_2561, class_2561> drawableInfo = this.getStringStringMap();
            int textX = sidebarX + 10;
            int textY = y + 20;
            for (class_2561 info : drawableInfo.keySet()) {
                context.method_51439(this.field_22787.field_1772, (class_2561)info.method_27661().method_10852((class_2561)drawableInfo.get(info)), textX, textY, 0xFFFFFF, false);
                textY += 10;
            }
        }
    }

    @NotNull
    private LinkedHashMap<class_2561, class_2561> getStringStringMap() {
        JsonObject metaData = metaDatas.get(this.clickedImageIndex);
        LinkedHashMap<class_2561, class_2561> drawableInfo = new LinkedHashMap<class_2561, class_2561>();
        drawableInfo.put((class_2561)class_2561.method_43470((String)"Username: "), (class_2561)(metaData.has("username") && metaData.get("username").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("username").getAsString()) : (metaData.has("fileUsername") && metaData.get("fileUsername").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("fileUsername").getAsString()) : class_2561.method_43470((String)"N/A"))));
        drawableInfo.put((class_2561)class_2561.method_43470((String)"Server: "), (class_2561)(metaData.has("server_address") && metaData.get("server_address").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("server_address").getAsString()) : class_2561.method_43470((String)"N/A")));
        drawableInfo.put((class_2561)class_2561.method_43470((String)"World: "), (class_2561)(metaData.has("world_name") && metaData.get("world_name").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_name").getAsString()) : class_2561.method_43470((String)"N/A")));
        drawableInfo.put((class_2561)class_2561.method_43470((String)"Location: "), (class_2561)(metaData.has("coordinates") && metaData.get("coordinates").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("coordinates").getAsString()) : class_2561.method_43470((String)"N/A")));
        drawableInfo.put((class_2561)class_2561.method_43470((String)"Biome: "), (class_2561)(metaData.has("biome") && metaData.get("biome").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("biome").getAsString()) : class_2561.method_43470((String)"N/A")));
        drawableInfo.put((class_2561)class_2561.method_43470((String)" "), (class_2561)class_2561.method_43470((String)" "));
        drawableInfo.put((class_2561)(metaData.has("current_time") ? WebGalleryScreen.getTimestamp(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? WebGalleryScreen.getTimestamp(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        drawableInfo.put((class_2561)(metaData.has("current_time") ? WebGalleryScreen.getTimeAgo(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? WebGalleryScreen.getTimeAgo(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        return drawableInfo;
    }

    private static void loadWebImage(String imageUrl) {
        block49: {
            String cacheFileName = "screenshots_cache/" + imageUrl.hashCode() + ".png";
            File cachedImage = new File(cacheFileName);
            if (cachedImage.exists()) {
                try (InputStream fileInputStream = Files.newInputStream(cachedImage.toPath(), new OpenOption[0]);
                     class_1011 loadedImage = class_1011.method_4309((InputStream)fileInputStream);){
                    class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                    if (class_310.method_1551() != null) {
                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(loadedImage));
                        imageIds.add(textureId);
                    } else {
                        logger.error("Failed to get client while loading web image!");
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to load cached image: {}", (Object)e.getMessage());
                }
            } else {
                try {
                    URI uri = new URI(imageUrl);
                    URL url = uri.toURL();
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.connect();
                    if (connection.getResponseCode() == 200) {
                        try (InputStream inputStream = connection.getInputStream();){
                            BufferedImage bufferedImage = ImageIO.read(inputStream);
                            if (bufferedImage == null) break block49;
                            File cacheFolder = new File("screenshots_cache");
                            if (!cacheFolder.exists() && cacheFolder.mkdirs()) {
                                logger.info("Created web screenshots cache folder");
                            }
                            ImageIO.write((RenderedImage)bufferedImage, "PNG", cachedImage);
                            logger.info("Image saved to cache: {}", (Object)cachedImage.getAbsolutePath());
                            try (class_1011 nativeImage = new class_1011(bufferedImage.getWidth(), bufferedImage.getHeight(), false);){
                                for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                                    for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                                        int rgb = bufferedImage.getRGB(x, y);
                                        int alpha = rgb >> 24 & 0xFF;
                                        int red = rgb >> 16 & 0xFF;
                                        int green = rgb >> 8 & 0xFF;
                                        int blue = rgb & 0xFF;
                                        int argb = alpha << 24 | red << 16 | green << 8 | blue;
                                        nativeImage.method_4305(x, y, argb);
                                    }
                                }
                                try (InputStream fileInputStream = Files.newInputStream(cachedImage.toPath(), new OpenOption[0]);
                                     class_1011 loadedImage = class_1011.method_4309((InputStream)fileInputStream);){
                                    class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                                    if (class_310.method_1551() != null) {
                                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(loadedImage));
                                        imageIds.add(textureId);
                                    } else {
                                        logger.error("Failed to get client while saving the web image!");
                                    }
                                    break block49;
                                }
                            }
                        }
                    }
                    logger.error("Failed to load image from URL: {}", (Object)imageUrl);
                }
                catch (IOException | URISyntaxException e) {
                    logger.error("Failed to download web screenshots: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static void loadScreenshotsFromServer(String server) {
        metaDatas.clear();
        List<AbstractMap.SimpleEntry<String, JsonObject>> screenshotData = WebGalleryScreen.requestScreenshotListFromServer(server);
        screenshotData.forEach(entry -> {
            String url = (String)entry.getKey();
            JsonObject metaData = (JsonObject)entry.getValue();
            imagePaths.add(url);
            metaDatas.add(metaData);
            WebGalleryScreen.loadWebImage(url);
        });
    }

    private static List<AbstractMap.SimpleEntry<String, JsonObject>> requestScreenshotListFromServer(String server) {
        ArrayList<AbstractMap.SimpleEntry<String, JsonObject>> screenshotData = new ArrayList<AbstractMap.SimpleEntry<String, JsonObject>>();
        try {
            URI uri = new URI(server);
            URL url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            if (status == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonArray jsonArray = JsonParser.parseString((String)response.toString()).getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject screenshot = jsonArray.get(i).getAsJsonObject();
                    String urlStr = screenshot.get("url").getAsString();
                    JsonObject metaData = screenshot.get("metaData").isJsonObject() ? screenshot.get("metaData").getAsJsonObject() : new JsonObject();
                    metaData.add("fileUsername", screenshot.get("username"));
                    metaData.add("date", screenshot.get("date"));
                    screenshotData.add(new AbstractMap.SimpleEntry<String, JsonObject>(urlStr, metaData));
                }
            } else {
                logger.error("Failed to fetch data. HTTP Status: {}", (Object)status);
            }
        }
        catch (Exception e) {
            logger.error("Failed to request screenshot list: {}", (Object)e.getMessage());
        }
        return screenshotData;
    }

    private void downloadImage() {
        if (this.clickedImageIndex >= 0 && this.clickedImageIndex < imagePaths.size()) {
            try {
                URI imageUri = new URI(imagePaths.get(this.clickedImageIndex));
                URL imageUrl = imageUri.toURL();
                Path savePath = Paths.get(System.getProperty("user.home"), "Desktop", "Downloaded_" + String.valueOf(Paths.get(imageUri.getPath(), new String[0]).getFileName()));
                try (InputStream inputStream = imageUrl.openStream();){
                    Files.copy(inputStream, savePath, new CopyOption[0]);
                    logger.info("Image downloaded to: {}", (Object)savePath);
                }
            }
            catch (Exception e) {
                logger.error("Failed to download image: {}", (Object)e.getMessage());
            }
        } else {
            logger.warn("Invalid image while downloading index: {}", (Object)this.clickedImageIndex);
        }
    }

    private void openInBrowser() {
        if (this.clickedImageIndex >= 0 && this.clickedImageIndex < imagePaths.size()) {
            String os = System.getProperty("os.name").toLowerCase();
            String url = imagePaths.get(this.clickedImageIndex);
            try {
                ProcessBuilder processBuilder;
                if (os.contains("win")) {
                    processBuilder = new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url);
                } else if (os.contains("mac")) {
                    processBuilder = new ProcessBuilder("open", url);
                } else if (os.contains("nix") || os.contains("nux")) {
                    processBuilder = new ProcessBuilder("xdg-open", url);
                } else {
                    logger.error("Unsupported operating system for opening the image URL.");
                    return;
                }
                processBuilder.start();
            }
            catch (IOException e) {
                logger.error("Failed to open the image URL {}: {}", (Object)url, (Object)e.getMessage());
            }
        } else {
            logger.warn("Invalid image index while opening: {}", (Object)this.clickedImageIndex);
        }
    }

    public static class_2561 getTimestamp(long millis) {
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        LocalDateTime timestampDateTime = LocalDateTime.ofInstant(timestampInstant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        return class_2561.method_43470((String)timestampDateTime.format(formatter)).method_27694(style -> style.method_30938(Boolean.valueOf(true)));
    }

    private static class_2561 getTimeAgo(long millis) {
        Instant nowInstant;
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        Duration duration = Duration.between(timestampInstant, nowInstant = Instant.now());
        long seconds = duration.getSeconds();
        if (seconds < 60L) {
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.seconds_ago", (Object[])new Object[]{seconds}).method_27693(")"));
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.minutes_ago", (Object[])new Object[]{minutes}).method_27693(")"));
        }
        if (seconds < 86400L) {
            long hours = seconds / 3600L;
            long minutes = seconds % 3600L / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.hours_ago", (Object[])new Object[]{hours, minutes}).method_27693(")"));
        }
        long days = seconds / 86400L;
        return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.days_ago", (Object[])new Object[]{days}).method_27693(")"));
    }

    public void method_25410(class_310 client, int width, int height) {
        client.method_1507(null);
        super.method_25410(client, width, height);
    }

    public void method_25419() {
        if (this.isImageClicked) {
            this.isImageClicked = false;
            this.clickedImageIndex = -1;
        } else {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
            super.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }
}

