/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.thecoolcraft11.ScreenshotUploaderServer;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.packet.ScreenshotResponsePayload;
import de.thecoolcraft11.util.DiscordWebhook;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivePackets {
    private static final Logger logger = LoggerFactory.getLogger(ReceivePackets.class);
    public static String serverSiteAddress = null;
    public static String gallerySiteAddress = null;
    public static String homeSiteAddress = null;

    public static void receiveAddress(class_310 client, String message) {
        JsonObject jsonObject = JsonParser.parseString((String)message).getAsJsonObject();
        String uploadAddr = jsonObject.get("upload").getAsString();
        String homeAddr = jsonObject.get("home").getAsString();
        String uploadDir = uploadAddr.equals("mcserver://this") ? "This Server" : uploadAddr;
        client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.next_upload", (Object[])new Object[]{uploadDir}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, homeAddr)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"message.screenshot_uploader.next_upload_description", (Object[])new Object[]{class_2561.method_43470((String)homeAddr).method_27694(style2 -> style2.method_10977(class_124.field_1075)), class_2561.method_43472((String)"key.screenshot_uploader.gallery")})))));
        serverSiteAddress = uploadAddr;
        gallerySiteAddress = jsonObject.get("gallery").getAsString();
        homeSiteAddress = homeAddr;
    }

    public static void receiveScreenshotRes(JsonObject responseBody, class_310 client) {
        String statusMessage = responseBody.get("status").getAsString();
        if ("success".equals(statusMessage)) {
            String screenshotUrl = responseBody.has("url") && !responseBody.get("url").isJsonNull() ? responseBody.get("url").getAsString() : null;
            String galleryUrl = responseBody.has("gallery") && !responseBody.get("gallery").isJsonNull() ? responseBody.get("gallery").getAsString() : null;
            String baseMessage = "message.screenshot_uploader.upload_success";
            class_5250 clickableLink = class_2561.method_43473();
            class_5250 clickableLink2 = class_2561.method_43473();
            if (screenshotUrl != null) {
                clickableLink = class_2561.method_43471((String)"message.screenshot_uploader.open_link").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, screenshotUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.screenshot_uploader.see_screenshot"))).method_10977(class_124.field_1075));
            }
            if (galleryUrl != null) {
                clickableLink2 = class_2561.method_43471((String)"message.screenshot_uploader.open_all").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, galleryUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.screenshot_uploader.see_screenshots"))).method_10977(class_124.field_1054));
            }
            if (screenshotUrl == null && galleryUrl == null) {
                baseMessage = "message.screenshot_uploader_no_return_url";
            }
            class_5250 finalMessage = class_2561.method_43469((String)baseMessage, (Object[])new Object[]{clickableLink, clickableLink2});
            client.field_1705.method_1743().method_1812((class_2561)finalMessage);
        } else {
            String errorMessage = responseBody.has("message") ? responseBody.get("message").getAsString() : "Unknown error";
            class_5250 errorText = class_2561.method_43469((String)"message.screenshot_uploader.upload_failed", (Object[])new Object[]{errorMessage.split(":")[0]});
            client.field_1705.method_1743().method_1812((class_2561)errorText);
        }
    }

    public static void handleReceivedScreenshot(byte[] screenshotData, String jsonData, class_3222 player) {
        try {
            String playerName = player.method_5477().getString();
            String baseFileName = "screenshot-" + playerName + "_" + System.currentTimeMillis();
            String screenshotFileName = baseFileName + ".png";
            File screenshotFile = new File("screenshotUploader/" + screenshotFileName);
            Files.write(screenshotFile.toPath(), screenshotData, new OpenOption[0]);
            logger.info("Screenshot received from {} and saved as {}", (Object)player.method_5477().getString(), (Object)screenshotFileName);
            String jsonFileName = "screenshotUploader/screenshots/" + baseFileName + ".json";
            try (FileWriter fileWriter = new FileWriter(jsonFileName);){
                fileWriter.write(jsonData);
                logger.info("JSON data saved as {}", (Object)jsonFileName);
            }
            catch (IOException e) {
                logger.error("Error saving JSON data: {}", (Object)e.getMessage());
            }
            String uploadedFilePath = "screenshotUploader/" + screenshotFileName;
            String outputFilePath = "screenshotUploader/screenshots/" + ReceivePackets.formatFileName(screenshotFileName, playerName);
            ReceivePackets.convertToJpeg(uploadedFilePath, outputFilePath);
            Files.delete(Paths.get(uploadedFilePath, new String[0]));
            Object urlString = ScreenshotUploaderServer.getServerIp();
            if (!((String)urlString).matches("^https?://.*")) {
                urlString = "http://" + (String)urlString;
            }
            if (!((String)urlString).matches(".*:\\d+.*")) {
                urlString = ((String)urlString).replaceFirst("^(https?://[^/]+)", "$1:" + ConfigManager.getServerConfig().port);
            }
            JsonObject jsonObject = ReceivePackets.getJsonObject((String)urlString, outputFilePath);
            try {
                JsonObject webhookJson = JsonParser.parseString((String)jsonData).getAsJsonObject();
                if (ConfigManager.getServerConfig().sendDiscordWebhook) {
                    DiscordWebhook.sendMessage(ConfigManager.getServerConfig().webhookUrl, playerName, webhookJson.get("server_address").getAsString(), webhookJson.get("dimension").getAsString(), webhookJson.get("coordinates").getAsString(), webhookJson.get("facing_direction").getAsString(), webhookJson.get("biome").getAsString(), jsonObject.get("url").getAsString(), webhookJson.get("world_info").getAsString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ScreenshotResponsePayload(jsonObject.toString()));
        }
        catch (IOException e) {
            logger.error("Error handling uploaded screenshot: {}", (Object)e.getMessage());
        }
    }

    @NotNull
    private static JsonObject getJsonObject(String websiteAddress, String outputFilePath) {
        String screenshotUrl = websiteAddress + outputFilePath.replace("screenshotUploader", "");
        String galleryUrl = websiteAddress + "/";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("message", "File uploaded successfully");
        jsonObject.addProperty("url", screenshotUrl);
        jsonObject.addProperty("gallery", galleryUrl);
        jsonObject.addProperty("status", "success");
        return jsonObject;
    }

    private static void convertToJpeg(String uploadedFilePath, String outputFilePath) throws IOException {
        BufferedImage originalImage;
        File outputFile = new File(outputFilePath);
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && parentDir.mkdirs()) {
            logger.info("Created Upload Folder");
        }
        if ((originalImage = ImageIO.read(new File(uploadedFilePath))) == null) {
            throw new IOException("Unable to read the image from the file: " + uploadedFilePath);
        }
        BufferedImage resizedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.drawImage((Image)originalImage, 0, 0, null);
        graphics.dispose();
        boolean success = ImageIO.write((RenderedImage)resizedImage, "jpg", outputFile);
        if (!success) {
            throw new IOException("Failed to save the image to: " + outputFilePath);
        }
    }

    private static String formatFileName(String originalFilename, String username) {
        String regex = "(screenshot)(\\d+)(\\.png)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(originalFilename);
        if (matcher.find()) {
            String baseName = matcher.group(1);
            String digits = matcher.group(2);
            return baseName + "-" + username + "_" + digits + ".jpg";
        }
        return originalFilename;
    }
}

