/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotUploader
implements ModInitializer {
    public static final String MOD_ID = "screenshot-uploader";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"screenshot-uploader");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("./config/screenshotUploader/config.json");
    private static JsonObject config;

    public void onInitialize() {
        this.loadConfig();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            LOGGER.info("Player joined a server. Reloading config...");
            ScreenshotUploader.reloadConfig();
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("Player left the server. Reloading config...");
            ScreenshotUploader.reloadConfig();
        });
    }

    private void createDefaultConfig() {
        try {
            File parentDir = CONFIG_FILE.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new IOException("Failed to create config directory: " + parentDir.getAbsolutePath());
            }
            config = new JsonObject();
            config.addProperty("upload_url", "https://chipmunk-polite-loon.ngrok-free.app/api/upload-screenshot");
            config.addProperty("requireNoHud", Boolean.valueOf(true));
            config.addProperty("limitToServer", Boolean.valueOf(false));
            config.addProperty("limitedServerAddr", "");
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((JsonElement)config, (Appendable)writer);
                LOGGER.info("Default config created at: {}", (Object)CONFIG_FILE.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default config: {}", (Object)e.getMessage());
        }
    }

    private void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            this.createDefaultConfig();
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            config = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            System.out.println("Config loaded successfully!");
        }
        catch (IOException e) {
            System.err.println("Failed to load config: " + e.getMessage());
            this.createDefaultConfig();
        }
    }

    public static JsonObject getConfig() {
        return config;
    }

    public static void reloadConfig() {
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            config = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            LOGGER.info("Config reloaded successfully!");
        }
        catch (IOException e) {
            LOGGER.error("Failed to reload config: {}", (Object)e.getMessage());
        }
    }
}

