/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.packet.AddressPayload;
import de.thecoolcraft11.packet.CommentPayload;
import de.thecoolcraft11.packet.ScreenshotPayload;
import de.thecoolcraft11.util.ReceivePackets;
import de.thecoolcraft11.util.WebServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotUploaderServer
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "screenshot-uploader";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"screenshot-uploader");

    public void onInitializeServer() {
        this.createConfig();
        this.createModFolder();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarting);
        this.prepareWebServerStart();
        ServerPlayConnectionEvents.JOIN.register(this::registerJoinEvent);
        ScreenshotUploaderServer.deleteOldScreenshots();
    }

    private void registerJoinEvent(class_3244 serverPlayNetworkHandler, PacketSender player, MinecraftServer minecraftServer) {
        if (ConfigManager.getServerConfig().sendUrlToClient) {
            JsonObject jsonObject = ScreenshotUploaderServer.getJsonObject();
            ServerPlayNetworking.send((class_3222)serverPlayNetworkHandler.method_32311(), (class_8710)new AddressPayload(jsonObject.toString()));
        }
        ServerPlayNetworking.registerGlobalReceiver(ScreenshotPayload.ID, (payload, context) -> {
            byte[] bytes = payload.bytes();
            String json = payload.json();
            context.server().execute(() -> ReceivePackets.handleReceivedScreenshot(bytes, json, context.player()));
        });
        ServerPlayNetworking.registerGlobalReceiver(CommentPayload.ID, (payload, context) -> {
            String comment = payload.comment();
            String screenshot = payload.screenshot();
            context.server().execute(() -> this.applyCommentToScreenshot(comment, screenshot, String.valueOf(context.player().method_5477().getString()), context.player().method_5667()));
        });
    }

    @NotNull
    private static JsonObject getJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("upload", "mcserver://this");
        if (ConfigManager.getServerConfig().sendGalleryUrlToClient) {
            Object urlString = ScreenshotUploaderServer.getServerIp();
            if (!((String)urlString).matches("^https?://.*")) {
                urlString = "http://" + (String)urlString;
            }
            if (!((String)urlString).matches(".*:\\d+.*")) {
                urlString = ((String)urlString).replaceFirst("^(https?://[^/]+)", "$1:" + ConfigManager.getServerConfig().port);
            }
            jsonObject.addProperty("home", (String)urlString);
            urlString = (String)urlString + "/screenshot-list";
            jsonObject.addProperty("gallery", (String)urlString);
        }
        if (ConfigManager.getServerConfig().useCustomWebURL) {
            jsonObject.remove("upload");
            jsonObject.addProperty("upload", ConfigManager.getServerConfig().customWebURL);
        }
        return jsonObject;
    }

    public void applyCommentToScreenshot(String comment, String filename, String author, UUID uuid) {
        Path BASE_DIR = Paths.get("./screenshotUploader/screenshots/", new String[0]);
        Path targetFile = BASE_DIR.resolve(filename);
        Path commentFile = BASE_DIR.resolve(filename.replace(".png", ".json"));
        try {
            if (!Files.exists(targetFile, new LinkOption[0])) {
                return;
            }
            JsonObject newComment = new JsonObject();
            newComment.add("comment", (JsonElement)new JsonPrimitive(comment));
            newComment.add("author", (JsonElement)new JsonPrimitive(author));
            newComment.add("timestamp", (JsonElement)new JsonPrimitive(Instant.now().toString()));
            newComment.add("authorUUID", (JsonElement)new JsonPrimitive(uuid.toString()));
            JsonObject existingJson = new JsonObject();
            if (Files.exists(commentFile, new LinkOption[0])) {
                String existingContent = new String(Files.readAllBytes(commentFile));
                existingJson = JsonParser.parseString((String)existingContent).getAsJsonObject();
            }
            JsonArray commentsArray = existingJson.has("comments") ? existingJson.getAsJsonArray("comments") : new JsonArray();
            commentsArray.add((JsonElement)newComment);
            existingJson.add("comments", (JsonElement)commentsArray);
            Files.createDirectories(commentFile.getParent(), new FileAttribute[0]);
            Files.write(commentFile, existingJson.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createConfig() {
        File configDir = new File("config");
        File screenshotUploaderDir = new File(configDir, "screenshotUploader");
        if (!configDir.exists() && configDir.mkdir()) {
            LOGGER.info("Created Config Folder");
        }
        if (!screenshotUploaderDir.exists() && screenshotUploaderDir.mkdir()) {
            LOGGER.info("Created ScreenshotUploader Folder");
        }
        ConfigManager.initialize(screenshotUploaderDir, false);
    }

    private void prepareWebServerStart() {
        if (ConfigManager.getServerConfig().screenshotWebserver) {
            String ipAddress = "127.0.0.1";
            int port = ConfigManager.getServerConfig().port;
            LOGGER.info("Starting web server on {}:{} ...", (Object)ipAddress, (Object)port);
            this.startWebServer();
        }
    }

    private void startWebServer() {
        String ipAddress = "127.0.0.1";
        int port = ConfigManager.getServerConfig().port;
        Object urlString = ScreenshotUploaderServer.getServerIp();
        if (!((String)urlString).matches("^https?://.*")) {
            urlString = "http://" + (String)urlString;
        }
        if (!((String)urlString).matches(".*:\\d+.*")) {
            urlString = ((String)urlString).replaceFirst("^(https?://[^/]+)", "$1:" + ConfigManager.getServerConfig().port);
        }
        try {
            WebServer.startWebServer(ipAddress, port, (String)urlString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onServerStarting(MinecraftServer server) {
        this.copyResourceToServerDir("/static/js/script.js", "screenshotUploader/static/js/script.js");
        this.copyResourceToServerDir("/static/css/style.css", "screenshotUploader/static/css/style.css");
    }

    private void copyResourceToServerDir(String resourcePath, String targetPath) {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path targetFile = gameDir.resolve(targetPath);
        try (InputStream resourceStream = this.getClass().getResourceAsStream(resourcePath);){
            if (resourceStream == null) {
                LOGGER.error("Resource not found: {}", (Object)resourcePath);
                return;
            }
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            Files.copy(resourceStream, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Error while copying resource: {}", (Object)e.getMessage());
        }
    }

    public static String getServerIp() {
        return ConfigManager.getServerConfig().websiteURL;
    }

    private static void deleteOldScreenshots() {
        if (!ConfigManager.getServerConfig().deleteOldScreenshots) {
            return;
        }
        Path screenshotDir = Paths.get("./screenshotUploader/screenshots/", new String[0]);
        if (screenshotDir.toFile().listFiles() == null) {
            return;
        }
        for (File file : Objects.requireNonNull(screenshotDir.toFile().listFiles())) {
            if (!file.isFile() || file.lastModified() >= System.currentTimeMillis() - (long)(ConfigManager.getServerConfig().deleteAfterDays * 24 * 60 * 60) * 1000L) continue;
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete old screenshot: {}", (Object)e.getMessage());
            }
        }
    }

    private void createModFolder() {
        Path screenshotDir = Paths.get("./screenshotUploader/screenshots/", new String[0]);
        Path staticDir = Paths.get("./screenshotUploader/static/", new String[0]);
        Path staticJsDir = Paths.get("./screenshotUploader/static/js/", new String[0]);
        Path staticCssDir = Paths.get("./screenshotUploader/static/css/", new String[0]);
        if (!Files.exists(screenshotDir, new LinkOption[0])) {
            try {
                Files.createDirectories(screenshotDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create screenshot directory: {}", (Object)e.getMessage());
            }
        }
        if (!Files.exists(staticDir, new LinkOption[0])) {
            try {
                Files.createDirectories(staticDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create static directory: {}", (Object)e.getMessage());
            }
        }
        if (!Files.exists(staticJsDir, new LinkOption[0])) {
            try {
                Files.createDirectories(staticJsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create static js directory: {}", (Object)e.getMessage());
            }
        }
        if (!Files.exists(staticCssDir, new LinkOption[0])) {
            try {
                Files.createDirectories(staticCssDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create static css directory: {}", (Object)e.getMessage());
            }
        }
    }
}

