/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.mixin;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.thecoolcraft11.ScreenshotData;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.event.KeyInputHandler;
import de.thecoolcraft11.screen.EditScreen;
import de.thecoolcraft11.util.ErrorMessages;
import de.thecoolcraft11.util.ReceivePackets;
import de.thecoolcraft11.util.ScreenshotUploadHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_318.class})
@Environment(value=EnvType.CLIENT)
public abstract class ScreenshotMixin {
    @Unique
    private static final Logger logger = LoggerFactory.getLogger(ScreenshotMixin.class);

    @Shadow
    private static File method_1660(File directory) {
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"method_1661"})
    private static void screenshotCaptured(class_1011 nativeImage_1, File file_1, Consumer<class_2561> consumer_1, CallbackInfo ci) {
        if (ConfigManager.getClientConfig().enableMod) {
            class_310 client = class_310.method_1551();
            if (KeyInputHandler.editKey.method_1436()) {
                client.method_18858(() -> client.method_1507((class_437)new EditScreen(null, null, nativeImage_1, image -> {
                    if (image != null) {
                        class_1011 imageCopy = new class_1011(image.method_4307(), image.method_4323(), false);
                        for (int y = 0; y < image.method_4323(); ++y) {
                            for (int x = 0; x < image.method_4307(); ++x) {
                                imageCopy.method_4305(x, y, image.method_4315(x, y));
                            }
                        }
                        ScreenshotMixin.saveEditedFile(file_1.getAbsolutePath(), imageCopy);
                        ScreenshotMixin.initializeUpload(imageCopy);
                    }
                })));
            } else {
                ScreenshotMixin.initializeUpload(nativeImage_1);
            }
        }
    }

    @Unique
    private static void saveEditedFile(String absolutePath, class_1011 imageCopy) {
        StringBuilder template = new StringBuilder(ConfigManager.getClientConfig().editImageFilePath);
        template.replace(template.indexOf("{fileName}"), "{fileName}".length(), absolutePath);
        File outputFile = new File(template.toString());
        try {
            imageCopy.method_4325(outputFile);
            logger.info("Image saved to {}", (Object)outputFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("Failed to save the image to disk", (Throwable)e);
        }
    }

    @Unique
    private static void initializeUpload(class_1011 image) {
        class_310 client = class_310.method_1551();
        boolean sendWorldData = ConfigManager.getClientConfig().sendWorldData;
        boolean sendSystemData = ConfigManager.getClientConfig().sendSystemInfo;
        String username = client.method_1548().method_1676();
        String uuid = String.valueOf(client.method_1548().method_44717());
        String accountType = String.valueOf(client.method_1548().method_35718());
        String worldName = sendWorldData ? ScreenshotMixin.getWorldName(client) : "N/A";
        String seed = sendWorldData ? ScreenshotMixin.getWorldSeed(client) : "N/A";
        String coordinates = sendWorldData ? ScreenshotMixin.getPlayerCoordinates(client) : "N/A";
        String biome = sendWorldData ? ScreenshotMixin.getPlayerBiome(client) : "N/A";
        String facingDirection = sendWorldData ? ScreenshotMixin.getPlayerFacingDirection(client) : "N/A";
        String dimension = sendWorldData ? ScreenshotMixin.getCurrentDimension(client) : "N/A";
        String playerState = sendWorldData ? ScreenshotMixin.getPlayerState(client) : "N/A";
        String chunkInfo = sendWorldData ? ScreenshotMixin.getChunkInfo(client) : "N/A";
        String entitiesInfo = sendWorldData ? ScreenshotMixin.getEntitiesInfo(client) : "N/A";
        String worldInfo = sendWorldData ? ScreenshotMixin.getWorldInfo(client) : "N/A";
        String serverAddress = sendWorldData ? ScreenshotMixin.getServerAddress(client) : "N/A";
        String clientSettings = sendWorldData ? ScreenshotMixin.getClientSettings(client) : "N/A";
        String systemInfo = sendSystemData ? ScreenshotMixin.getSystemInfo() : "N/A";
        String currentTime = "" + System.currentTimeMillis();
        ScreenshotData data = new ScreenshotData(username, uuid, accountType, worldName, seed, coordinates, biome, facingDirection, dimension, playerState, chunkInfo, entitiesInfo, worldInfo, serverAddress, clientSettings, systemInfo, currentTime);
        String jsonData = ScreenshotMixin.serializeToJson(data);
        logger.error("TST: {}", (Object)ConfigManager.getClientConfig().saveJsonData);
        if (ConfigManager.getClientConfig().saveJsonData) {
            logger.error("A");
            String filename = Objects.requireNonNull(ScreenshotMixin.method_1660(Paths.get(client.field_1697.getName(), "screenshots").toFile())).getName();
            File jsonFile = new File(client.field_1697, "screenshots/" + filename.replace(".png", ".json"));
            try {
                boolean wasCreated = jsonFile.createNewFile();
                if (!wasCreated) {
                    logger.info("JSON file already exists: {}", (Object)jsonFile.getAbsolutePath());
                }
                Files.writeString(jsonFile.toPath(), (CharSequence)jsonData, new OpenOption[0]);
            }
            catch (Exception e) {
                logger.error("Failed to save the JSON data to disk", (Throwable)e);
            }
        }
        if (ConfigManager.getClientConfig().requireNoHud && !client.field_1690.field_1842 || ConfigManager.getClientConfig().limitToServer && !Objects.equals(Objects.requireNonNull(client.method_1558()).field_3761, ConfigManager.getClientConfig().limitedServerAddr)) {
            return;
        }
        new Thread(() -> {
            ArrayList<String> targets = new ArrayList<String>();
            if (ConfigManager.getClientConfig().uploadScreenshotsToUrl) {
                for (Map<String, String> value : ConfigManager.getClientConfig().upload_urls.values()) {
                    targets.add(value.get("upload"));
                }
            }
            if (ReceivePackets.serverSiteAddress != null) {
                targets.add(ReceivePackets.serverSiteAddress);
            }
            StringBuilder messageBuilder = ScreenshotMixin.getStringBuilder(targets);
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.uploading_to", (Object[])new Object[]{class_2561.method_43470((String)messageBuilder.toString()).method_27694(style -> style.method_10977(class_124.field_1075))}));
            List<JsonObject> uploadResults = ScreenshotUploadHelper.uploadScreenshot(image, jsonData, targets);
            client.execute(() -> uploadResults.forEach(uploadResult -> {
                String statusMessage = uploadResult.get("status").getAsString();
                if ("success".equals(statusMessage)) {
                    JsonObject responseBody = null;
                    try {
                        responseBody = JsonParser.parseString((String)uploadResult.get("responseBody").getAsString()).getAsJsonObject();
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse responseBody", (Throwable)e);
                    }
                    String baseMessage = "message.screenshot_uploader.upload_success";
                    class_5250 clickableLink = class_2561.method_43473();
                    class_5250 clickableLink2 = class_2561.method_43473();
                    class_5250 clickableLink3 = class_2561.method_43473();
                    class_5250 clickableLink4 = class_2561.method_43473();
                    class_5250 clickableLink5 = class_2561.method_43473();
                    if (responseBody != null) {
                        String galleryUrl;
                        String screenshotUrl = responseBody.has("url") && !responseBody.get("url").isJsonNull() ? responseBody.get("url").getAsString() : null;
                        String string = galleryUrl = responseBody.has("gallery") && !responseBody.get("gallery").isJsonNull() ? responseBody.get("gallery").getAsString() : null;
                        if (screenshotUrl != null && galleryUrl != null) {
                            clickableLink = class_2561.method_43471((String)"message.screenshot_uploader.open_screenshot").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/open-screenshot \"" + screenshotUrl + "\"")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.screenshot_uploader.see_screenshot"))).method_10977(class_124.field_1075));
                        }
                        if (screenshotUrl != null) {
                            clickableLink2 = class_2561.method_43471((String)"message.screenshot_uploader.open_link").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, screenshotUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.screenshot_uploader.open_website"))).method_10977(class_124.field_1078));
                        }
                        if (galleryUrl != null) {
                            clickableLink3 = class_2561.method_43471((String)"message.screenshot_uploader.open_all").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, galleryUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.screenshot_uploader.see_screenshots"))).method_10977(class_124.field_1054));
                        }
                        if (screenshotUrl != null) {
                            clickableLink4 = class_2561.method_43471((String)"message.screenshot_uploader.copy").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, screenshotUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.screenshot_uploader.copy_url"))).method_10977(class_124.field_1080));
                        }
                        if (screenshotUrl != null) {
                            clickableLink5 = class_2561.method_43471((String)"message.screenshot_uploader.share").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, screenshotUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.screenshot_uploader.share_screenshot"))).method_10977(class_124.field_1077));
                        }
                        if (screenshotUrl == null && galleryUrl == null) {
                            baseMessage = "message.screenshot_uploader_no_return_url";
                        }
                        class_5250 finalMessage = class_2561.method_43469((String)baseMessage, (Object[])new Object[]{clickableLink, clickableLink2, clickableLink3, clickableLink4, clickableLink5});
                        client.field_1705.method_1743().method_1812((class_2561)finalMessage);
                    }
                } else {
                    String errorMessage = uploadResult.has("message") ? uploadResult.get("message").getAsString() : "Unknown error";
                    class_5250 errorText = class_2561.method_43469((String)"message.screenshot_uploader.upload_failed", (Object[])new Object[]{errorMessage.split(":")[0]}).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)ErrorMessages.getErrorDescription(errorMessage.split(":")[0])))));
                    client.field_1705.method_1743().method_1812((class_2561)errorText);
                }
            }));
        }).start();
    }

    @Unique
    @NotNull
    private static StringBuilder getStringBuilder(List<String> targets) {
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 0; i < targets.size(); ++i) {
            String target = targets.get(i);
            String targetText = target.equals("mcserver://this") || target.equals("mcserver://chunked") ? "This Server" : target;
            messageBuilder.append(targetText);
            if (i >= targets.size() - 1) continue;
            messageBuilder.append(", ");
        }
        return messageBuilder;
    }

    @Unique
    private static String getWorldName(class_310 client) {
        return client.field_1687 != null ? client.field_1687.method_27983().method_29177().toString() : "Unknown World";
    }

    @Unique
    private static String getWorldSeed(class_310 client) {
        if (client.method_1576() != null) {
            return String.valueOf(client.method_1576().method_30002().method_8412());
        }
        return "Unknown Seed";
    }

    @Unique
    private static String getPlayerCoordinates(class_310 client) {
        if (client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            return String.format("X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        return "Unknown Coordinates";
    }

    @Unique
    private static String getPlayerBiome(class_310 client) {
        if (client.field_1687 != null && client.field_1724 != null) {
            class_6880 biomeEntry = client.field_1687.method_23753(client.field_1724.method_24515());
            String biomeName = biomeEntry.method_55840();
            Object formattedName = biomeName.split(":")[1];
            formattedName = ((String)formattedName).replace("_", " ");
            formattedName = ((String)formattedName).substring(0, 1).toUpperCase() + ((String)formattedName).substring(1);
            return formattedName;
        }
        return "Unknown Biome";
    }

    @Unique
    private static String getPlayerFacingDirection(class_310 client) {
        if (client.field_1724 != null) {
            class_2350 direction = client.field_1724.method_5735();
            return direction.method_15434();
        }
        return "Unknown Direction";
    }

    @Unique
    private static String getCurrentDimension(class_310 client) {
        return client.field_1687 != null ? client.field_1687.method_27983().method_29177().toString() : "Unknown Dimension";
    }

    @Unique
    private static String getPlayerState(class_310 client) {
        if (client.field_1724 != null) {
            return String.format("Speed: %.2f b/s, Health: %.2f, Food: %d, Air: %d", client.field_1724.method_18798().method_1033() * 20.0, Float.valueOf(client.field_1724.method_6032()), client.field_1724.method_7344().method_7586() / 2, client.field_1724.method_5669());
        }
        return "Unknown State";
    }

    @Unique
    private static String getChunkInfo(class_310 client) {
        if (client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            return String.format("Chunk: [%d, %d]", chunkX, chunkZ);
        }
        return "Unknown Chunk Info";
    }

    @Unique
    private static String getEntitiesInfo(class_310 client) {
        if (client.field_1687 != null) {
            Iterable entities = client.field_1687.method_18112();
            int entityCount = 0;
            for (class_1297 ignored : entities) {
                ++entityCount;
            }
            return String.format("Loaded Entities: %d", entityCount);
        }
        return "No Entity Info";
    }

    @Unique
    private static String getWorldInfo(class_310 client) {
        if (client.field_1687 != null) {
            class_638.class_5271 properties = client.field_1687.method_28104();
            return String.format("Time: %s, Weather: %s, Difficulty: %s", ScreenshotMixin.convertMinecraftTimeToHumanReadable(properties.method_217()), client.field_1687.method_8419() ? "Raining" : "Clear", client.field_1687.method_8407().method_5460());
        }
        return "No World Info";
    }

    @Unique
    private static String convertMinecraftTimeToHumanReadable(long ticks) {
        int hours = (int)((ticks / 1000L + 6L) % 24L);
        int minutes = (int)(ticks % 1000L * 60L / 1000L);
        return String.format("%02d:%02d", hours, minutes);
    }

    @Unique
    private static String getServerAddress(class_310 client) {
        String singlePlayerWorldName;
        class_642 serverInfo = client.method_1558();
        String string = singlePlayerWorldName = client.method_1576() != null ? client.method_1576().method_27728().method_150() : "Singleplayer";
        return !client.method_1542() ? (serverInfo != null ? serverInfo.field_3761 : "Unknown Server") : singlePlayerWorldName;
    }

    @Unique
    private static String getClientSettings(class_310 client) {
        return String.format("Graphics: %s, V-Sync: %b, Fullscreen: %b, Language: %s, FPS: %d / %d, Render Distance: %d", client.field_1690.method_42534().method_41753(), client.field_1690.method_42433().method_41753(), client.field_1690.method_42447(), client.method_1526().method_4669(), client.method_47599(), client.field_1690.method_42524().method_41753(), client.field_1690.method_42503().method_41753());
    }

    @Unique
    private static String getSystemInfo() {
        return String.format("OS: %s %s (%s), Java: %s, Version: %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"), ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow()).getMetadata().getVersion().getFriendlyString());
    }

    @Unique
    private static String serializeToJson(ScreenshotData data) {
        Gson gson = new Gson();
        return gson.toJson((Object)data);
    }
}

