/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.screen.ConfigScreen;
import de.thecoolcraft11.screen.EditScreen;
import de.thecoolcraft11.screen.WebGalleryScreen;
import de.thecoolcraft11.util.ReceivePackets;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleryScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(GalleryScreen.class);
    private static final List<class_2960> imageIds = new ArrayList<class_2960>();
    private static final List<Path> imagePaths = new ArrayList<Path>();
    private static final List<JsonObject> metaDatas = new ArrayList<JsonObject>();
    private static final int IMAGES_PER_ROW = ConfigManager.getClientConfig().imagesPerRow;
    private static int IMAGE_WIDTH = 192;
    private static int IMAGE_HEIGHT = 108;
    private static int GAP = ConfigManager.getClientConfig().imageGap;
    private static int TOP_PADDING = ConfigManager.getClientConfig().imageTopPadding;
    private static boolean isImageClicked = false;
    private static int clickedImageIndex = -1;
    private int scrollOffset = 0;
    private double zoomLevel = 2.0;
    private double imageOffsetX = 0.0;
    private double imageOffsetY = 0.0;
    private class_4185 saveButton;
    private class_4185 deleteButton;
    private class_4185 openInAppButton;
    private class_4185 editButton;
    private static class_4185 likeButton;
    private class_4185 sortByButton;
    private class_4185 sortOrderButton;
    private class_4185 configButton;
    private static final String FILE_PATH = "./config/screenshotUploader/data/local.json";
    private static final LinkedHashMap<String, Boolean> likedScreenshots;
    private final List<class_4185> navigatorButtons = new ArrayList<class_4185>();
    private final List<class_4185> buttonsToHideOnOverlap = new ArrayList<class_4185>();
    private SortBy sortBy = SortBy.DEFAULT;
    private SortOrder sortOrder = SortOrder.ASCENDING;
    private CompletableFuture<?> asyncSortFuture;
    private final AtomicInteger sortTaskId = new AtomicInteger();

    public GalleryScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.title"));
    }

    protected void method_25426() {
        super.method_25426();
        imageIds.clear();
        imagePaths.clear();
        this.navigatorButtons.clear();
        metaDatas.clear();
        int scaledHeight = this.field_22790 / 6;
        int scaledWidth = scaledHeight * 16 / 9;
        int scaledGap = scaledHeight / 10;
        TOP_PADDING = this.field_22790 / 20;
        IMAGE_WIDTH = scaledWidth;
        IMAGE_HEIGHT = scaledHeight;
        GAP = scaledGap;
        this.loadAllImagesAsync();
        int buttonWidth = this.field_22789 / 8;
        int buttonHeight = this.field_22790 / 25;
        int buttonSpacing = buttonWidth / 5;
        int xPosition = (this.field_22789 - (buttonWidth * (this.navigatorButtons.size() + 1) + buttonSpacing * (this.navigatorButtons.size() - 1))) / 5;
        int buttonY = (int)((double)this.field_22790 * 0.9);
        int navigatorY = (int)((double)this.field_22790 * 0.01);
        this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"), button -> {}).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
        xPosition += buttonWidth + buttonSpacing;
        if (ReceivePackets.gallerySiteAddress != null) {
            this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.server_gallery"), button -> {
                String webserverUrl = ReceivePackets.gallerySiteAddress;
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                } else {
                    logger.error("Failed to get client trying to open Server Gallery with URL {}", (Object)webserverUrl);
                }
            }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            xPosition += buttonWidth + buttonSpacing;
        }
        for (Map.Entry<String, Map<String, String>> entry : ConfigManager.getClientConfig().upload_urls.entrySet()) {
            String webserverUrl = entry.getValue().get("gallery");
            String buttonLabel = entry.getKey();
            this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonLabel), button -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                } else {
                    logger.error("Failed to get client trying to open Gallery for {}", (Object)webserverUrl);
                }
            }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            xPosition += buttonWidth + buttonSpacing;
        }
        this.navigatorButtons.forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        this.navigatorButtons.stream().filter(buttonWidget -> buttonWidget.method_25369().equals((Object)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"))).forEach(buttonWidget -> {
            buttonWidget.field_22763 = false;
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.save"), button -> this.saveImage()).method_46434(5, buttonY, buttonWidth, buttonHeight).method_46431();
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.delete"), button -> this.deleteImage()).method_46434(buttonWidth + 10, buttonY, buttonWidth, buttonHeight).method_46431();
        this.openInAppButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_app"), button -> this.openImageInApp()).method_46434(2 * buttonWidth + 15, buttonY, buttonWidth, buttonHeight).method_46431();
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.edit"), button -> {
            if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
                Path imagePath = imagePaths.get(clickedImageIndex - 1);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new EditScreen(this, imagePath, null, image -> {}));
                }
            }
        }).method_46434(3 * buttonWidth + 20, buttonY, buttonWidth, buttonHeight).method_46431();
        likeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.like_screenshot").method_54663(0x2A2A2A), button -> GalleryScreen.likeScreenshot()).method_46434(buttonWidth * 4 + 25, buttonY, 20, 20).method_46431();
        this.configButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.config"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ConfigScreen());
            }
        }).method_46434(5, 5, buttonWidth / 2, buttonHeight).method_46431();
        this.sortByButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.sortBy.toString()), button -> {
            this.sortBy = SortBy.values()[(this.sortBy.ordinal() + 1) % SortBy.values().length];
            this.sortByButton.method_25355(class_2561.method_30163((String)this.sortBy.toString()));
            this.loadImageSorted(this.sortOrder, this.sortBy);
        }).method_46434(5, this.field_22790 - buttonHeight - 5, buttonWidth, buttonHeight).method_46431();
        this.sortOrderButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.sortOrder.toString()), button -> {
            this.sortOrder = SortOrder.values()[(this.sortOrder.ordinal() + 1) % SortOrder.values().length];
            this.sortOrderButton.method_25355(class_2561.method_30163((String)this.sortOrder.toString()));
            this.loadImageSorted(this.sortOrder, this.sortBy);
        }).method_46434(5 + buttonWidth + 5, this.field_22790 - buttonHeight - 5, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.deleteButton);
        this.method_37063((class_364)this.openInAppButton);
        this.method_37063((class_364)this.configButton);
        this.method_37063((class_364)this.editButton);
        this.method_37063((class_364)likeButton);
        this.method_37063((class_364)this.sortByButton);
        this.method_37063((class_364)this.sortOrderButton);
        this.saveButton.field_22764 = false;
        this.deleteButton.field_22764 = false;
        this.openInAppButton.field_22764 = false;
        this.editButton.field_22764 = false;
        this.configButton.field_22764 = true;
        GalleryScreen.likeButton.field_22764 = true;
        this.buttonsToHideOnOverlap.add(this.saveButton);
        this.buttonsToHideOnOverlap.add(this.deleteButton);
        this.buttonsToHideOnOverlap.add(this.openInAppButton);
        this.buttonsToHideOnOverlap.add(this.editButton);
        this.buttonsToHideOnOverlap.add(likeButton);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (isImageClicked) {
                int imageWidth = (int)(1920.0 * this.zoomLevel);
                int imageHeight = (int)(1080.0 * this.zoomLevel);
                if (this.field_22787 != null) {
                    imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
                    imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
                }
                int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
                int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
                if (mouseX >= (double)x && mouseX <= (double)(x + imageWidth) && mouseY >= (double)y && mouseY <= (double)(y + imageHeight)) {
                    return false;
                }
                for (class_364 buttonWidget : this.method_25396()) {
                    if (buttonWidget == null || !buttonWidget.method_25405(mouseX, mouseY)) continue;
                    return super.method_25402(mouseX, mouseY, button);
                }
                isImageClicked = false;
                clickedImageIndex = -1;
                return true;
            }
            int totalImages = imageIds.size();
            for (int i = 0; i < totalImages; ++i) {
                int row = i / IMAGES_PER_ROW;
                int col = i % IMAGES_PER_ROW;
                int x = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2 + col * (IMAGE_WIDTH + GAP);
                int y = TOP_PADDING + 20 + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + IMAGE_WIDTH)) || !(mouseY > (double)y) || !(mouseY < (double)(y + IMAGE_HEIGHT))) continue;
                isImageClicked = true;
                clickedImageIndex = i;
                this.zoomLevel = 1.0;
                this.imageOffsetX = 0.0;
                this.imageOffsetY = 0.0;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (isImageClicked && clickedImageIndex >= 0) {
            double mouseXRelative = mouseX - (double)this.field_22789 / 2.0;
            double mouseYRelative = mouseY - (double)this.field_22790 / 2.0;
            double imageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double imageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            double mouseXInImage = -(mouseXRelative - this.imageOffsetX);
            double mouseYInImage = -(mouseYRelative - this.imageOffsetY);
            this.zoomLevel = Math.min(Math.max(this.zoomLevel + (verticalAmount > 0.0 ? 0.1 : -0.1), 0.5), 10.0);
            double newImageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double newImageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            this.imageOffsetX += mouseXInImage * (newImageWidth / imageWidth - 1.0);
            this.imageOffsetY += mouseYInImage * (newImageHeight / imageHeight - 1.0);
            return true;
        }
        if (verticalAmount < 0.0) {
            this.scrollOffset += GAP + IMAGE_HEIGHT;
        } else if (verticalAmount > 0.0) {
            this.scrollOffset -= GAP + IMAGE_HEIGHT;
        }
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, (imageIds.size() / IMAGES_PER_ROW + 2) * (IMAGE_HEIGHT + GAP) - this.field_22790 + TOP_PADDING));
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (isImageClicked && clickedImageIndex >= 0) {
            this.renderEnlargedImage(context);
            this.saveButton.field_22764 = true;
            this.deleteButton.field_22764 = true;
            this.openInAppButton.field_22764 = true;
            this.editButton.field_22764 = true;
            this.configButton.field_22764 = false;
            GalleryScreen.likeButton.field_22764 = false;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = false;
            });
        } else {
            this.renderGallery(context, mouseX, mouseY);
            this.saveButton.field_22764 = false;
            this.deleteButton.field_22764 = false;
            this.openInAppButton.field_22764 = false;
            this.editButton.field_22764 = false;
            this.configButton.field_22764 = true;
            GalleryScreen.likeButton.field_22764 = true;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = true;
            });
        }
        boolean isImageOverlappingButtons = clickedImageIndex >= 0 && this.isImageOverlappingButtons();
        for (class_364 button : this.method_25396()) {
            if (!(button instanceof class_4185) || !this.buttonsToHideOnOverlap.contains(button)) continue;
            if (isImageClicked) {
                ((class_4185)button).field_22764 = !isImageOverlappingButtons;
                continue;
            }
            ((class_4185)button).field_22764 = false;
        }
    }

    private void renderGallery(class_332 context, int mouseX, int mouseY) {
        int startX = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2;
        int startY = TOP_PADDING + 20;
        if (imageIds.isEmpty()) {
            return;
        }
        for (int i = 0; i < imageIds.size() && imagePaths.size() > i; ++i) {
            int row = i / IMAGES_PER_ROW;
            int col = i % IMAGES_PER_ROW;
            int x = startX + col * (IMAGE_WIDTH + GAP);
            int y = startY + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
            context.method_25294(x - 2, y - 2, x + IMAGE_WIDTH + 2, y + IMAGE_HEIGHT + 2, -7829368);
            class_2960 imageId = null;
            if (imageIds.size() > i) {
                imageId = imageIds.get(i);
            }
            if (imageId == null) {
                logger.error("Image ID is null for index {}", (Object)i);
                continue;
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)imageId);
            context.method_25290(imageId, x, y, 0.0f, 0.0f, IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_WIDTH, IMAGE_HEIGHT);
            if (mouseX > x && mouseX < x + IMAGE_WIDTH && mouseY > y && mouseY < y + IMAGE_HEIGHT) {
                context.method_25294(x, y, x + IMAGE_WIDTH, y + IMAGE_HEIGHT, -2130706433);
            }
            if (this.field_22787 == null || !likedScreenshots.containsKey(imagePaths.get(i).toString()) || !likedScreenshots.get(imagePaths.get(i).toString()).booleanValue()) continue;
            context.method_51433(this.field_22787.field_1772, "\u2764", x + 5, y + IMAGE_HEIGHT - 10, 0xFFFFFF, false);
        }
    }

    private void renderEnlargedImage(class_332 context) {
        if (clickedImageIndex < 0 || clickedImageIndex >= imageIds.size()) {
            return;
        }
        class_2960 clickedImageId = imageIds.get(clickedImageIndex);
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        } else {
            logger.info("Failed to get client while trying to get screen resolution while rendering large image, proceeding with 1920x1080");
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int borderWidth = 5;
        context.method_25294(x - borderWidth, y - borderWidth, x + imageWidth + borderWidth, y + imageHeight + borderWidth, -1);
        RenderSystem.setShaderTexture((int)0, (class_2960)clickedImageId);
        RenderSystem.enableBlend();
        context.method_25290(clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        RenderSystem.disableBlend();
        int sidebarWidth = 300;
        int sidebarHeight = imageHeight;
        int sidebarXLeft = x - sidebarWidth;
        context.method_25294(sidebarXLeft, y, sidebarXLeft + sidebarWidth, y + sidebarHeight, -872415232);
        if (clickedImageIndex >= 0 && clickedImageIndex < metaDatas.size()) {
            LinkedHashMap<class_2561, class_2561> drawableInfo = this.getStringStringMap();
            int textXLeft = sidebarXLeft + 10;
            int textYLeft = y + 20;
            for (class_2561 info : drawableInfo.keySet()) {
                context.method_51439(this.field_22787.field_1772, (class_2561)info.method_27661().method_10852((class_2561)drawableInfo.get(info)), textXLeft, textYLeft, 0xFFFFFF, false);
                textYLeft += 10;
            }
        }
        likeButton.method_25355((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.like_screenshot").method_54663(likedScreenshots.containsKey(imagePaths.get(clickedImageIndex).toString()) && likedScreenshots.get(imagePaths.get(clickedImageIndex).toString()) != false ? 0xFFFFFF : 0x2A2A2A));
    }

    private void loadAllImagesAsync() {
        Path screenshotsDir = Paths.get(System.getProperty("user.dir"), "screenshots");
        CompletableFuture.runAsync(() -> {
            try (Stream<Path> paths = Files.list(screenshotsDir);){
                Set<String> likedScreenshotsSet = GalleryScreen.loadLikedScreenshots();
                List<Path> sortedPaths = paths.filter(path -> path.toString().endsWith(".png")).sorted(Comparator.comparing(path -> likedScreenshotsSet.contains(path.toString()) ? 0 : 1).thenComparing(path -> path.toFile().lastModified(), Comparator.reverseOrder())).toList();
                imagePaths.clear();
                imagePaths.addAll(sortedPaths);
                this.loadImagesAsync();
            }
            catch (IOException e) {
                logger.error("Failed to load images: {}", (Object)e.getMessage());
            }
        });
    }

    private void loadImagesAsync() {
        int currentTaskId = this.sortTaskId.incrementAndGet();
        this.asyncSortFuture = CompletableFuture.runAsync(() -> {
            Set<String> likedScreenshotsSet = GalleryScreen.loadLikedScreenshots();
            if (this.sortTaskId.get() != currentTaskId) {
                return;
            }
            for (Path path : imagePaths) {
                if (this.sortTaskId.get() != currentTaskId) {
                    return;
                }
                try {
                    class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(path, new OpenOption[0]));
                    class_2960 textureId = class_2960.method_60655((String)"gallery", (String)("textures/" + path.getFileName().toString()));
                    class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(image));
                    imageIds.add(textureId);
                    String imagePathString = path.toString();
                    if (likedScreenshotsSet.contains(imagePathString)) {
                        likedScreenshots.put(imagePathString, true);
                    }
                    JsonObject metaData = new JsonObject();
                    File jsonData = new File(path.getParent().toString(), path.getFileName().toString().replace(".png", ".json"));
                    if (jsonData.exists()) {
                        try (FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);){
                            metaData = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        }
                        catch (JsonSyntaxException e) {
                            logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
                        }
                        catch (IOException e) {
                            logger.error("Error reading the JSON file.", (Throwable)e);
                        }
                    }
                    metaData.addProperty("screenshotUrl", imagePathString);
                    metaData.addProperty("liked", Boolean.valueOf(likedScreenshotsSet.contains(imagePathString)));
                    metaData.addProperty("screenshotDate", new Date(jsonData.lastModified()).toString());
                    metaDatas.add(metaData);
                }
                catch (IOException e) {
                    logger.error("Failed to load image '{}': {}", (Object)path, (Object)e.getMessage());
                }
            }
        });
    }

    private static Set<String> loadLikedScreenshots() {
        HashSet<String> likedScreenshots = new HashSet<String>();
        File file = new File(FILE_PATH);
        if (file.exists() && file.length() > 0L) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject obj = element.getAsJsonObject();
                    if (!obj.has("screenshotUrl")) continue;
                    likedScreenshots.add(obj.get("screenshotUrl").getAsString());
                }
            }
            catch (JsonSyntaxException e) {
                logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error reading the like file.", (Throwable)e);
            }
        }
        return likedScreenshots;
    }

    private void saveImage() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(clickedImageIndex);
            Path savePath = Paths.get(System.getProperty("user.home"), "Desktop", "Saved_" + imagePath.getFileName().toString());
            try {
                Files.copy(imagePath, savePath, new CopyOption[0]);
                logger.info("Image saved to: {}", (Object)savePath);
            }
            catch (IOException e) {
                logger.error("Failed to save image: {}", (Object)e.getMessage());
            }
        }
    }

    private void deleteImage() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(clickedImageIndex);
            try {
                Files.delete(imagePath);
                imagePaths.remove(clickedImageIndex);
                imageIds.remove(clickedImageIndex);
                logger.info("Image deleted: {}", (Object)imagePath);
                clickedImageIndex = -1;
                isImageClicked = false;
            }
            catch (IOException e) {
                logger.error("Failed to delete image: {}", (Object)e.getMessage());
            }
        }
    }

    private void openImageInApp() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(clickedImageIndex);
            try {
                ProcessBuilder processBuilder;
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("win")) {
                    processBuilder = new ProcessBuilder("explorer", imagePath.toAbsolutePath().toString());
                } else if (os.contains("mac")) {
                    processBuilder = new ProcessBuilder("open", imagePath.toAbsolutePath().toString());
                } else if (os.contains("nix") || os.contains("nux")) {
                    processBuilder = new ProcessBuilder("xdg-open", imagePath.toAbsolutePath().toString());
                } else {
                    logger.error("Unsupported operating system for opening the image.");
                    return;
                }
                processBuilder.start();
            }
            catch (IOException e) {
                logger.error("Failed to open image with external application: {}", (Object)e.getMessage());
            }
        }
    }

    private boolean isImageOverlappingButtons() {
        if (!isImageClicked || clickedImageIndex < 0) {
            return false;
        }
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        for (class_364 button : this.method_25396()) {
            if (!this.isButtonCoveredByImage((class_4185)button, x, y, imageWidth, imageHeight)) continue;
            return true;
        }
        return false;
    }

    private boolean isButtonCoveredByImage(class_4185 button, int imageX, int imageY, int imageWidth, int imageHeight) {
        int buttonX = button.method_46426();
        int buttonY = button.method_46427();
        int buttonWidth = button.method_25368();
        int buttonHeight = button.method_25364();
        return buttonX + buttonWidth >= imageX && buttonX <= imageX + imageWidth && buttonY + buttonHeight >= imageY && buttonY <= imageY + imageHeight;
    }

    private static void likeScreenshot() {
        boolean dirsCreated;
        if (imageIds.isEmpty() || clickedImageIndex < 0 || clickedImageIndex >= imageIds.size()) {
            System.err.println("Invalid image index or list is empty.");
            return;
        }
        String screenshotId = String.valueOf(imageIds.get(clickedImageIndex));
        String screenshotUrl = String.valueOf(imagePaths.get(clickedImageIndex));
        File file = new File(FILE_PATH);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists() && (dirsCreated = parentDir.mkdirs())) {
            logger.info("Created missing directories: {}", (Object)parentDir.getAbsolutePath());
        }
        JsonArray jsonArray = new JsonArray();
        if (file.exists() && file.length() > 0L) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            }
            catch (JsonSyntaxException e) {
                logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
                jsonArray = new JsonArray();
            }
            catch (IOException e) {
                logger.error("Error reading the like file.", (Throwable)e);
                return;
            }
        }
        boolean screenshotAlreadyLiked = false;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject existingLike = jsonArray.get(i).getAsJsonObject();
            if (!existingLike.has("screenshotId") || !existingLike.get("screenshotId").getAsString().equals(screenshotId)) continue;
            jsonArray.remove(i);
            screenshotAlreadyLiked = true;
            break;
        }
        if (!screenshotAlreadyLiked) {
            JsonObject newLike = new JsonObject();
            newLike.addProperty("screenshotId", screenshotId);
            newLike.addProperty("screenshotUrl", screenshotUrl);
            jsonArray.add((JsonElement)newLike);
        }
        try (FileWriter writer = new FileWriter(FILE_PATH, StandardCharsets.UTF_8);){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonArray));
        }
        catch (IOException e) {
            logger.error("Error while saving likes.", (Throwable)e);
        }
        isImageClicked = false;
        clickedImageIndex = -1;
    }

    private void loadImageSorted(SortOrder sortOrder, SortBy sortBy) {
        int currentTaskId = this.sortTaskId.incrementAndGet();
        this.sortByButton.field_22763 = false;
        this.sortOrderButton.field_22763 = false;
        if (this.asyncSortFuture != null && !this.asyncSortFuture.isDone()) {
            this.asyncSortFuture.cancel(true);
        }
        Path screenshotsDir = Paths.get(System.getProperty("user.dir"), "screenshots");
        this.asyncSortFuture = CompletableFuture.runAsync(() -> {
            try {
                List<Path> sortedPaths;
                Set<String> likedScreenshotsSet = GalleryScreen.loadLikedScreenshots();
                try (Stream<Path> paths = Files.list(screenshotsDir);){
                    sortedPaths = paths.filter(path -> path.toString().endsWith(".png")).sorted((path1, path2) -> {
                        if (sortBy == SortBy.DEFAULT) {
                            if (likedScreenshotsSet.contains(path1.toString()) && !likedScreenshotsSet.contains(path2.toString())) {
                                return -1;
                            }
                            if (!likedScreenshotsSet.contains(path1.toString()) && likedScreenshotsSet.contains(path2.toString())) {
                                return 1;
                            }
                            return Long.compare(path2.toFile().lastModified(), path1.toFile().lastModified());
                        }
                        int result = switch (sortBy.ordinal()) {
                            case 0 -> path1.getFileName().toString().compareTo(path2.getFileName().toString());
                            case 1 -> Long.compare(path2.toFile().lastModified(), path1.toFile().lastModified());
                            case 2 -> Long.compare(path1.toFile().length(), path2.toFile().length());
                            default -> 0;
                        };
                        return sortOrder == SortOrder.ASCENDING ? result : -result;
                    }).toList();
                }
                if (this.sortTaskId.get() != currentTaskId) {
                    return;
                }
                class_310.method_1551().execute(() -> {
                    imageIds.clear();
                    imagePaths.clear();
                    metaDatas.clear();
                    imagePaths.addAll(sortedPaths);
                    this.sortByButton.field_22763 = true;
                    this.sortOrderButton.field_22763 = true;
                });
                for (Path path3 : sortedPaths) {
                    if (this.sortTaskId.get() != currentTaskId) {
                        return;
                    }
                    JsonObject metaData = new JsonObject();
                    File jsonData = new File(path3.getParent().toString(), path3.getFileName().toString().replace(".png", ".json"));
                    if (jsonData.exists()) {
                        try (FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);){
                            metaData = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        }
                        catch (JsonSyntaxException e) {
                            logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
                        }
                        catch (IOException e) {
                            logger.error("Error reading the JSON file.", (Throwable)e);
                        }
                    }
                    metaData.addProperty("screenshotUrl", path3.toString());
                    metaData.addProperty("liked", Boolean.valueOf(likedScreenshotsSet.contains(path3.toString())));
                    metaData.addProperty("screenshotDate", new Date(jsonData.lastModified()).toString());
                    class_2960 textureId = null;
                    try {
                        class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(path3, new OpenOption[0]));
                        textureId = class_2960.method_60655((String)"gallery", (String)("textures/" + path3.getFileName().toString()));
                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(image));
                    }
                    catch (IOException e) {
                        logger.error("Failed to load image during sort '{}': {}", (Object)path3, (Object)e.getMessage());
                    }
                    JsonObject finalMetaData = metaData;
                    class_2960 finalTextureId = textureId;
                    class_310.method_1551().execute(() -> {
                        metaDatas.add(finalMetaData);
                        imageIds.add(finalTextureId);
                    });
                }
            }
            catch (IOException e) {
                logger.error("Failed to sort images: {}", (Object)e.getMessage());
            }
        });
    }

    @NotNull
    private LinkedHashMap<class_2561, class_2561> getStringStringMap() {
        JsonObject metaData = metaDatas.get(clickedImageIndex);
        LinkedHashMap<class_2561, class_2561> drawableInfo = new LinkedHashMap<class_2561, class_2561>();
        if (metaData.has("username")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"Username: "), (class_2561)(metaData.has("username") && metaData.get("username").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("username").getAsString()) : (metaData.has("fileUsername") && metaData.get("fileUsername").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("fileUsername").getAsString()) : class_2561.method_43470((String)"N/A"))));
        }
        if (metaData.has("server_address")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"Server: "), (class_2561)(metaData.has("server_address") && metaData.get("server_address").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("server_address").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_name")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"World: "), (class_2561)(metaData.has("world_name") && metaData.get("world_name").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_name").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("coordinates")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"Location: "), (class_2561)(metaData.has("coordinates") && metaData.get("coordinates").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("coordinates").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("facing_direction")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"Facing: "), (class_2561)(metaData.has("facing_direction") && metaData.get("facing_direction").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("facing_direction").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("player_state")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"Player: "), (class_2561)(metaData.has("player_state") && metaData.get("player_state").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("player_state").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("biome")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"Biome: "), (class_2561)(metaData.has("biome") && metaData.get("biome").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("biome").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_info")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"World Info: "), (class_2561)(metaData.has("world_info") && metaData.get("world_info").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_info").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_seed")) {
            drawableInfo.put((class_2561)class_2561.method_43470((String)"Seed: "), (class_2561)(metaData.has("world_seed") && metaData.get("world_seed").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_seed").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        drawableInfo.put((class_2561)class_2561.method_43470((String)" "), (class_2561)class_2561.method_43470((String)" "));
        if (metaData.has("current_time")) {
            drawableInfo.put((class_2561)(metaData.has("current_time") ? GalleryScreen.getTimestamp(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? GalleryScreen.getTimestamp(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        }
        if (metaData.has("current_time")) {
            drawableInfo.put((class_2561)(metaData.has("current_time") ? GalleryScreen.getTimeAgo(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? GalleryScreen.getTimeAgo(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        }
        return drawableInfo;
    }

    public static class_2561 getTimestamp(long millis) {
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        LocalDateTime timestampDateTime = LocalDateTime.ofInstant(timestampInstant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        return class_2561.method_43470((String)timestampDateTime.format(formatter)).method_27694(style -> style.method_30938(Boolean.valueOf(true)));
    }

    private static class_2561 getTimeAgo(long millis) {
        Instant nowInstant;
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        Duration duration = Duration.between(timestampInstant, nowInstant = Instant.now());
        long seconds = duration.getSeconds();
        if (seconds < 60L) {
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.seconds_ago", (Object[])new Object[]{seconds}).method_27693(")"));
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.minutes_ago", (Object[])new Object[]{minutes}).method_27693(")"));
        }
        if (seconds < 86400L) {
            long hours = seconds / 3600L;
            long minutes = seconds % 3600L / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.hours_ago", (Object[])new Object[]{hours, minutes}).method_27693(")"));
        }
        long days = seconds / 86400L;
        return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.days_ago", (Object[])new Object[]{days}).method_27693(")"));
    }

    public void method_25410(class_310 client, int width, int height) {
        client.method_1507(null);
        super.method_25410(client, width, height);
    }

    public void method_25419() {
        if (isImageClicked) {
            isImageClicked = false;
            clickedImageIndex = -1;
        } else {
            super.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }

    static {
        likedScreenshots = new LinkedHashMap();
    }

    private static enum SortBy {
        NAME,
        DATE,
        SIZE,
        DEFAULT;

    }

    private static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

