/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.mixin;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.thecoolcraft11.ScreenshotData;
import de.thecoolcraft11.ScreenshotUploader;
import de.thecoolcraft11.util.ScreenshotUpload;
import java.io.File;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_318.class})
public class ScreenshotMixin {
    @Unique
    private static final Logger logger = LoggerFactory.getLogger(ScreenshotMixin.class);
    @Unique
    private static final JsonObject config = ScreenshotUploader.getConfig();

    @Inject(at={@At(value="HEAD")}, method={"method_1661"})
    private static void screenshotCaptured(class_1011 nativeImage_1, File file_1, Consumer<class_2561> consumer_1, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (config.get("requireNoHud").getAsBoolean() && !client.field_1690.field_1842 || config.get("limitToServer").getAsBoolean() && !Objects.equals(Objects.requireNonNull(client.method_1558()).field_3761, config.get("limitedServerAddr").getAsString())) {
            return;
        }
        String username = client.method_1548().method_1676();
        String uuid = String.valueOf(client.method_1548().method_44717());
        String accountType = String.valueOf(client.method_1548().method_35718());
        String worldName = ScreenshotMixin.getWorldName(client);
        String coordinates = ScreenshotMixin.getPlayerCoordinates(client);
        String biome = ScreenshotMixin.getPlayerBiome(client);
        String facingDirection = ScreenshotMixin.getPlayerFacingDirection(client);
        String dimension = ScreenshotMixin.getCurrentDimension(client);
        String playerState = ScreenshotMixin.getPlayerState(client);
        String chunkInfo = ScreenshotMixin.getChunkInfo(client);
        String entitiesInfo = ScreenshotMixin.getEntitiesInfo(client);
        String worldInfo = ScreenshotMixin.getWorldInfo(client);
        String serverAddress = ScreenshotMixin.getServerAddress(client);
        String clientSettings = ScreenshotMixin.getClientSettings(client);
        String systemInfo = ScreenshotMixin.getSystemInfo();
        ScreenshotData data = new ScreenshotData(username, uuid, accountType, worldName, coordinates, biome, facingDirection, dimension, playerState, chunkInfo, entitiesInfo, worldInfo, serverAddress, clientSettings, systemInfo);
        String jsonData = ScreenshotMixin.serializeToJson(data);
        new Thread(() -> {
            JsonObject uploadResult = ScreenshotUpload.uploadScreenshot(nativeImage_1, jsonData);
            client.execute(() -> {
                String statusMessage = uploadResult.get("status").getAsString();
                if ("success".equals(statusMessage)) {
                    JsonObject responseBody = null;
                    try {
                        responseBody = JsonParser.parseString((String)uploadResult.get("responseBody").getAsString()).getAsJsonObject();
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse responseBody", (Throwable)e);
                    }
                    if (responseBody != null) {
                        String screenshotUrl = responseBody.has("url") && !responseBody.get("url").isJsonNull() ? responseBody.get("url").getAsString() : null;
                        String galleryUrl = responseBody.has("gallery") && !responseBody.get("gallery").isJsonNull() ? responseBody.get("gallery").getAsString() : null;
                        class_5250 fullMessage = class_2561.method_43470((String)"Screenshot uploaded successfully! ");
                        if (screenshotUrl != null) {
                            String linkText = "[OPEN]";
                            class_5250 clickableLink = class_2561.method_43470((String)linkText).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, screenshotUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click To See Screenshot"))).method_10977(class_124.field_1075));
                            fullMessage = fullMessage.method_27661().method_10852((class_2561)clickableLink);
                        }
                        if (galleryUrl != null) {
                            String galleryText = "[ALL]";
                            class_5250 clickableLink2 = class_2561.method_43470((String)galleryText).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, galleryUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click To See All Screenshots"))).method_10977(class_124.field_1054));
                            fullMessage = fullMessage.method_27661().method_27693(" ").method_10852((class_2561)clickableLink2);
                        }
                        if (screenshotUrl == null && galleryUrl == null) {
                            fullMessage = class_2561.method_43470((String)"Screenshot upload failed: The server did not return valid URLs.");
                        }
                        client.field_1705.method_1743().method_1812((class_2561)fullMessage);
                    }
                } else {
                    String errorMessage = uploadResult.has("message") ? uploadResult.get("message").getAsString() : "Unknown error";
                    class_5250 errorText = class_2561.method_43470((String)("Screenshot upload failed: " + errorMessage));
                    client.field_1705.method_1743().method_1812((class_2561)errorText);
                }
            });
        }).start();
    }

    @Unique
    private static String getWorldName(class_310 client) {
        return client.field_1687 != null ? client.field_1687.method_27983().method_29177().toString() : "Unknown World";
    }

    @Unique
    private static String getPlayerCoordinates(class_310 client) {
        if (client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            return String.format("X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        return "Unknown Coordinates";
    }

    @Unique
    private static String getPlayerBiome(class_310 client) {
        if (client.field_1687 != null && client.field_1724 != null) {
            class_6880 biomeEntry = client.field_1687.method_23753(client.field_1724.method_24515());
            String biomeName = biomeEntry.method_55840();
            Object formattedName = biomeName.split(":")[1];
            formattedName = ((String)formattedName).replace("_", " ");
            formattedName = ((String)formattedName).substring(0, 1).toUpperCase() + ((String)formattedName).substring(1);
            return formattedName;
        }
        return "Unknown Biome";
    }

    @Unique
    private static String getPlayerFacingDirection(class_310 client) {
        if (client.field_1724 != null) {
            class_2350 direction = client.field_1724.method_5735();
            return direction.method_15434();
        }
        return "Unknown Direction";
    }

    @Unique
    private static String getCurrentDimension(class_310 client) {
        return client.field_1687 != null ? client.field_1687.method_27983().method_29177().toString() : "Unknown Dimension";
    }

    @Unique
    private static String getPlayerState(class_310 client) {
        if (client.field_1724 != null) {
            return String.format("Flying: %b, Sneaking: %b, Gliding: %b", client.field_1724.method_31549().field_7479, client.field_1724.method_5715(), client.field_1724.method_6128());
        }
        return "Unknown State";
    }

    @Unique
    private static String getChunkInfo(class_310 client) {
        if (client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            return String.format("Chunk: [%d, %d]", chunkX, chunkZ);
        }
        return "Unknown Chunk Info";
    }

    @Unique
    private static String getEntitiesInfo(class_310 client) {
        if (client.field_1687 != null) {
            Iterable entities = client.field_1687.method_18112();
            int entityCount = 0;
            for (class_1297 ignored : entities) {
                ++entityCount;
            }
            return String.format("Loaded Entities: %d", entityCount);
        }
        return "No Entity Info";
    }

    @Unique
    private static String getWorldInfo(class_310 client) {
        if (client.field_1687 != null) {
            class_638.class_5271 properties = client.field_1687.method_28104();
            return String.format("Time: %d, Weather: %s, Difficulty: %s", properties.method_188(), client.field_1687.method_8419() ? "Raining" : "Clear", client.field_1687.method_8407().method_5460());
        }
        return "No World Info";
    }

    @Unique
    private static String getServerAddress(class_310 client) {
        class_642 serverInfo = client.method_1558();
        return serverInfo != null ? serverInfo.field_3761 : "Singleplayer or Unknown Server";
    }

    @Unique
    private static String getClientSettings(class_310 client) {
        return String.format("Graphics: %s, V-Sync: %b, Fullscreen: %b, Language: %s", client.field_1690.method_42534().method_41753(), client.field_1690.method_42433().method_41753(), client.field_1690.method_42447(), client.method_1526().method_4669());
    }

    @Unique
    private static String getSystemInfo() {
        return String.format("OS: %s %s (%s), Java: %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"));
    }

    @Unique
    private static String serializeToJson(ScreenshotData data) {
        Gson gson = new Gson();
        return gson.toJson((Object)data);
    }
}

