/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.thecoolcraft11.config.AlbumManager;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.event.KeyInputHandler;
import de.thecoolcraft11.packet.AddressPayload;
import de.thecoolcraft11.packet.ScreenshotResponsePayload;
import de.thecoolcraft11.screen.CustomSignEditScreen;
import de.thecoolcraft11.screen.ScreenshotScreen;
import de.thecoolcraft11.screen.WebGalleryScreen;
import de.thecoolcraft11.util.ReceivePackets;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2478;
import net.minecraft.class_2556;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import net.minecraft.class_7471;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotUploaderClient
implements ClientModInitializer {
    private final Logger logger = LoggerFactory.getLogger(ScreenshotUploaderClient.class);

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(AddressPayload.ID, this::registerAddressReceiver);
        ClientPlayNetworking.registerGlobalReceiver(ScreenshotResponsePayload.ID, this::registerScreenshotReceiver);
        ClientPlayConnectionEvents.DISCONNECT.register(this::registerDisconnectEvent);
        ClientPlayConnectionEvents.JOIN.register(this::registerJoinEvent);
        this.createConfig();
        KeyInputHandler.register();
        ClientReceiveMessageEvents.CHAT.register(this::registerChatEvent);
        ClientCommandRegistrationCallback.EVENT.register(this::registerCommands);
        UseBlockCallback.EVENT.register(ScreenshotUploaderClient::signBlockClick);
        this.deleteOldScreenshots();
        AlbumManager.loadAlbums();
    }

    private void createConfig() {
        File configDir = new File("config");
        File screenshotUploaderDir = new File(configDir, "screenshotUploader");
        if (!configDir.exists() && configDir.mkdir()) {
            this.logger.info("Created Config Dir");
        }
        if (!screenshotUploaderDir.exists() && screenshotUploaderDir.mkdir()) {
            this.logger.info("Created Screenshot Uploader Dir");
        }
        ConfigManager.initialize(screenshotUploaderDir, true);
    }

    private void registerScreenshotReceiver(ScreenshotResponsePayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> ReceivePackets.receiveScreenshotRes(JsonParser.parseString((String)payload.json()).getAsJsonObject(), context.client()));
    }

    private void registerAddressReceiver(AddressPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> ReceivePackets.receiveAddress(context.client(), payload.message()));
    }

    private void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"open-gallery").then(ClientCommandManager.argument((String)"server", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"image", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String value = StringArgumentType.getString((CommandContext)context, (String)"server");
            String value2 = StringArgumentType.getString((CommandContext)context, (String)"image");
            class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
            client.method_63588(() -> client.method_1507((class_437)new WebGalleryScreen(null, value, value2)));
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"open-screenshot").then(ClientCommandManager.argument((String)"image", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String value = StringArgumentType.getString((CommandContext)context, (String)"image");
            class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
            client.method_63588(() -> client.method_1507((class_437)new ScreenshotScreen(value)));
            return 1;
        })));
    }

    private void registerChatEvent(class_2561 message, @Nullable class_7471 signedMessage, @Nullable GameProfile gameProfile, class_2556.class_7602 parameters, Instant instant) {
        class_310 client = class_310.method_1551();
        boolean hasServerSaved = false;
        String serverName = "";
        if (ScreenshotUploaderClient.extractUrl(message.getString()) != null) {
            try {
                if (ReceivePackets.homeSiteAddress != null) {
                    URI savedEntry = new URI(ReceivePackets.homeSiteAddress);
                    URI uRI = new URI(Objects.requireNonNull(ScreenshotUploaderClient.extractUrl(message.getString())));
                    if (savedEntry.getHost() == null || uRI.getHost() == null) {
                        return;
                    }
                    if (savedEntry.getHost().equals(uRI.getHost())) {
                        serverName = ReceivePackets.gallerySiteAddress;
                        hasServerSaved = true;
                    }
                }
            }
            catch (URISyntaxException savedEntry) {
                // empty catch block
            }
            if (!hasServerSaved) {
                for (Map map : ConfigManager.getClientConfig().upload_urls.values()) {
                    if (!map.containsKey("home")) continue;
                    try {
                        URI savedEntry = new URI((String)map.get("home"));
                        URI messageEntry = new URI(Objects.requireNonNull(ScreenshotUploaderClient.extractUrl(message.getString())));
                        if (!savedEntry.getHost().equals(messageEntry.getHost())) continue;
                        serverName = (String)map.get("gallery");
                        hasServerSaved = true;
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
            if (hasServerSaved) {
                String finalServerName = serverName;
                class_5250 class_52502 = class_2561.method_43471((String)"message.screenshot_uploader.shared_saved").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/open-gallery \"" + finalServerName + "\" \"" + ScreenshotUploaderClient.extractUrl(message.getString()) + "\"")).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1075));
                client.field_1705.method_1743().method_1812((class_2561)class_52502);
            } else {
                class_5250 newMessage = class_2561.method_43471((String)"message.screenshot_uploader.shared").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/open-screenshot \"" + ScreenshotUploaderClient.extractUrl(message.getString()) + "\"")).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1075));
                client.field_1705.method_1743().method_1812((class_2561)newMessage);
            }
        }
    }

    private void registerDisconnectEvent(class_634 playNetworkHandler, class_310 minecraftClient) {
        ReceivePackets.gallerySiteAddress = null;
        ReceivePackets.serverSiteAddress = null;
        ReceivePackets.homeSiteAddress = null;
        ReceivePackets.commentSiteAddress = null;
        ReceivePackets.deletionSiteAddress = null;
        ReceivePackets.tagSiteAddress = null;
        ReceivePackets.allowDelete = false;
        ReceivePackets.allowDeleteOwn = false;
    }

    private void registerJoinEvent(class_634 playNetworkHandler, PacketSender packetSender, class_310 minecraftClient) {
        class_5250 uploadMessageString = class_2561.method_43473();
        Map<String, Map<String, String>> uploadUrls = ScreenshotUploaderClient.getStringMapMap();
        int index = 0;
        int totalKeys = uploadUrls.size();
        for (String key : uploadUrls.keySet()) {
            uploadMessageString = uploadMessageString.method_27661().method_10852((class_2561)class_2561.method_43470((String)key).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create((String)((Map)uploadUrls.get(key)).get("home")))).method_10977(class_124.field_1075).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.next_upload_server_description", (Object[])new Object[]{class_2561.method_43470((String)key).method_27694(style2 -> style2.method_10977(class_124.field_1075)), ((Map)uploadUrls.get(key)).get("upload"), ((Map)uploadUrls.get(key)).get("home"), class_2561.method_43472((String)"key.screenshot_uploader.gallery")})))));
            if (++index >= totalKeys) continue;
            uploadMessageString = uploadMessageString.method_27661().method_10852((class_2561)class_2561.method_43470((String)", ").method_27694(style -> style.method_10977(class_124.field_1075)));
        }
        minecraftClient.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.next_upload", (Object[])new Object[]{uploadMessageString}));
    }

    private static Map<String, Map<String, String>> getStringMapMap() {
        Map<String, Map<String, String>> uploadUrls = ConfigManager.getClientConfig().upload_urls;
        if (ReceivePackets.gallerySiteAddress != null) {
            HashMap<String, String> thisServerMap = new HashMap<String, String>();
            thisServerMap.put("home", ReceivePackets.homeSiteAddress);
            thisServerMap.put("upload", ReceivePackets.serverSiteAddress);
            thisServerMap.put("gallery", ReceivePackets.gallerySiteAddress);
            uploadUrls.put("This Server", thisServerMap);
        }
        return uploadUrls;
    }

    private static String extractUrl(String message) {
        String urlPattern = "https?://[\\w\\-._~:/?#\\[\\]@!$&'()*+,;=%]+";
        Pattern pattern = Pattern.compile(urlPattern);
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String url = matcher.group();
            if (!url.matches("(?i).+\\.(png|jpe?g|gif|webp)(\\?.*)?$")) continue;
            return url;
        }
        return null;
    }

    private static class_1269 signBlockClick(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_2338 pos = hitResult.method_17777();
        class_2680 blockState = world.method_8320(pos);
        if (!KeyInputHandler.editKey.method_1434()) {
            if (blockState.method_26204() instanceof class_2478) {
                class_2625 sign;
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity instanceof class_2625 && (sign = (class_2625)blockEntity).method_49855()) {
                    String frontText = sign.method_49853().method_49859(0, false).getString() + sign.method_49853().method_49859(1, false).getString() + sign.method_49853().method_49859(2, false).getString() + sign.method_49853().method_49859(3, false).getString();
                    String backText = sign.method_49854().method_49859(0, false).getString() + sign.method_49854().method_49859(1, false).getString() + sign.method_49854().method_49859(2, false).getString() + sign.method_49854().method_49859(3, false).getString();
                    String text = frontText + backText;
                    String urlPattern = "(https?://[\\w.-]+(?::\\d+)?(?:/[\\w.-]*)*)(\\[-?\\d+(?:[.,]\\d+)?(?:[;,:_+-]-?[a-zA-Z0-9$]+(?:[.:,_+-]\\d+)?)*?])?";
                    Pattern pattern = Pattern.compile(urlPattern);
                    Matcher matcher = pattern.matcher(text);
                    if (matcher.find()) {
                        class_310.method_1551().method_63588(() -> class_310.method_1551().method_1507((class_437)new ScreenshotScreen(matcher.group(1))));
                    }
                }
                return class_1269.field_5811;
            }
        } else {
            class_2625 sign;
            class_2586 class_25862;
            class_310 client = class_310.method_1551();
            class_239 hit = client.field_1765;
            if (hit instanceof class_3965 && client.field_1687 != null && (class_25862 = client.field_1687.method_8321(pos)) instanceof class_2625 && !(sign = (class_2625)class_25862).method_49855()) {
                client.method_63588(() -> client.method_1507((class_437)new CustomSignEditScreen(sign)));
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    private void deleteOldScreenshots() {
        Path screenshotDir = Paths.get("./screenshots/", new String[0]);
        Path likedFile = Paths.get("./config/screenshotUploader/data/local.json", new String[0]);
        Set<String> likedScreenshots = this.loadLikedScreenshots(likedFile.toString());
        if (screenshotDir.toFile().listFiles() == null) {
            return;
        }
        for (File file : Objects.requireNonNull(screenshotDir.toFile().listFiles())) {
            if (!ConfigManager.getClientConfig().deleteOldScreenshots || !file.isFile() || file.lastModified() >= System.currentTimeMillis() - (long)(ConfigManager.getClientConfig().deleteAfterDays * 24 * 60 * 60) * 1000L) continue;
            try {
                if (likedScreenshots.contains(file.getAbsoluteFile().toPath().toString().replace(".\\", ""))) continue;
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                this.logger.error("Failed to delete old screenshot: {}", (Object)e.getMessage());
            }
        }
    }

    private Set<String> loadLikedScreenshots(String FILE_PATH) {
        HashSet<String> likedScreenshots = new HashSet<String>();
        File file = new File(FILE_PATH);
        if (file.exists() && file.length() > 0L) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject obj = element.getAsJsonObject();
                    if (!obj.has("screenshotUrl")) continue;
                    likedScreenshots.add(obj.get("screenshotUrl").getAsString());
                }
            }
            catch (JsonSyntaxException e) {
                this.logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error("Error reading the like file.", (Throwable)e);
            }
        }
        return likedScreenshots;
    }
}

