/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.thecoolcraft11.config.data.Album;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlbumManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlbumManager.class);
    private static final String CONFIG_DIR = "config/screenshotUploader/data";
    private static final String ALBUMS_FILE = "albums.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Map<UUID, Album> albums = new HashMap<UUID, Album>();

    public static void loadAlbums() {
        File configDir = new File(CONFIG_DIR);
        if (!configDir.exists() && !configDir.mkdirs()) {
            LOGGER.error("Failed to create config directory during load");
            return;
        }
        File albumsFile = new File(configDir, ALBUMS_FILE);
        if (!albumsFile.exists()) {
            albums = new HashMap<UUID, Album>();
            AlbumManager.saveAlbums();
            return;
        }
        try (FileReader reader = new FileReader(albumsFile);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            albums = new HashMap<UUID, Album>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                try {
                    UUID uuid = UUID.fromString((String)entry.getKey());
                    JsonObject albumObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    String title = albumObj.get("title").getAsString();
                    String color = albumObj.get("color").getAsString();
                    String description = albumObj.get("description").getAsString();
                    String coverScreenshotName = albumObj.get("coverScreenshotName").getAsString();
                    Album album = new Album(uuid, title, color, description, coverScreenshotName);
                    albums.put(uuid, album);
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing album with ID: {}", entry.getKey(), (Object)e);
                }
            }
            LOGGER.info("Loaded {} albums", (Object)albums.size());
        }
        catch (Exception e) {
            LOGGER.error("Error loading albums", (Throwable)e);
            albums = new HashMap<UUID, Album>();
        }
    }

    public static void saveAlbums() {
        try {
            File configDir = new File(CONFIG_DIR);
            if (!configDir.exists() && !configDir.mkdirs()) {
                LOGGER.error("Failed to create config directory during save");
                return;
            }
            JsonObject root = AlbumManager.getJsonObject();
            try (FileWriter writer = new FileWriter(new File(configDir, ALBUMS_FILE));){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            LOGGER.info("Saved {} albums", (Object)albums.size());
        }
        catch (IOException e) {
            LOGGER.error("Error saving albums", (Throwable)e);
        }
    }

    @NotNull
    private static JsonObject getJsonObject() {
        JsonObject root = new JsonObject();
        for (Map.Entry<UUID, Album> entry : albums.entrySet()) {
            Album album = entry.getValue();
            JsonObject albumObj = new JsonObject();
            albumObj.addProperty("title", album.getTitle());
            albumObj.addProperty("color", album.getColor());
            albumObj.addProperty("description", album.getDescription());
            albumObj.addProperty("coverScreenshotName", album.getCoverScreenshotName());
            root.add(entry.getKey().toString(), (JsonElement)albumObj);
        }
        return root;
    }

    public static void addAlbum(Album album) {
        albums.put(album.getUuid(), album);
        AlbumManager.saveAlbums();
    }

    public static void updateAlbum(Album album) {
        if (albums.containsKey(album.getUuid())) {
            albums.put(album.getUuid(), album);
            AlbumManager.saveAlbums();
        }
    }

    public static void removeAlbum(UUID uuid) {
        if (albums.remove(uuid) != null) {
            AlbumManager.saveAlbums();
        }
    }

    public static List<Album> getAllAlbums() {
        return new ArrayList<Album>(albums.values());
    }

    public static Album getAlbum(UUID uuid) {
        return albums.get(uuid);
    }
}

