/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.thecoolcraft11.config.data.ClientConfig;
import de.thecoolcraft11.config.data.ServerConfig;
import de.thecoolcraft11.config.value.Comment;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger logger = LoggerFactory.getLogger((String)"screenshot-uploader");
    private static ClientConfig clientConfig;
    private static ServerConfig serverConfig;

    public static void initialize(File configDir, boolean isClient) {
        if (isClient) {
            File clientConfigFile = new File(configDir, "config.json");
            if (clientConfigFile.exists()) {
                ConfigManager.loadConfig(clientConfigFile, true);
            } else {
                clientConfig = new ClientConfig();
                ConfigManager.saveClientConfig(configDir);
            }
        } else {
            File serverConfigFile = new File(configDir, "serverConfig.json");
            if (serverConfigFile.exists()) {
                ConfigManager.loadConfig(serverConfigFile, false);
            } else {
                serverConfig = new ServerConfig();
                ConfigManager.saveServerConfig(configDir);
            }
        }
    }

    private static void loadConfig(File configFile, boolean isClient) {
        try (FileReader reader = new FileReader(configFile);){
            JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (isClient) {
                clientConfig = (ClientConfig)GSON.fromJson(jsonElement, ClientConfig.class);
                ConfigManager.addMissingFields(clientConfig, jsonElement, configFile);
            } else {
                serverConfig = (ServerConfig)GSON.fromJson(jsonElement, ServerConfig.class);
                ConfigManager.addMissingFields(serverConfig, jsonElement, configFile);
            }
        }
        catch (IOException e) {
            logger.error("Failed to load config: {}", (Object)e.getMessage());
            if (isClient) {
                clientConfig = new ClientConfig();
            }
            serverConfig = new ServerConfig();
        }
    }

    private static void addMissingFields(Object config, JsonElement jsonElement, File configFile) {
        Field[] fields = config.getClass().getDeclaredFields();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        boolean hasNewFields = false;
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                String fieldName = field.getName();
                String commentFieldName = "_comment_" + fieldName;
                if (!jsonObject.has(fieldName)) {
                    Object defaultValue = field.get(config);
                    if (field.isAnnotationPresent(Comment.class)) {
                        Comment comment = field.getAnnotation(Comment.class);
                        jsonObject.addProperty(commentFieldName, comment.value());
                    }
                    jsonObject.add(fieldName, GSON.toJsonTree(defaultValue));
                    field.set(config, defaultValue);
                    logger.info("Added missing field: '{}' with default value.", (Object)fieldName);
                    hasNewFields = true;
                    continue;
                }
                if (!field.isAnnotationPresent(Comment.class) || jsonObject.has(commentFieldName)) continue;
                Comment comment = field.getAnnotation(Comment.class);
                jsonObject.addProperty(commentFieldName, comment.value());
                logger.info("Added missing comment for field: '{}'", (Object)fieldName);
                hasNewFields = true;
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to add new config values: {}", (Object)e.getMessage());
            }
        }
        if (hasNewFields) {
            ConfigManager.saveConfig(configFile, jsonObject);
        }
    }

    private static void saveConfig(File configFile, Object config) {
        try (FileWriter writer = new FileWriter(configFile);){
            JsonObject jsonObject = new JsonObject();
            for (Field field : config.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    if (field.isAnnotationPresent(Comment.class)) {
                        Comment comment = field.getAnnotation(Comment.class);
                        jsonObject.addProperty("_comment_" + field.getName(), comment.value());
                    }
                    jsonObject.add(field.getName(), GSON.toJsonTree(field.get(config)));
                }
                catch (IllegalAccessException e) {
                    logger.error("Failed to access field '{}' while saving config: {}", (Object)field.getName(), (Object)e.getMessage());
                }
            }
            if (jsonObject.has("members")) {
                jsonObject = jsonObject.getAsJsonObject("members");
            }
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
            logger.info("Config saved to {}", (Object)configFile.getName());
        }
        catch (IOException e) {
            logger.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    public static ClientConfig getClientConfig() {
        return clientConfig;
    }

    public static ServerConfig getServerConfig() {
        return serverConfig;
    }

    public static void saveClientConfig(File configDir) {
        File clientConfigFile = new File(configDir, "config.json");
        ConfigManager.saveConfig(clientConfigFile, clientConfig);
    }

    public static void saveServerConfig(File configDir) {
        File serverConfigFile = new File(configDir, "serverConfig.json");
        ConfigManager.saveConfig(serverConfigFile, serverConfig);
    }

    public static void reloadConfig(File configDir, boolean isClient) {
        if (isClient) {
            File clientConfigFile = new File(configDir, "config.json");
            if (clientConfigFile.exists()) {
                ConfigManager.loadConfig(clientConfigFile, true);
                logger.info("Client configuration reloaded successfully.");
            } else {
                logger.warn("Client config file does not exist. Reload ignored.");
            }
        } else {
            File serverConfigFile = new File(configDir, "serverConfig.json");
            if (serverConfigFile.exists()) {
                ConfigManager.loadConfig(serverConfigFile, false);
                logger.info("Server configuration reloaded successfully.");
            } else {
                logger.warn("Server config file does not exist. Reload ignored.");
            }
        }
    }
}

