/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.mixin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.event.KeyInputHandler;
import de.thecoolcraft11.screen.ConfirmScreenshotsScreen;
import de.thecoolcraft11.screen.EditScreen;
import de.thecoolcraft11.screen.GalleryScreen;
import de.thecoolcraft11.util.ErrorMessages;
import de.thecoolcraft11.util.ReceivePackets;
import de.thecoolcraft11.util.ScreenshotDataHelper;
import de.thecoolcraft11.util.ScreenshotUploadHelper;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_318.class})
@Environment(value=EnvType.CLIENT)
public abstract class ScreenshotMixin {
    @Unique
    private static final Logger logger = LoggerFactory.getLogger(ScreenshotMixin.class);

    @Shadow
    private static File method_1660(File directory) {
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"method_22691"})
    private static void screenshotCaptured(class_1011 nativeImage_1, File file_1, Consumer<class_2561> consumer_1, CallbackInfo ci) {
        if (ConfigManager.getClientConfig().enableMod) {
            class_310 client = class_310.method_1551();
            if (KeyInputHandler.editKey.method_1436()) {
                client.method_63588(() -> client.method_1507((class_437)new EditScreen(null, null, nativeImage_1, image -> {
                    if (image != null) {
                        class_1011 imageCopy = new class_1011(image.method_4307(), image.method_4323(), false);
                        for (int y = 0; y < image.method_4323(); ++y) {
                            for (int x = 0; x < image.method_4307(); ++x) {
                                imageCopy.method_61941(x, y, image.method_61940(x, y));
                            }
                        }
                        ScreenshotMixin.saveEditedFile(file_1.getAbsolutePath(), imageCopy);
                        ScreenshotMixin.initializeUpload(imageCopy);
                    }
                })));
            } else {
                ScreenshotMixin.initializeUpload(nativeImage_1);
            }
            GalleryScreen.addNewScreenshot(file_1.getAbsoluteFile().toPath());
        }
    }

    @Unique
    private static void saveEditedFile(String absolutePath, class_1011 imageCopy) {
        StringBuilder template = new StringBuilder(ConfigManager.getClientConfig().editImageFilePath);
        template.replace(template.indexOf("{fileName}"), "{fileName}".length(), absolutePath);
        File outputFile = new File(template.toString());
        try {
            imageCopy.method_4325(outputFile);
            logger.info("Image saved to {}", (Object)outputFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("Failed to save the image to disk", (Throwable)e);
        }
    }

    @Unique
    private static void initializeUpload(class_1011 image) {
        class_310 client = class_310.method_1551();
        String jsonData = ScreenshotDataHelper.getJSONData(client);
        String filename = Objects.requireNonNull(ScreenshotMixin.method_1660(Paths.get(client.field_1697.getName(), "screenshots").toFile())).getName();
        if (ConfigManager.getClientConfig().saveJsonData) {
            File jsonFile = new File(client.field_1697, "screenshots/" + filename.replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
            try {
                boolean wasCreated = jsonFile.createNewFile();
                if (!wasCreated) {
                    logger.info("JSON file already exists: {}", (Object)jsonFile.getAbsolutePath());
                }
                Files.writeString(jsonFile.toPath(), (CharSequence)jsonData, new OpenOption[0]);
            }
            catch (Exception e) {
                logger.error("Failed to save the JSON data to disk", (Throwable)e);
            }
        }
        if (ConfigManager.getClientConfig().requireNoHud && !client.field_1690.field_1842 || ConfigManager.getClientConfig().limitToServer && !Objects.equals(Objects.requireNonNull(client.method_1558()).field_3761, ConfigManager.getClientConfig().limitedServerAddr)) {
            return;
        }
        if (ConfigManager.getClientConfig().askBeforeUpload) {
            client.method_63588(() -> client.method_1507((class_437)new ConfirmScreenshotsScreen(client.field_1755, image, jsonData, filename, (doSave, doUpload, image1, jsonData1) -> {
                if (!doSave.booleanValue()) {
                    client.method_1507(client.field_1755);
                    try {
                        File screenshotFile = new File(client.field_1697, "screenshots/" + filename);
                        boolean wasDeleted = screenshotFile.delete();
                        if (wasDeleted) {
                            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.screenshot_deleted", (Object[])new Object[]{filename}).method_27694(style -> style.method_10977(class_124.field_1061)));
                        } else {
                            logger.error("Failed to delete the screenshot file: {}", (Object)screenshotFile.getAbsolutePath());
                        }
                        Path screenshotPath = Path.of(screenshotFile.getAbsolutePath(), new String[0]);
                        if (GalleryScreen.getNewScreenshots().contains(screenshotPath)) {
                            GalleryScreen.removeNewScreenshot(screenshotPath);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Failed to delete the image file", (Throwable)e);
                    }
                    return;
                }
                if (image1 != null) {
                    if (doUpload.booleanValue()) {
                        class_1011 imageCopy = new class_1011(image1.method_4307(), image1.method_4323(), false);
                        for (int y = 0; y < image1.method_4323(); ++y) {
                            for (int x = 0; x < image1.method_4307(); ++x) {
                                imageCopy.method_61941(x, y, image1.method_61940(x, y));
                            }
                        }
                        ScreenshotMixin.startUpload(client, imageCopy, jsonData1);
                    } else {
                        client.method_1507(client.field_1755);
                    }
                }
            })));
        }
        if (ConfigManager.getClientConfig().askBeforeUpload) {
            return;
        }
        ScreenshotMixin.startUpload(client, image, jsonData);
    }

    @Unique
    private static void startUpload(class_310 client, class_1011 image, String jsonData) {
        new Thread(() -> {
            ArrayList<String> targets = new ArrayList<String>();
            if (ConfigManager.getClientConfig().uploadScreenshotsToUrl) {
                for (Map<String, String> value : ConfigManager.getClientConfig().upload_urls.values()) {
                    targets.add(value.get("upload"));
                }
            }
            if (ReceivePackets.serverSiteAddress != null) {
                targets.add(ReceivePackets.serverSiteAddress);
            }
            StringBuilder messageBuilder = ScreenshotMixin.getStringBuilder(targets);
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.uploading_to", (Object[])new Object[]{class_2561.method_43470((String)messageBuilder.toString()).method_27694(style -> style.method_10977(class_124.field_1075))}));
            List<JsonObject> uploadResults = ScreenshotUploadHelper.uploadScreenshot(image, jsonData, targets);
            client.execute(() -> uploadResults.forEach(uploadResult -> {
                String statusMessage = uploadResult.get("status").getAsString();
                if ("success".equals(statusMessage)) {
                    JsonObject responseBody = null;
                    try {
                        responseBody = JsonParser.parseString((String)uploadResult.get("responseBody").getAsString()).getAsJsonObject();
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse responseBody", (Throwable)e);
                    }
                    String baseMessage = "message.screenshot_uploader.upload_success";
                    class_5250 clickableLink = class_2561.method_43473();
                    class_5250 clickableLink2 = class_2561.method_43473();
                    class_5250 clickableLink3 = class_2561.method_43473();
                    class_5250 clickableLink4 = class_2561.method_43473();
                    class_5250 clickableLink5 = class_2561.method_43473();
                    if (responseBody != null) {
                        String galleryUrl;
                        String screenshotUrl = responseBody.has("url") && !responseBody.get("url").isJsonNull() ? responseBody.get("url").getAsString() : null;
                        String string = galleryUrl = responseBody.has("gallery") && !responseBody.get("gallery").isJsonNull() ? responseBody.get("gallery").getAsString() : null;
                        if (screenshotUrl != null && galleryUrl != null) {
                            clickableLink = class_2561.method_43471((String)"message.screenshot_uploader.open_screenshot").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/open-screenshot \"" + screenshotUrl + "\"")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"message.screenshot_uploader.see_screenshot"))).method_10977(class_124.field_1075));
                        }
                        if (screenshotUrl != null) {
                            clickableLink2 = class_2561.method_43471((String)"message.screenshot_uploader.open_link").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(screenshotUrl))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"message.screenshot_uploader.open_website"))).method_10977(class_124.field_1078));
                        }
                        if (galleryUrl != null) {
                            clickableLink3 = class_2561.method_43471((String)"message.screenshot_uploader.open_all").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(galleryUrl))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"message.screenshot_uploader.see_screenshots"))).method_10977(class_124.field_1054));
                        }
                        if (screenshotUrl != null) {
                            clickableLink4 = class_2561.method_43471((String)"message.screenshot_uploader.copy").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(screenshotUrl)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"message.screenshot_uploader.copy_url"))).method_10977(class_124.field_1080));
                        }
                        if (screenshotUrl != null) {
                            clickableLink5 = class_2561.method_43471((String)"message.screenshot_uploader.share").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610(screenshotUrl)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"message.screenshot_uploader.share_screenshot"))).method_10977(class_124.field_1077));
                        }
                        if (screenshotUrl == null && galleryUrl == null) {
                            baseMessage = "message.screenshot_uploader_no_return_url";
                        }
                        class_5250 finalMessage = class_2561.method_43469((String)baseMessage, (Object[])new Object[]{clickableLink, clickableLink2, clickableLink3, clickableLink4, clickableLink5});
                        client.field_1705.method_1743().method_1812((class_2561)finalMessage);
                    }
                } else {
                    String errorMessage = uploadResult.has("message") ? uploadResult.get("message").getAsString() : "Unknown error";
                    class_5250 errorText = class_2561.method_43469((String)"message.screenshot_uploader.upload_failed", (Object[])new Object[]{errorMessage.split(":")[0]}).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)ErrorMessages.getErrorDescription(errorMessage.split(":")[0])))));
                    client.field_1705.method_1743().method_1812((class_2561)errorText);
                }
            }));
        }).start();
    }

    @Unique
    @NotNull
    private static StringBuilder getStringBuilder(List<String> targets) {
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 0; i < targets.size(); ++i) {
            String target = targets.get(i);
            String targetText = target.equals("mcserver://this") || target.equals("mcserver://chunked") ? "This Server" : target;
            messageBuilder.append(targetText);
            if (i >= targets.size() - 1) continue;
            messageBuilder.append(", ");
        }
        return messageBuilder;
    }
}

