/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import de.thecoolcraft11.config.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1043;
import net.minecraft.class_10529;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2478;
import net.minecraft.class_2551;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4719;
import net.minecraft.class_5614;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_10529.class}, priority=100000)
public class SignBlockEntityRendererMixin {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ScreenshotUploader");
    @Unique
    private static final Map<String, class_2960> SCREENSHOT_TEXTURES = new HashMap<String, class_2960>();
    @Unique
    class_918 itemRenderer;
    @Unique
    private float rotationAngle = 0.0f;

    @Inject(method={"<init>(Lnet/minecraft/client/render/block/entity/BlockEntityRendererFactory$Context;)V"}, at={@At(value="RETURN")})
    private void onConstructor(class_5614.class_5615 context, CallbackInfo ci) {
        this.itemRenderer = context.method_43335();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"render(Lnet/minecraft/block/entity/SignBlockEntity;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/block/BlockState;Lnet/minecraft/block/AbstractSignBlock;Lnet/minecraft/block/WoodType;Lnet/minecraft/client/model/Model;)V"}, at={@At(value="HEAD")}, cancellable=true)
    void render(class_2625 entity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_2680 state, class_2478 block, class_4719 woodType, class_3879 model, CallbackInfo ci) {
        if (ConfigManager.getClientConfig().highlightScreenshotSigns && entity.method_10997() != null) {
            matrices.method_22903();
            String text = entity.method_49853().method_49859(0, false).getString() + entity.method_49853().method_49859(1, false).getString() + entity.method_49853().method_49859(2, false).getString() + entity.method_49853().method_49859(3, false).getString() + entity.method_49854().method_49859(0, false).getString() + entity.method_49854().method_49859(1, false).getString() + entity.method_49854().method_49859(2, false).getString() + entity.method_49854().method_49859(3, false).getString();
            String urlPattern = "(https?://[\\w.-]+(?::\\d+)?(?:/[\\w.-]*)*)(\\[-?\\d+(?:[.,]\\d+)?(?:[;,:_+-]-?[a-zA-Z0-9$]+(?:[.:,_+-]\\d+)?)*?])?";
            Pattern pattern = Pattern.compile(urlPattern);
            Matcher matcher = pattern.matcher(text);
            try {
                String highlightItemName = ConfigManager.getClientConfig().highlightItem;
                float customX = 0.0f;
                float customY = 0.0f;
                float customZ = 0.0f;
                float customYaw = 0.0f;
                float customPitch = 0.0f;
                float customSize = 0.75f;
                int customLight = Math.min(light + ConfigManager.getClientConfig().imageLightBoost, 0xF000F0);
                boolean useCustomTransformations = false;
                if (matcher.find() && entity.method_49855()) {
                    class_2960 signTexture;
                    String url = matcher.group(1);
                    String transformations = matcher.group(2);
                    boolean isWall = this.isWallSign(entity.method_10997(), entity.method_11016());
                    boolean isHanging = this.isHangingSign(entity.method_10997(), entity.method_11016());
                    boolean isWallHanging = this.isWallHangingSign(entity.method_10997(), entity.method_11016());
                    class_2350 facing = class_2350.field_11035;
                    if (transformations != null && !transformations.isEmpty()) {
                        try {
                            String cleanTransformations = transformations.substring(1, transformations.length() - 1);
                            String[] parts = cleanTransformations.split("[;,]");
                            if (parts.length >= 1) {
                                customX = Float.parseFloat(parts[0]);
                                if (parts.length >= 2) {
                                    customY = -Float.parseFloat(parts[1]);
                                    if (parts.length >= 3) {
                                        customZ = Float.parseFloat(parts[2]);
                                        if (parts.length >= 4) {
                                            customYaw = Float.parseFloat(parts[3]);
                                            if (parts.length >= 5) {
                                                customPitch = Float.parseFloat(parts[4]);
                                                if (parts.length >= 6) {
                                                    customSize = Float.parseFloat(parts[5]);
                                                    if (parts.length >= 7) {
                                                        customLight = Math.min(Integer.parseInt(parts[6]), 0xF000F0);
                                                        if (parts.length >= 8) {
                                                            highlightItemName = parts[7];
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                useCustomTransformations = true;
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to parse transformation string: {}", (Object)transformations, (Object)e);
                        }
                    }
                    if (isWall || isWallHanging) {
                        facing = (class_2350)entity.method_10997().method_8320(entity.method_11016()).method_11654((class_2769)class_2741.field_12481);
                    }
                    if (isHanging || isWallHanging) {
                        signTexture = class_2960.method_60655((String)"minecraft", (String)("textures/entity/signs/hanging/" + woodType.comp_1299().toLowerCase() + ".png"));
                        if (ConfigManager.getClientConfig().useCustomSign && !useCustomTransformations) {
                            signTexture = class_2960.method_60655((String)"screenshot-uploader", (String)"textures/entity/signs/hanging_screenshot.png");
                        }
                    } else {
                        signTexture = class_2960.method_60655((String)"minecraft", (String)("textures/entity/signs/" + woodType.comp_1299().toLowerCase() + ".png"));
                        if (ConfigManager.getClientConfig().useCustomSign && !useCustomTransformations) {
                            signTexture = class_2960.method_60655((String)"screenshot-uploader", (String)"textures/entity/signs/screenshot.png");
                        }
                    }
                    float scale = 0.75f;
                    if (!useCustomTransformations && ConfigManager.getClientConfig().highlightOscillation) {
                        long elapsedTime = System.nanoTime();
                        float oscillation = (float)Math.sin((double)elapsedTime / 5.0E9 * Math.PI * 2.0);
                        scale = 0.05f * oscillation + 0.8f;
                    }
                    float alpha = ConfigManager.getClientConfig().highlightColorA;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    matrices.method_22903();
                    if (isWallHanging) {
                        float yOffset = 0.625f;
                        float xzOffset = 0.5f;
                        switch (facing) {
                            case field_11043: 
                            case field_11035: {
                                matrices.method_46416(xzOffset, yOffset, xzOffset);
                                break;
                            }
                            case field_11034: {
                                matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(90.0)));
                                matrices.method_46416(-xzOffset, yOffset, xzOffset);
                                break;
                            }
                            case field_11039: {
                                matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(270.0)));
                                matrices.method_46416(-xzOffset, yOffset, xzOffset);
                            }
                        }
                    } else if (isHanging) {
                        matrices.method_46416(0.5f, 0.65f, 0.5f);
                        try {
                            float rotation = (float)((Integer)entity.method_10997().method_8320(entity.method_11016()).method_11654((class_2769)class_2741.field_12532)).intValue() * 22.5f;
                            matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(-rotation)));
                        }
                        catch (Exception rotation) {}
                    } else if (isWall) {
                        matrices.method_46416(0.5f, 0.123f, 0.5f);
                        float zOffset = 0.434f;
                        switch (facing) {
                            case field_11043: {
                                matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(180.0)));
                                matrices.method_46416(0.0f, 0.0f, zOffset);
                                break;
                            }
                            case field_11035: {
                                matrices.method_46416(0.0f, 0.0f, -zOffset);
                                break;
                            }
                            case field_11034: {
                                matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(270.0)));
                                matrices.method_46416(-zOffset, 0.0f, 0.0f);
                                break;
                            }
                            case field_11039: {
                                matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(90.0)));
                                matrices.method_46416(zOffset, 0.0f, 0.0f);
                            }
                        }
                    } else {
                        matrices.method_46416(0.5f, 0.45f, 0.5f);
                        try {
                            float rotation = (float)((Integer)entity.method_10997().method_8320(entity.method_11016()).method_11654((class_2769)class_2741.field_12532)).intValue() * 22.5f;
                            matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(-rotation)));
                        }
                        catch (Exception rotation) {
                            // empty catch block
                        }
                    }
                    if (isHanging || isWallHanging) {
                        scale = 1.01f;
                    }
                    matrices.method_22905(scale, -scale, scale);
                    if (ConfigManager.getClientConfig().rotateHighlightSign) {
                        float radians = this.rotationAngle * (float)Math.PI / 180.0f;
                        Quaternionf rotation = new Quaternionf(0.0f, class_3532.method_15374((float)(radians / 2.0f)), 0.0f, class_3532.method_15362((float)(radians / 2.0f)));
                        matrices.method_22907((Quaternionfc)rotation);
                    }
                    class_4588 outlineConsumer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)signTexture));
                    int alphaValue = (int)(alpha * 255.0f);
                    int color = alphaValue << 24 | ConfigManager.getClientConfig().highlightColorR << 16 | ConfigManager.getClientConfig().highlightColorG << 8 | ConfigManager.getClientConfig().highlightColorB;
                    model.method_62100(matrices, outlineConsumer, light, overlay, color);
                    class_2960 screenshotTexture = this.getScreenshotTexture(url);
                    if (screenshotTexture != null && ConfigManager.getClientConfig().enableScreenshotRendering) {
                        this.renderScreenshotOnSign(matrices, vertexConsumers, screenshotTexture, isWallHanging || isHanging, useCustomTransformations, customX, customY, customZ, customYaw, customPitch, customSize, customLight);
                    }
                    matrices.method_22909();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (matcher.matches() && entity.method_49855()) {
                    matrices.method_22903();
                    boolean isWall = this.isWallSign(entity.method_10997(), entity.method_11016());
                    boolean isHanging = this.isHangingSign(entity.method_10997(), entity.method_11016());
                    boolean isWallHanging = this.isWallHangingSign(entity.method_10997(), entity.method_11016());
                    class_2350 facing = class_2350.field_11035;
                    if (isWall || isWallHanging) {
                        facing = (class_2350)entity.method_10997().method_8320(entity.method_11016()).method_11654((class_2769)class_2741.field_12481);
                    }
                    if (isWallHanging) {
                        matrices.method_22904(0.5, 1.5, 0.5);
                        float offset = 0.15f;
                        switch (facing) {
                            case field_11043: {
                                matrices.method_46416(0.0f, 0.0f, offset);
                                break;
                            }
                            case field_11035: {
                                matrices.method_46416(0.0f, 0.0f, -offset);
                                break;
                            }
                            case field_11034: {
                                matrices.method_46416(-offset, 0.0f, 0.0f);
                                break;
                            }
                            case field_11039: {
                                matrices.method_46416(offset, 0.0f, 0.0f);
                            }
                        }
                    } else if (isHanging) {
                        matrices.method_22904(0.5, (double)1.9f, 0.5);
                    } else if (isWall) {
                        matrices.method_22904(0.5, 1.25, 0.5);
                        float offset = 0.2f;
                        switch (facing) {
                            case field_11043: {
                                matrices.method_46416(0.0f, 0.0f, offset);
                                break;
                            }
                            case field_11035: {
                                matrices.method_46416(0.0f, 0.0f, -offset);
                                break;
                            }
                            case field_11034: {
                                matrices.method_46416(-offset, 0.0f, 0.0f);
                                break;
                            }
                            case field_11039: {
                                matrices.method_46416(offset, 0.0f, 0.0f);
                            }
                        }
                    } else {
                        matrices.method_22904(0.5, (double)1.66f, 0.5);
                    }
                    float horizontalOffset = ConfigManager.getClientConfig().itemHorizontalOffset;
                    float verticalOffset = ConfigManager.getClientConfig().itemVerticalOffset;
                    float depthOffset = ConfigManager.getClientConfig().itemDepthOffset;
                    float itemScale = ConfigManager.getClientConfig().itemScale;
                    if (isWall || isWallHanging) {
                        switch (facing) {
                            case field_11043: {
                                matrices.method_46416(horizontalOffset, verticalOffset, -depthOffset);
                                break;
                            }
                            case field_11035: {
                                matrices.method_46416(-horizontalOffset, verticalOffset, depthOffset);
                                break;
                            }
                            case field_11034: {
                                matrices.method_46416(depthOffset, verticalOffset, horizontalOffset);
                                break;
                            }
                            case field_11039: {
                                matrices.method_46416(-depthOffset, verticalOffset, -horizontalOffset);
                            }
                        }
                    } else {
                        matrices.method_46416(horizontalOffset, verticalOffset, depthOffset);
                    }
                    matrices.method_22905(itemScale, itemScale, itemScale);
                    this.rotationAngle += ConfigManager.getClientConfig().highlightRotationSpeed;
                    if (this.rotationAngle >= 360.0f) {
                        this.rotationAngle = 0.0f;
                    }
                    if (ConfigManager.getClientConfig().rotateHighlightItem) {
                        float radians = this.rotationAngle * (float)Math.PI / 180.0f;
                        Quaternionf rotation = new Quaternionf(0.0f, class_3532.method_15374((float)(radians / 2.0f)), 0.0f, class_3532.method_15362((float)(radians / 2.0f)));
                        matrices.method_22907((Quaternionfc)rotation);
                    }
                    class_2960 itemIdentifier = class_2960.method_12829((String)(highlightItemName.startsWith("$") ? highlightItemName.replace("$", "minecraft:") : highlightItemName));
                    class_1799 itemStack = ((class_1792)class_7923.field_41178.method_63535(itemIdentifier)).method_7854();
                    this.itemRenderer.method_23178(itemStack, class_811.field_4319, customLight, overlay, matrices, vertexConsumers, entity.method_10997(), 0);
                    matrices.method_22909();
                }
            }
            finally {
                matrices.method_22909();
                if (ConfigManager.getClientConfig().hideSign && matcher.matches() && entity.method_49855()) {
                    ci.cancel();
                }
            }
        }
    }

    @Unique
    private void renderScreenshotOnSign(class_4587 matrices, class_4597 vertexConsumers, class_2960 textureId, boolean isHanging, boolean useCustomTransformations, float customX, float customY, float customZ, float customYaw, float customPitch, float customSize, int customLight) {
        class_1043 texture;
        float height;
        matrices.method_22903();
        if (isHanging) {
            matrices.method_46416(0.0f, ConfigManager.getClientConfig().hangingSignVerticalOffset, 0.0f);
        } else {
            matrices.method_46416(0.0f, ConfigManager.getClientConfig().regularSignVerticalOffset, 0.0f);
        }
        if (!isHanging && ConfigManager.getClientConfig().imageZOffset != 0.0f) {
            matrices.method_46416(0.0f, 0.0f, ConfigManager.getClientConfig().imageZOffset);
        } else if (isHanging && ConfigManager.getClientConfig().hangingImageZOffset != 0.0f) {
            matrices.method_46416(0.0f, 0.0f, ConfigManager.getClientConfig().hangingImageZOffset);
        }
        if (useCustomTransformations) {
            matrices.method_46416(0.0f, 0.0f, 0.0f);
            matrices.method_46416(customX, customY, customZ);
            matrices.method_22907((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(-customYaw)));
            matrices.method_22907((Quaternionfc)new Quaternionf().rotationX((float)Math.toRadians(customPitch)));
        }
        float width = isHanging ? ConfigManager.getClientConfig().hangingSignImageWidth : ConfigManager.getClientConfig().regularSignImageWidth;
        float f = height = isHanging ? ConfigManager.getClientConfig().hangingSignImageHeight : ConfigManager.getClientConfig().regularSignImageHeight;
        if (useCustomTransformations) {
            float sizeFactor = customSize / 0.75f;
            width *= sizeFactor;
            height *= sizeFactor;
        }
        if (ConfigManager.getClientConfig().preserveImageAspectRatio && (texture = this.getTextureFromId(textureId)) != null && texture.method_4525() != null) {
            int imageWidth = texture.method_4525().method_4307();
            int imageHeight = texture.method_4525().method_4323();
            if (imageWidth > 0 && imageHeight > 0) {
                float imageRatio = (float)imageWidth / (float)imageHeight;
                float targetRatio = width / height;
                if (imageRatio > targetRatio) {
                    height = width / imageRatio;
                } else {
                    width = height * imageRatio;
                }
            }
        }
        matrices.method_46416(-width / 2.0f, -height / 2.0f, 0.0f);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_1921 renderLayer = class_1921.method_23580((class_2960)textureId);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(renderLayer);
        int r = ConfigManager.getClientConfig().imageColorR;
        int g = ConfigManager.getClientConfig().imageColorG;
        int b = ConfigManager.getClientConfig().imageColorB;
        int a = ConfigManager.getClientConfig().imageColorA;
        if (r == 0 && g == 0 && b == 0) {
            b = 255;
            g = 255;
            r = 255;
        }
        vertexConsumer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_1336(r, g, b, a).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(customLight).method_22914(0.0f, 0.0f, 1.0f);
        vertexConsumer.method_22918(matrix, 0.0f, height, 0.0f).method_1336(r, g, b, a).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(customLight).method_22914(0.0f, 0.0f, 1.0f);
        vertexConsumer.method_22918(matrix, width, height, 0.0f).method_1336(r, g, b, a).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(customLight).method_22914(0.0f, 0.0f, 1.0f);
        vertexConsumer.method_22918(matrix, width, 0.0f, 0.0f).method_1336(r, g, b, a).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(customLight).method_22914(0.0f, 0.0f, 1.0f);
        matrices.method_22909();
    }

    @Unique
    private class_1043 getTextureFromId(class_2960 id) {
        try {
            return (class_1043)class_310.method_1551().method_1531().method_4619(id);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get texture from id: {}", (Object)id);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    @Unique
    private class_2960 getScreenshotTexture(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Unique
    public boolean isWallSign(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26204() instanceof class_2551;
    }

    @Unique
    public boolean isHangingSign(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26204() instanceof class_7713 || blockState.method_26204() instanceof class_7715;
    }

    @Unique
    public boolean isWallHangingSign(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26204() instanceof class_7715;
    }
}

