/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import de.thecoolcraft11.config.AlbumManager;
import de.thecoolcraft11.config.data.Album;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class AlbumConfigScreen
extends class_437 {
    private final class_437 parent;
    private class_342 titleField;
    private class_342 colorField;
    private class_342 descriptionField;
    private class_342 coverScreenshotField;
    private class_4185 addButton;
    private int colorPreviewX;
    private int colorPreviewY;
    private int colorPreviewSize;
    private final Pattern colorPattern = Pattern.compile("^#[0-9A-Fa-f]{6}$");
    private final List<Album> albums = new ArrayList<Album>();
    private int selectedAlbumIndex = -1;
    private int scrollOffset = 0;

    public AlbumConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.albums.clear();
        this.albums.addAll(AlbumManager.getAllAlbums());
        this.titleField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 50, 200, 20, (class_2561)class_2561.method_43470((String)"Title"));
        this.titleField.method_1880(32);
        this.titleField.method_47404((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.album_title"));
        this.method_37063((class_364)this.titleField);
        int centerX = this.field_22789 / 2;
        this.colorField = new class_342(this.field_22793, centerX - 100, 80, 180, 20, (class_2561)class_2561.method_43470((String)"Color"));
        this.colorField.method_1880(7);
        this.colorField.method_1852("#");
        this.colorField.method_47404((class_2561)class_2561.method_43470((String)"#RRGGBB"));
        this.method_37063((class_364)this.colorField);
        this.colorPreviewX = centerX + 90;
        this.colorPreviewY = 80;
        this.colorPreviewSize = 20;
        this.descriptionField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 110, 200, 20, (class_2561)class_2561.method_43470((String)"Description"));
        this.descriptionField.method_1880(128);
        this.descriptionField.method_47404((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.album_description"));
        this.method_37063((class_364)this.descriptionField);
        this.coverScreenshotField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 140, 200, 20, (class_2561)class_2561.method_43470((String)"Cover"));
        this.coverScreenshotField.method_1880(64);
        this.coverScreenshotField.method_47404((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.album_cover"));
        this.method_37063((class_364)this.coverScreenshotField);
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Album"), button -> {
            if (this.validateInputs()) {
                Album album = new Album(this.titleField.method_1882(), this.colorField.method_1882(), this.descriptionField.method_1882(), this.coverScreenshotField.method_1882());
                AlbumManager.addAlbum(album);
                this.albums.clear();
                this.albums.addAll(AlbumManager.getAllAlbums());
                this.clearInputFields();
            }
        }).method_46433(this.field_22789 / 2 - 100, 170).method_46437(95, 20).method_46431();
        this.method_37063((class_364)this.addButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.method_25419()).method_46433(this.field_22789 / 2 + 5, 170).method_46437(95, 20).method_46431();
        this.method_37063((class_364)cancelButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2"), button -> {
            if (this.scrollOffset > 0) {
                --this.scrollOffset;
            }
        }).method_46433(this.field_22789 / 2 + 110, 220).method_46437(20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc"), button -> {
            if (this.scrollOffset < Math.max(0, this.albums.size() - 5)) {
                ++this.scrollOffset;
            }
        }).method_46433(this.field_22789 / 2 + 110, 280).method_46437(20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.delete"), button -> {
            if (this.selectedAlbumIndex >= 0 && this.selectedAlbumIndex < this.albums.size()) {
                Album albumToDelete = this.albums.get(this.selectedAlbumIndex);
                AlbumManager.removeAlbum(albumToDelete.getUuid());
                this.albums.clear();
                this.albums.addAll(AlbumManager.getAllAlbums());
                this.selectedAlbumIndex = -1;
            }
        }).method_46433(this.field_22789 / 2 - 100, this.field_22790 - 30).method_46437(200, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.title_header"), this.field_22789 / 2 - 100, 40, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.color_header"), this.field_22789 / 2 - 100, 70, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.description_header"), this.field_22789 / 2 - 100, 100, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_manager.cover_header"), this.field_22789 / 2 - 100, 130, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Existing Albums:"), this.field_22789 / 2 - 100, 200, 0xFFFFFF);
        Object hexColor = this.colorField.method_1882();
        if (hexColor != null) {
            if (!((String)hexColor).startsWith("#")) {
                hexColor = "#" + (String)hexColor;
            }
            if (((String)hexColor).matches("#[0-9A-Fa-f]{6}")) {
                try {
                    int r = Integer.parseInt(((String)hexColor).substring(1, 3), 16);
                    int g = Integer.parseInt(((String)hexColor).substring(3, 5), 16);
                    int b = Integer.parseInt(((String)hexColor).substring(5, 7), 16);
                    int color = new Color(r, g, b).getRGB();
                    context.method_25294(this.colorPreviewX - 1, this.colorPreviewY - 1, this.colorPreviewX + this.colorPreviewSize + 1, this.colorPreviewY + this.colorPreviewSize + 1, -16777216);
                    context.method_25294(this.colorPreviewX, this.colorPreviewY, this.colorPreviewX + this.colorPreviewSize, this.colorPreviewY + this.colorPreviewSize, color);
                }
                catch (Exception e) {
                    context.method_25294(this.colorPreviewX, this.colorPreviewY, this.colorPreviewX + this.colorPreviewSize, this.colorPreviewY + this.colorPreviewSize, -65536);
                }
            } else {
                context.method_25294(this.colorPreviewX, this.colorPreviewY, this.colorPreviewX + this.colorPreviewSize, this.colorPreviewY + this.colorPreviewSize, 0x77FFFFFF);
            }
        }
        int y = 220;
        int maxToShow = Math.min(5, this.albums.size() - this.scrollOffset);
        for (int i = 0; i < maxToShow; ++i) {
            int albumIndex = i + this.scrollOffset;
            Album album = this.albums.get(albumIndex);
            boolean isSelected = albumIndex == this.selectedAlbumIndex;
            int bgColor = isSelected ? -2139062144 : 0x20808080;
            context.method_25294(this.field_22789 / 2 - 100, y, this.field_22789 / 2 + 100, y + 20, bgColor);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)album.getTitle()), this.field_22789 / 2 - 95, y + 6, 0xFFFFFF);
            try {
                int colorInt = Integer.parseInt(album.getColor().substring(1), 16);
                context.method_25294(this.field_22789 / 2 + 70, y + 2, this.field_22789 / 2 + 95, y + 18, 0xFF000000 | colorInt);
            }
            catch (Exception e) {
                context.method_25294(this.field_22789 / 2 + 70, y + 2, this.field_22789 / 2 + 95, y + 18, -65536);
            }
            y += 25;
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int centerX = this.field_22789 / 2;
        int listStartY = 225;
        int albumListHeight = 200;
        int listEndY = listStartY + albumListHeight;
        if (mouseX >= (double)(centerX - 100) && mouseX <= (double)(centerX + 110) && mouseY >= (double)listStartY && mouseY <= (double)listEndY) {
            this.scrollOffset = 0;
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.field_22789 / 2.0 - 100.0 && mouseX <= (double)this.field_22789 / 2.0 + 100.0) {
            int y = 220;
            int maxToShow = Math.min(5, this.albums.size() - this.scrollOffset);
            for (int i = 0; i < maxToShow; ++i) {
                if (mouseY >= (double)y && mouseY <= (double)(y + 20)) {
                    this.selectedAlbumIndex = i + this.scrollOffset;
                    Album selected = this.albums.get(this.selectedAlbumIndex);
                    this.titleField.method_1852(selected.getTitle());
                    this.colorField.method_1852(selected.getColor());
                    this.descriptionField.method_1852(selected.getDescription());
                    this.coverScreenshotField.method_1852(selected.getCoverScreenshotName());
                    this.addButton.method_25355((class_2561)class_2561.method_43470((String)"Update Album"));
                    return true;
                }
                y += 25;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean validateInputs() {
        boolean valid;
        boolean bl = valid = !this.titleField.method_1882().trim().isEmpty();
        if (!this.colorPattern.matcher(this.colorField.method_1882()).matches()) {
            valid = false;
        }
        return valid;
    }

    private void clearInputFields() {
        this.titleField.method_1852("");
        this.colorField.method_1852("#");
        this.descriptionField.method_1852("");
        this.coverScreenshotField.method_1852("");
        this.selectedAlbumIndex = -1;
        this.addButton.method_25355((class_2561)class_2561.method_43470((String)"Add Album"));
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

