/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import de.thecoolcraft11.config.AlbumManager;
import de.thecoolcraft11.config.data.Album;
import de.thecoolcraft11.screen.AlbumConfigScreen;
import de.thecoolcraft11.screen.GalleryScreen;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlbumScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(AlbumScreen.class);
    private static final int ALBUMS_PER_ROW = 3;
    private static int ALBUM_WIDTH = 220;
    private static int ALBUM_HEIGHT = 150;
    private static int GAP = 20;
    private static int TOP_PADDING = 40;
    private static final class_2960 FOLDER_ICON = class_2960.method_60655((String)"screenshot-uploader", (String)"textures/gui/album_screen/folder_icon.png");
    private static final class_2960 FOLDER_ICON_COVER = class_2960.method_60655((String)"screenshot-uploader", (String)"textures/gui/album_screen/folder_icon_cover.png");
    private final List<Album> albums = new ArrayList<Album>();
    private final Map<String, class_2960> coverImageIds = new HashMap<String, class_2960>();
    private int scrollOffset = 0;
    private static class_437 parent;

    public AlbumScreen(class_437 passedParent) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_screen.title"));
        parent = passedParent;
    }

    protected void method_25426() {
        super.method_25426();
        this.albums.clear();
        this.coverImageIds.clear();
        this.scrollOffset = 0;
        this.albums.addAll(AlbumManager.getAllAlbums());
        int scaledHeight = this.field_22790 / 6;
        int scaledWidth = scaledHeight * 16 / 9;
        int scaledGap = scaledHeight / 10;
        TOP_PADDING = this.field_22790 / 20;
        ALBUM_WIDTH = scaledWidth;
        ALBUM_HEIGHT = scaledHeight;
        GAP = scaledGap;
        int buttonWidth = this.field_22789 / 8;
        int buttonHeight = this.field_22790 / 25;
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_screen.back"), button -> {
            if (this.field_22787 != null) {
                class_437 patt0$temp = parent;
                if (patt0$temp instanceof GalleryScreen) {
                    GalleryScreen galleryScreen = (GalleryScreen)patt0$temp;
                    galleryScreen.cancelAllAsyncTasks();
                }
                this.field_22787.method_1507((class_437)new GalleryScreen());
            }
        }).method_46434(5, 5, buttonWidth, buttonHeight).method_46431();
        class_4185 configButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.album_screen.album_config"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new AlbumConfigScreen(this));
            }
        }).method_46434(10 + buttonWidth, 5, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)backButton);
        this.method_37063((class_364)configButton);
        this.loadCoverImagesAsync();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        class_5250 title = class_2561.method_43471((String)"gui.screenshot_uploader.album_screen.title");
        context.method_27534(this.field_22793, (class_2561)title, this.field_22789 / 2, 10, 0xFFFFFF);
        int startX = (this.field_22789 - (3 * ALBUM_WIDTH + 2 * GAP)) / 2 + 25;
        int y = TOP_PADDING - this.scrollOffset + 15;
        int albumIndex = 0;
        for (Album album : this.albums) {
            int row = albumIndex / 3;
            int col = albumIndex % 3;
            int x = startX + col * (ALBUM_WIDTH + GAP);
            int albumY = y + row * (ALBUM_HEIGHT + GAP);
            if (albumY + ALBUM_HEIGHT >= 0 && albumY <= this.field_22790) {
                this.renderAlbum(context, album, x, albumY, mouseX, mouseY);
            }
            ++albumIndex;
        }
    }

    private void renderAlbum(class_332 context, Album album, int x, int y, int mouseX, int mouseY) {
        boolean isHovering;
        int color = -13421773;
        try {
            color = Integer.parseInt(album.getColor().replace("#", ""), 16) | 0xFF000000;
        }
        catch (NumberFormatException e) {
            logger.error("Invalid color format for album: {}", (Object)album.getTitle());
        }
        int iconSizeOffset = (int)((double)Math.min(ALBUM_WIDTH, ALBUM_HEIGHT) * 0.7);
        int iconSize = Math.min(ALBUM_WIDTH, ALBUM_HEIGHT) + iconSizeOffset;
        int iconX = x + (ALBUM_WIDTH - iconSize) / 2;
        int iconY = y + (ALBUM_HEIGHT - iconSize) / 2;
        context.method_25291(class_1921::method_62277, FOLDER_ICON, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, color);
        class_2960 coverId = this.coverImageIds.get(album.getCoverScreenshotName());
        if (coverId != null) {
            int coverWidth = (int)((double)ALBUM_WIDTH * 0.65);
            int coverHeight = (int)((double)ALBUM_HEIGHT * 0.65);
            int coverOffsetX = (int)((double)ALBUM_WIDTH * 0.15);
            int coverOffsetY = (int)((double)ALBUM_HEIGHT * 0.12);
            int coverX = x + (ALBUM_WIDTH - coverWidth) / 2 + coverOffsetX;
            int coverY = y + (ALBUM_HEIGHT - coverHeight) / 2 - coverOffsetY;
            context.method_25290(class_1921::method_62277, coverId, coverX, coverY, 0.0f, 0.0f, coverWidth, coverHeight, coverWidth, coverHeight);
        }
        boolean bl = isHovering = mouseX >= x && mouseX <= x + ALBUM_WIDTH && mouseY >= y && mouseY <= y + ALBUM_HEIGHT;
        if (!isHovering) {
            context.method_25291(class_1921::method_62277, FOLDER_ICON_COVER, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, color);
        }
        int titleX = x + 5;
        Objects.requireNonNull(this.field_22793);
        int titleY = y + ALBUM_HEIGHT - 9 - 5;
        int n = titleX + this.field_22793.method_1727(album.getTitle()) + 2;
        Objects.requireNonNull(this.field_22793);
        context.method_25294(titleX - 2, titleY - 2, n, titleY + 9 + 2, Integer.MIN_VALUE);
        context.method_51433(this.field_22793, album.getTitle(), titleX, titleY, 0xFFFFFF, false);
        if (isHovering) {
            context.method_25294(x, y, x + ALBUM_WIDTH, y + ALBUM_HEIGHT, 0x40FFFFFF);
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43470((String)album.getTitle()).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
            if (album.getDescription() != null && !album.getDescription().isEmpty()) {
                tooltipLines.add(class_2561.method_43470((String)album.getDescription()).method_27692(class_124.field_1080));
            }
            context.method_51434(this.field_22793, tooltipLines, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int startX = (this.field_22789 - (3 * ALBUM_WIDTH + 2 * GAP)) / 2;
        int y = TOP_PADDING - this.scrollOffset;
        int albumIndex = 0;
        for (Album album : this.albums) {
            int row = albumIndex / 3;
            int col = albumIndex % 3;
            int x = startX + col * (ALBUM_WIDTH + GAP);
            int albumY = y + row * (ALBUM_HEIGHT + GAP);
            if (mouseX >= (double)x && mouseX <= (double)(x + ALBUM_WIDTH) && mouseY >= (double)albumY && mouseY <= (double)(albumY + ALBUM_HEIGHT)) {
                if (this.field_22787 != null) {
                    class_437 class_4372 = parent;
                    if (class_4372 instanceof GalleryScreen) {
                        GalleryScreen galleryScreen = (GalleryScreen)class_4372;
                        galleryScreen.cancelAllAsyncTasks();
                    }
                    this.field_22787.method_1507((class_437)new GalleryScreen(album.getUuid()));
                }
                return true;
            }
            ++albumIndex;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxRows;
        int maxScroll;
        this.scrollOffset -= (int)(verticalAmount * 20.0);
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.scrollOffset > (maxScroll = (maxRows = (this.albums.size() + 3 - 1) / 3) * (ALBUM_HEIGHT + GAP) - (this.field_22790 - TOP_PADDING)) && maxScroll > 0) {
            this.scrollOffset = maxScroll;
        }
        return true;
    }

    private void loadCoverImagesAsync() {
        if (this.field_22787 == null) {
            return;
        }
        for (Album album : this.albums) {
            Path screenshotPath;
            File file;
            String coverName = album.getCoverScreenshotName();
            if (coverName == null || coverName.isEmpty() || !(file = (screenshotPath = Paths.get(System.getProperty("user.dir"), "screenshots", coverName)).toFile()).exists()) continue;
            CompletableFuture.runAsync(() -> {
                try {
                    class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                    class_310.method_1551().execute(() -> {
                        class_1043 texture = new class_1043(String::new, image);
                        class_310.method_1551().method_1531().method_4616(class_2960.method_60654((String)("album_cover/" + album.getUuid().toString())), (class_1044)texture);
                        class_2960 id = class_2960.method_60654((String)("album_cover/" + album.getUuid().toString()));
                        this.coverImageIds.put(coverName, id);
                    });
                }
                catch (IOException e) {
                    logger.error("Failed to load cover image for album: {}", (Object)album.getTitle(), (Object)e);
                }
            });
        }
    }
}

