/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1268;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2877;
import net.minecraft.class_2885;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3965;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_7919;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSignEditScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(CustomSignEditScreen.class);
    private final class_2625 sign;
    private static class_2960 screenshotIdentifier;
    class_342 urlField;
    private class_342 xOffsetField;
    private class_342 yOffsetField;
    private class_342 zOffsetField;
    private class_342 yawField;
    private class_342 pitchField;
    private class_342 sizeField;
    private class_342 lightField;
    private class_342 itemField;
    private boolean showTransformSettings = false;
    private class_4185 applyButton;
    public static int customEditsLeft;
    private static int lastUrlHash;
    private long lastTypingTime = 0L;
    private static final int TYPING_TIMEOUT_MS = 800;
    private String scheduledImageUrl = null;
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;
    private float zOffset = 0.0f;
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private float size = 1.0f;
    private int light = 255;
    private String item = "$painting";

    public CustomSignEditScreen(class_2625 sign) {
        super(class_2561.method_30163((String)"Sign"));
        this.sign = sign;
        String signText = this.extractSignText(sign);
        if (!signText.isEmpty()) {
            this.parseTransformationFromUrl(signText);
        }
    }

    private String extractSignText(class_2625 sign) {
        int i;
        StringBuilder text = new StringBuilder();
        for (i = 0; i < 4; ++i) {
            text.append(sign.method_49853().method_49859(i, false).getString());
        }
        for (i = 0; i < 4; ++i) {
            text.append(sign.method_49854().method_49859(i, false).getString());
        }
        return text.toString();
    }

    private void parseTransformationFromUrl(String url) {
        String urlPattern = "(https?://[\\w.-]+(?::\\d+)?(?:/[\\w.-]*)*)(\\[-?\\d+(?:[.,]\\d+)?(?:[;,:_+-]-?[a-zA-Z0-9$]+(?:[.:,_+-]\\d+)?)*?])?";
        Pattern pattern = Pattern.compile(urlPattern);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find() && matcher.group(2) != null && !matcher.group(2).isEmpty()) {
            String transformStr = matcher.group(2);
            transformStr = transformStr.substring(1, transformStr.length() - 1);
            String[] parts = transformStr.split("[;,]");
            try {
                if (parts.length >= 1) {
                    this.xOffset = Float.parseFloat(parts[0]);
                }
                if (parts.length >= 2) {
                    this.yOffset = Float.parseFloat(parts[1]);
                }
                if (parts.length >= 3) {
                    this.zOffset = Float.parseFloat(parts[2]);
                }
                if (parts.length >= 4) {
                    this.yaw = Float.parseFloat(parts[3]);
                }
                if (parts.length >= 5) {
                    this.pitch = Float.parseFloat(parts[4]);
                }
                if (parts.length >= 6) {
                    this.size = Float.parseFloat(parts[5]);
                }
                if (parts.length >= 7) {
                    this.light = Integer.parseInt(parts[6]);
                }
                if (parts.length >= 8) {
                    this.item = parts[7];
                }
            }
            catch (NumberFormatException e) {
                logger.error("Error parsing transformation values", (Throwable)e);
            }
        }
    }

    protected void method_25426() {
        screenshotIdentifier = null;
        lastUrlHash = 0;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int buttonX = (this.field_22789 - buttonWidth) / 2;
        int buttonY = this.field_22790 / 2 + this.field_22790 / 4;
        int textFieldWidth = this.field_22789 / 3;
        int textFieldX = (this.field_22789 - textFieldWidth) / 2;
        int textFieldY = this.field_22790 / 2 + this.field_22790 / 8;
        this.urlField = new class_342(this.field_22793, textFieldX, textFieldY, textFieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.urlField.method_1880(120);
        this.method_37063((class_364)this.urlField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_sign.set_text"), buttonWidget -> this.pasteTextToSign()).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_sign.tooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_sign.close"), buttonWidget -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(null);
            }
        }).method_46434(buttonX, buttonY + buttonHeight + 5, buttonWidth, buttonHeight).method_46431());
        class_4185 transformButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_settings"), button -> this.toggleTransformSettings()).method_46434(buttonX, buttonY - buttonHeight - 5, buttonWidth, buttonHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_settings.tooltip"))).method_46431();
        this.method_37063((class_364)transformButton);
        this.initTransformFields();
        this.updateTransformFieldsVisibility();
        super.method_25426();
    }

    private void initTransformFields() {
        int smallFieldWidth = 50;
        int mediumFieldWidth = 120;
        int fieldHeight = 20;
        int spacing = 5;
        int startX = (int)((double)this.field_22789 * 0.85);
        int startY = this.field_22790 / 4;
        int buttonY = this.field_22790 / 2 + this.field_22790 / 4;
        this.xOffsetField = this.createNumberField(startX, startY, smallFieldWidth, String.valueOf(this.xOffset));
        this.xOffsetField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.x_offset")));
        this.yOffsetField = this.createNumberField(startX, startY + fieldHeight + spacing, smallFieldWidth, String.valueOf(this.yOffset));
        this.yOffsetField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.y_offset")));
        this.zOffsetField = this.createNumberField(startX, startY + 2 * (fieldHeight + spacing), smallFieldWidth, String.valueOf(this.zOffset));
        this.zOffsetField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.z_offset")));
        this.yawField = this.createNumberField(startX, startY + 3 * (fieldHeight + spacing), smallFieldWidth, String.valueOf(this.yaw));
        this.yawField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.yaw_rotation")));
        this.pitchField = this.createNumberField(startX, startY + 4 * (fieldHeight + spacing), smallFieldWidth, String.valueOf(this.pitch));
        this.pitchField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.pitch_rotation")));
        this.sizeField = this.createNumberField(startX, startY + 5 * (fieldHeight + spacing), smallFieldWidth, String.valueOf(this.size));
        this.sizeField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.size")));
        this.lightField = this.createNumberField(startX, startY + 6 * (fieldHeight + spacing), smallFieldWidth, String.valueOf(this.light));
        this.lightField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.light")));
        this.itemField = new class_342(this.field_22793, startX, startY + 7 * (fieldHeight + spacing), mediumFieldWidth, fieldHeight, (class_2561)class_2561.method_43470((String)""));
        this.itemField.method_1852(this.item);
        this.itemField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.item")));
        int buttonHeight = 20;
        this.applyButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.apply_trans"), button -> this.applyTransformSettings()).method_46434(startX - 25, buttonY + buttonHeight + 5, 100, buttonHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.apply_trans.tooltip"))).method_46431();
        this.method_37063((class_364)this.xOffsetField);
        this.method_37063((class_364)this.yOffsetField);
        this.method_37063((class_364)this.zOffsetField);
        this.method_37063((class_364)this.yawField);
        this.method_37063((class_364)this.pitchField);
        this.method_37063((class_364)this.sizeField);
        this.method_37063((class_364)this.lightField);
        this.method_37063((class_364)this.itemField);
        this.method_37063((class_364)this.applyButton);
    }

    private class_342 createNumberField(int x, int y, int width, String initialValue) {
        class_342 field = new class_342(this.field_22793, x, y, width, 20, (class_2561)class_2561.method_43470((String)""));
        field.method_1852(initialValue);
        field.method_1890(text -> text.isEmpty() || text.matches("-?\\d*\\.?\\d*"));
        return field;
    }

    private void updateTransformFieldsVisibility() {
        this.xOffsetField.method_1862(this.showTransformSettings);
        this.yOffsetField.method_1862(this.showTransformSettings);
        this.zOffsetField.method_1862(this.showTransformSettings);
        this.yawField.method_1862(this.showTransformSettings);
        this.pitchField.method_1862(this.showTransformSettings);
        this.sizeField.method_1862(this.showTransformSettings);
        this.lightField.method_1862(this.showTransformSettings);
        this.itemField.method_1862(this.showTransformSettings);
        this.applyButton.field_22764 = this.showTransformSettings;
    }

    private void toggleTransformSettings() {
        this.showTransformSettings = !this.showTransformSettings;
        this.updateTransformFieldsVisibility();
    }

    private void pasteTextToSign() {
        customEditsLeft = 2;
        String[] splitStrings = CustomSignEditScreen.splitIntoChunks(this.urlField.method_1882(), 15, 8);
        String[] strings = new String[8];
        for (int i = 0; i < 8 && i < splitStrings.length; ++i) {
            strings[i] = splitStrings[i];
        }
        if (this.field_22787 != null) {
            class_634 clientPlayNetworkHandler = this.field_22787.method_1562();
            if (clientPlayNetworkHandler != null) {
                clientPlayNetworkHandler.method_52787((class_2596)new class_2885(class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)this.sign.method_11016()), class_2350.field_11036, this.sign.method_11016(), false), 0));
                clientPlayNetworkHandler.method_52787((class_2596)new class_2877(this.sign.method_11016(), true, strings[0], strings[1], strings[2], strings[3]));
                this.field_22787.method_1507(null);
                clientPlayNetworkHandler.method_52787((class_2596)new class_2885(class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)this.sign.method_11016()), class_2350.field_11036, this.sign.method_11016(), false), 0));
                clientPlayNetworkHandler.method_52787((class_2596)new class_2877(this.sign.method_11016(), false, strings[4], strings[5], strings[6], strings[7]));
            }
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.field_22787.method_1507(null);
            });
        }
    }

    public static String[] splitIntoChunks(String input, int chunkSize, int maxChunks) {
        String[] result = new String[maxChunks];
        int length = input.length();
        for (int i = 0; i < maxChunks; ++i) {
            int start = i * chunkSize;
            int end = Math.min(start + chunkSize, length);
            result[i] = start < length ? input.substring(start, end) : "";
        }
        return result;
    }

    private static void loadWebImage(String imageUrl) {
        boolean imageLoaded;
        block54: {
            String urlPattern = "(https?://[\\w.-]+(?::\\d+)?(?:/[\\w.-]*)*)(\\[-?\\d+(?:[.,]\\d+)?(?:[;,:_+-]-?[a-zA-Z0-9$]+(?:[.:,_+-]\\d+)?)*?])?";
            Pattern pattern = Pattern.compile(urlPattern);
            Matcher matcher = pattern.matcher(imageUrl);
            if (!matcher.matches()) {
                screenshotIdentifier = null;
                return;
            }
            imageUrl = matcher.group(1);
            try {
                String redirectUrl;
                URL urlObj = new URI(imageUrl).toURL();
                HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
                connection.setRequestProperty("User-Agent", "ScreenshotUploader/2.0");
                connection.setInstanceFollowRedirects(false);
                connection.setRequestMethod("HEAD");
                connection.setConnectTimeout(3000);
                connection.setReadTimeout(3000);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (!(responseCode != 302 && responseCode != 301 && responseCode != 303 || (redirectUrl = connection.getHeaderField("Location")) == null || redirectUrl.isEmpty())) {
                    logger.info("Following redirect: {} -> {}", (Object)imageUrl, (Object)redirectUrl);
                    imageUrl = redirectUrl;
                }
            }
            catch (Exception e) {
                logger.error("Failed to resolve URL: {}", (Object)e.getMessage());
            }
            lastUrlHash = imageUrl.hashCode();
            String cacheFileName = "screenshots_cache/" + imageUrl.hashCode() + ".png";
            File cachedImage = new File(cacheFileName);
            imageLoaded = false;
            if (cachedImage.exists()) {
                try (InputStream fileInputStream = Files.newInputStream(cachedImage.toPath(), new OpenOption[0]);
                     class_1011 loadedImage = class_1011.method_4309((InputStream)fileInputStream);){
                    class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                    if (class_310.method_1551() != null) {
                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, loadedImage));
                        screenshotIdentifier = textureId;
                        imageLoaded = true;
                    }
                }
                catch (IOException ignored) {
                    screenshotIdentifier = null;
                }
            }
            if (!imageLoaded) {
                try {
                    URI uri = new URI(imageUrl);
                    if (!uri.isAbsolute()) {
                        screenshotIdentifier = null;
                        return;
                    }
                    URL url = uri.toURL();
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("User-Agent", "ScreenshotUploader/2.0");
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    connection.connect();
                    if (connection.getResponseCode() != 200) break block54;
                    try (InputStream inputStream = connection.getInputStream();){
                        BufferedImage bufferedImage = ImageIO.read(inputStream);
                        if (bufferedImage != null) {
                            File cacheFolder = new File("screenshots_cache");
                            if (!cacheFolder.exists() && cacheFolder.mkdirs()) {
                                logger.info("Created web screenshots cache folder");
                            }
                            ImageIO.write((RenderedImage)bufferedImage, "PNG", cachedImage);
                            try (class_1011 nativeImage = new class_1011(bufferedImage.getWidth(), bufferedImage.getHeight(), false);){
                                for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                                    for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                                        int rgb = bufferedImage.getRGB(x, y);
                                        int alpha = rgb >> 24 & 0xFF;
                                        int red = rgb >> 16 & 0xFF;
                                        int green = rgb >> 8 & 0xFF;
                                        int blue = rgb & 0xFF;
                                        int argb = alpha << 24 | red << 16 | green << 8 | blue;
                                        nativeImage.method_61941(x, y, argb);
                                    }
                                }
                                try (InputStream fileInputStream = Files.newInputStream(cachedImage.toPath(), new OpenOption[0]);
                                     class_1011 loadedImage = class_1011.method_4309((InputStream)fileInputStream);){
                                    class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                                    if (class_310.method_1551() != null) {
                                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, loadedImage));
                                        screenshotIdentifier = textureId;
                                        imageLoaded = true;
                                    }
                                    break block54;
                                }
                            }
                        }
                        screenshotIdentifier = null;
                    }
                }
                catch (IOException | URISyntaxException ignored) {
                    screenshotIdentifier = null;
                }
            }
        }
        if (!imageLoaded) {
            screenshotIdentifier = null;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        long currentTime;
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.showTransformSettings) {
            int labelColor = -1;
            int startX = (int)((double)this.field_22789 * 0.85) - 20;
            int startY = this.field_22790 / 4;
            int fieldHeight = 20;
            int spacing = 5;
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_x"), startX - 15, startY + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_y"), startX - 15, startY + (fieldHeight + spacing) + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_z"), startX - 15, startY + 2 * (fieldHeight + spacing) + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_yaw"), startX - 15, startY + 3 * (fieldHeight + spacing) + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_pitch"), startX - 15, startY + 4 * (fieldHeight + spacing) + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_size"), startX - 15, startY + 5 * (fieldHeight + spacing) + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_light"), startX - 15, startY + 6 * (fieldHeight + spacing) + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_item"), startX - 15, startY + 7 * (fieldHeight + spacing) + 5, labelColor, false);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.sign_edit.trans_settings"), (int)((double)this.field_22789 * 0.85) - 60, startY - 20, -256, false);
        }
        if (this.scheduledImageUrl != null && (currentTime = System.currentTimeMillis()) - this.lastTypingTime > 800L) {
            if (this.scheduledImageUrl.trim().length() < 5) {
                screenshotIdentifier = null;
                lastUrlHash = 0;
            } else if (lastUrlHash != this.scheduledImageUrl.hashCode()) {
                CustomSignEditScreen.loadWebImage(this.scheduledImageUrl);
            }
            this.scheduledImageUrl = null;
        }
        if (screenshotIdentifier != null) {
            this.renderEnlargedImage(context);
        }
    }

    private void renderEnlargedImage(class_332 context) {
        class_2960 clickedImageId = screenshotIdentifier;
        int imageWidth = this.field_22789 / 4;
        int imageHeight = this.field_22790 / 4;
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 8.0);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 8.0);
        }
        int x = (this.field_22789 - imageWidth) / 2;
        int y = (this.field_22790 - imageHeight) / 3;
        int borderWidth = 5;
        context.method_25294(x - borderWidth, y - borderWidth, x + imageWidth + borderWidth, y + imageHeight + borderWidth, -1);
        context.method_25290(class_1921::method_62277, clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
    }

    private void applyTransformSettings() {
        try {
            this.xOffset = this.parseFloatOrDefault(this.xOffsetField.method_1882(), 0.0f);
            this.yOffset = this.parseFloatOrDefault(this.yOffsetField.method_1882(), 0.0f);
            this.zOffset = this.parseFloatOrDefault(this.zOffsetField.method_1882(), 0.0f);
            this.yaw = this.parseFloatOrDefault(this.yawField.method_1882(), 0.0f);
            this.pitch = this.parseFloatOrDefault(this.pitchField.method_1882(), 0.0f);
            this.size = this.parseFloatOrDefault(this.sizeField.method_1882(), 0.75f);
            this.light = (int)this.parseFloatOrDefault(this.lightField.method_1882(), 1.572888E7f);
            this.item = this.itemField.method_1882().isEmpty() ? "$painting" : this.itemField.method_1882();
            String transformString = "[" + this.formatNumber(this.xOffset) + ";" + this.formatNumber(this.yOffset) + ";" + this.formatNumber(this.zOffset) + ";" + this.formatNumber(this.yaw) + ";" + this.formatNumber(this.pitch) + ";" + this.formatNumber(this.size) + ";" + this.light + ";" + this.item + "]";
            String baseUrl = this.extractBaseUrl(this.urlField.method_1882());
            String newUrl = baseUrl + transformString;
            this.urlField.method_1852(newUrl);
            this.scheduleImageLoad(newUrl);
            this.showTransformSettings = false;
            this.updateTransformFieldsVisibility();
        }
        catch (Exception e) {
            logger.error("Failed to apply transformation settings", (Throwable)e);
        }
    }

    private String formatNumber(float number) {
        if (number == (float)((int)number)) {
            return Integer.toString((int)number);
        }
        return Float.toString(number);
    }

    private String extractBaseUrl(String fullUrl) {
        String urlPattern = "(https?://[\\w.-]+(?::\\d+)?(?:/[\\w.-]*)*)(?:\\[.*])?";
        Pattern pattern = Pattern.compile(urlPattern);
        Matcher matcher = pattern.matcher(fullUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return fullUrl;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.showTransformSettings) {
            if (this.xOffsetField.method_25370() && this.xOffsetField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.yOffsetField.method_25370() && this.yOffsetField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.zOffsetField.method_25370() && this.zOffsetField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.yawField.method_25370() && this.yawField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.pitchField.method_25370() && this.pitchField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.sizeField.method_25370() && this.sizeField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.lightField.method_25370() && this.lightField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.itemField.method_25370() && this.itemField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (this.urlField.method_25404(keyCode, scanCode, modifiers)) {
            this.scheduleImageLoad(this.urlField.method_1882());
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int keyCode) {
        if (this.showTransformSettings) {
            if (this.xOffsetField.method_25370() && this.xOffsetField.method_25400(chr, keyCode)) {
                return true;
            }
            if (this.yOffsetField.method_25370() && this.yOffsetField.method_25400(chr, keyCode)) {
                return true;
            }
            if (this.zOffsetField.method_25370() && this.zOffsetField.method_25400(chr, keyCode)) {
                return true;
            }
            if (this.yawField.method_25370() && this.yawField.method_25400(chr, keyCode)) {
                return true;
            }
            if (this.pitchField.method_25370() && this.pitchField.method_25400(chr, keyCode)) {
                return true;
            }
            if (this.sizeField.method_25370() && this.sizeField.method_25400(chr, keyCode)) {
                return true;
            }
            if (this.lightField.method_25370() && this.lightField.method_25400(chr, keyCode)) {
                return true;
            }
            if (this.itemField.method_25370() && this.itemField.method_25400(chr, keyCode)) {
                return true;
            }
        }
        if (this.urlField.method_25400(chr, keyCode)) {
            this.scheduleImageLoad(this.urlField.method_1882());
            return true;
        }
        return super.method_25400(chr, keyCode);
    }

    private void scheduleImageLoad(String url) {
        this.lastTypingTime = System.currentTimeMillis();
        this.scheduledImageUrl = url;
    }

    private float parseFloatOrDefault(String value, float defaultValue) {
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static {
        customEditsLeft = 0;
        lastUrlHash = 0;
    }
}

