/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.thecoolcraft11.config.AlbumManager;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.config.data.Album;
import de.thecoolcraft11.screen.AlbumScreen;
import de.thecoolcraft11.screen.ConfigScreen;
import de.thecoolcraft11.screen.EditScreen;
import de.thecoolcraft11.screen.LikedScreenshotsScreen;
import de.thecoolcraft11.screen.ScreenshotStatisticsScreen;
import de.thecoolcraft11.screen.ScreenshotTaggingScreen;
import de.thecoolcraft11.screen.SelectAlbumScreen;
import de.thecoolcraft11.screen.UploadToServerScreen;
import de.thecoolcraft11.screen.WebGalleryScreen;
import de.thecoolcraft11.util.ReceivePackets;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleryScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(GalleryScreen.class);
    private static final List<class_2960> imageIds = new ArrayList<class_2960>();
    private static final List<Path> imagePaths = new ArrayList<Path>();
    private static final List<JsonObject> metaDatas = new ArrayList<JsonObject>();
    private static final int IMAGES_PER_ROW = ConfigManager.getClientConfig().imagesPerRow;
    private static int IMAGE_WIDTH = 192;
    private static int IMAGE_HEIGHT = 108;
    private static int GAP = ConfigManager.getClientConfig().imageGap;
    private static int TOP_PADDING = ConfigManager.getClientConfig().imageTopPadding;
    private static boolean isImageClicked = false;
    private static int clickedImageIndex = -1;
    private int scrollOffset;
    private double zoomLevel = 2.0;
    private double imageOffsetX = 0.0;
    private double imageOffsetY = 0.0;
    private class_4185 saveButton;
    private class_4185 deleteButton;
    private class_4185 openInAppButton;
    private class_4185 editButton;
    private static class_4185 likeButton;
    private class_4185 sortByButton;
    private class_4185 sortOrderButton;
    private class_4185 addToAlbumButton;
    private class_4185 viewTagsButton;
    private class_4185 configButton;
    private class_342 searchField;
    private class_4185 albumConfigButton;
    private class_4185 screenshotStatisticsButton;
    private class_4185 uploadToServerButton;
    private class_4185 likedScreenshotsButton;
    private final List<Path> originalImagePaths = new ArrayList<Path>();
    private String lastSearchQuery = "";
    private Runnable searchDebounceTask = null;
    private static final String FILE_PATH = "./config/screenshotUploader/data/local.json";
    private static final LinkedHashMap<String, Boolean> likedScreenshots;
    private final List<class_4185> navigatorButtons = new ArrayList<class_4185>();
    private final List<class_4185> buttonsToHideOnOverlap = new ArrayList<class_4185>();
    private SortBy sortBy = SortBy.DEFAULT;
    private SortOrder sortOrder = SortOrder.ASCENDING;
    private static UUID albumUUID;
    private static final List<Path> newScreenshots;
    private int starY = 0;
    private boolean goingUp = true;
    private CompletableFuture<?> asyncSortFuture;
    private final AtomicInteger sortTaskId = new AtomicInteger();

    public GalleryScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.title"));
        albumUUID = null;
        this.initializeScreen();
    }

    public GalleryScreen(UUID passedAlbumUUID) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.title"));
        albumUUID = passedAlbumUUID;
        this.initializeScreen();
    }

    public static void addNewScreenshot(Path newScreenshot) {
        newScreenshots.add(newScreenshot);
    }

    public static void removeNewScreenshot(Path path) {
        newScreenshots.remove(path);
    }

    public static List<Path> getNewScreenshots() {
        return newScreenshots;
    }

    private void initializeScreen() {
        imageIds.clear();
        imagePaths.clear();
        this.navigatorButtons.clear();
        metaDatas.clear();
        this.originalImagePaths.clear();
        clickedImageIndex = -1;
        isImageClicked = false;
        this.scrollOffset = 0;
        likedScreenshots.clear();
        this.cancelAllAsyncTasks();
        this.sortTaskId.incrementAndGet();
        if (this.asyncSortFuture != null && !this.asyncSortFuture.isDone()) {
            this.asyncSortFuture.cancel(true);
        }
        if (this.searchDebounceTask != null) {
            class_310.method_1551().method_63588(() -> {
                this.searchDebounceTask = null;
            });
        }
        this.sortTaskId.incrementAndGet();
    }

    protected void method_25426() {
        super.method_25426();
        GAP = ConfigManager.getClientConfig().imageGap;
        TOP_PADDING = ConfigManager.getClientConfig().imageTopPadding;
        int scaledHeight = this.field_22790 / 6;
        int scaledWidth = scaledHeight * 16 / 9;
        int scaledGap = scaledHeight / 10;
        TOP_PADDING = this.field_22790 / 20 + TOP_PADDING;
        IMAGE_WIDTH = scaledWidth;
        IMAGE_HEIGHT = scaledHeight;
        GAP = scaledGap;
        if (class_310.method_1551() != null) {
            class_310.method_1551().execute(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.initializeScreen();
            });
        }
        if (class_310.method_1551() != null) {
            class_310.method_1551().execute(() -> {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.loadAllImagesAsync();
            });
        }
        int buttonWidth = this.field_22789 / 8;
        int buttonHeight = this.field_22790 / 25;
        int buttonSpacing = buttonWidth / 5;
        int xPosition = (this.field_22789 - (buttonWidth * (this.navigatorButtons.size() + 1) + buttonSpacing * (this.navigatorButtons.size() - 1))) / 5;
        int buttonY = (int)((double)this.field_22790 * 0.9);
        int navigatorY = (int)((double)this.field_22790 * 0.01);
        this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"), button -> {}).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
        xPosition += buttonWidth + buttonSpacing;
        if (ReceivePackets.gallerySiteAddress != null) {
            this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.server_gallery"), button -> {
                String webserverUrl = ReceivePackets.gallerySiteAddress;
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                } else {
                    logger.error("Failed to get client trying to open Server Gallery with URL {}", (Object)webserverUrl);
                }
            }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            xPosition += buttonWidth + buttonSpacing;
        }
        for (Map.Entry<String, Map<String, String>> entry : ConfigManager.getClientConfig().upload_urls.entrySet()) {
            String webserverUrl = entry.getValue().get("gallery");
            String buttonLabel = entry.getKey();
            this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonLabel), button -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                } else {
                    logger.error("Failed to get client trying to open Gallery for {}", (Object)webserverUrl);
                }
            }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            xPosition += buttonWidth + buttonSpacing;
        }
        this.navigatorButtons.forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        this.navigatorButtons.stream().filter(buttonWidget -> buttonWidget.method_25369().equals((Object)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"))).forEach(buttonWidget -> {
            buttonWidget.field_22763 = false;
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.save"), button -> this.saveImage()).method_46434(5, buttonY, buttonWidth, buttonHeight).method_46431();
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.delete"), button -> this.deleteImage()).method_46434(buttonWidth + 10, buttonY, buttonWidth, buttonHeight).method_46431();
        this.openInAppButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_app"), button -> this.openImageInApp()).method_46434(2 * buttonWidth + 15, buttonY, buttonWidth, buttonHeight).method_46431();
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.edit"), button -> {
            if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
                Path imagePath = imagePaths.get(clickedImageIndex - 1);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new EditScreen(this, imagePath, null, image -> {}));
                }
            }
        }).method_46434(3 * buttonWidth + 20, buttonY, buttonWidth, buttonHeight).method_46431();
        likeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.like_screenshot").method_54663(0x2A2A2A), button -> GalleryScreen.likeScreenshot()).method_46434(buttonWidth * 4 + 25, buttonY, 20, 20).method_46431();
        this.configButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.config"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ConfigScreen());
            }
        }).method_46434(5, 5, buttonWidth / 2, buttonHeight).method_46431();
        this.albumConfigButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.album_config"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new AlbumScreen(this));
            }
        }).method_46434(10 + buttonWidth / 2, 5, buttonWidth / 2, buttonHeight).method_46431();
        this.screenshotStatisticsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.local_statistics"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ScreenshotStatisticsScreen(this));
            }
        }).method_46434(5, 10 + buttonHeight, (int)((float)buttonWidth / 1.5f), buttonHeight).method_46431();
        this.sortByButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.sortBy.toString()), button -> {
            this.sortBy = SortBy.values()[(this.sortBy.ordinal() + 1) % SortBy.values().length];
            this.sortByButton.method_25355(class_2561.method_30163((String)this.sortBy.toString()));
            this.loadImageSorted(this.sortOrder, this.sortBy);
        }).method_46434(5, this.field_22790 - buttonHeight - 5, buttonWidth, buttonHeight).method_46431();
        this.sortOrderButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.sortOrder.toString()), button -> {
            this.sortOrder = SortOrder.values()[(this.sortOrder.ordinal() + 1) % SortOrder.values().length];
            this.sortOrderButton.method_25355(class_2561.method_30163((String)this.sortOrder.toString()));
            this.loadImageSorted(this.sortOrder, this.sortBy);
        }).method_46434(5 + buttonWidth + 5, this.field_22790 - buttonHeight - 5, buttonWidth, buttonHeight).method_46431();
        this.searchField = new class_342(this.field_22793, 5 + 2 * buttonWidth + 10, this.field_22790 - buttonHeight - 5, buttonWidth * 2, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.search"));
        this.searchField.method_1863(query -> {
            if (this.searchDebounceTask != null) {
                class_310.method_1551().method_63588(this.searchDebounceTask);
            }
            this.searchDebounceTask = () -> this.performSearch((String)query);
            class_310.method_1551().method_63588(this.searchDebounceTask);
        });
        this.addToAlbumButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.add_to_album"), button -> {
            if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
                Path imagePath = imagePaths.get(clickedImageIndex);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new SelectAlbumScreen(this, imagePath.toString()));
                }
            }
        }).method_46434(buttonWidth * 4 + 50, buttonY, buttonWidth, buttonHeight).method_46431();
        this.viewTagsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.view_tags"), button -> {
            String screenshotName = null;
            if (imagePaths.get(clickedImageIndex) != null) {
                screenshotName = imagePaths.get(clickedImageIndex).toString();
            }
            if (screenshotName != null && this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ScreenshotTaggingScreen(this, screenshotName));
            }
        }).method_46434(buttonWidth * 5 + 55, buttonY, buttonWidth, buttonHeight).method_46431();
        this.uploadToServerButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.upload_to_server"), button -> {
            if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
                Path imagePath = imagePaths.get(clickedImageIndex);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new UploadToServerScreen(this, imagePath.toAbsolutePath()));
                }
            }
        }).method_46434(buttonWidth * 6 + 60, buttonY, buttonWidth, buttonHeight).method_46431();
        this.likedScreenshotsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.liked_screenshots"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new LikedScreenshotsScreen(this));
            }
        }).method_46434(5, 15 + buttonHeight * 2, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.addToAlbumButton);
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.deleteButton);
        this.method_37063((class_364)this.openInAppButton);
        this.method_37063((class_364)this.configButton);
        this.method_37063((class_364)this.editButton);
        this.method_37063((class_364)likeButton);
        this.method_37063((class_364)this.sortByButton);
        this.method_37063((class_364)this.sortOrderButton);
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)this.viewTagsButton);
        this.method_37063((class_364)this.albumConfigButton);
        this.method_37063((class_364)this.screenshotStatisticsButton);
        this.method_37063((class_364)this.uploadToServerButton);
        this.method_37063((class_364)this.likedScreenshotsButton);
        this.saveButton.field_22764 = false;
        this.deleteButton.field_22764 = false;
        this.openInAppButton.field_22764 = false;
        this.editButton.field_22764 = false;
        this.configButton.field_22764 = true;
        GalleryScreen.likeButton.field_22764 = true;
        this.sortByButton.field_22764 = true;
        this.sortOrderButton.field_22764 = true;
        this.searchField.field_22764 = true;
        this.searchField.method_1880(128);
        this.searchField.method_47404((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.search_placeholder"));
        this.addToAlbumButton.field_22764 = false;
        this.albumConfigButton.field_22764 = true;
        this.screenshotStatisticsButton.field_22764 = true;
        this.uploadToServerButton.field_22764 = false;
        this.likedScreenshotsButton.field_22764 = true;
        this.buttonsToHideOnOverlap.add(this.saveButton);
        this.buttonsToHideOnOverlap.add(this.deleteButton);
        this.buttonsToHideOnOverlap.add(this.openInAppButton);
        this.buttonsToHideOnOverlap.add(this.editButton);
        this.buttonsToHideOnOverlap.add(likeButton);
        this.buttonsToHideOnOverlap.add(this.addToAlbumButton);
        this.buttonsToHideOnOverlap.add(this.viewTagsButton);
        this.buttonsToHideOnOverlap.add(this.uploadToServerButton);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (isImageClicked) {
                int imageWidth = (int)(1920.0 * this.zoomLevel);
                int imageHeight = (int)(1080.0 * this.zoomLevel);
                if (this.field_22787 != null) {
                    imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
                    imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
                }
                int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
                int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
                if (mouseX >= (double)x && mouseX <= (double)(x + imageWidth) && mouseY >= (double)y && mouseY <= (double)(y + imageHeight)) {
                    return false;
                }
                for (class_364 buttonWidget : this.method_25396()) {
                    if (buttonWidget == null || !buttonWidget.method_25405(mouseX, mouseY)) continue;
                    return super.method_25402(mouseX, mouseY, button);
                }
                isImageClicked = false;
                clickedImageIndex = -1;
                return true;
            }
            int totalImages = imageIds.size();
            for (int i = 0; i < totalImages; ++i) {
                int row = i / IMAGES_PER_ROW;
                int col = i % IMAGES_PER_ROW;
                int x = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2 + col * (IMAGE_WIDTH + GAP);
                int y = TOP_PADDING + 20 + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + IMAGE_WIDTH)) || !(mouseY > (double)y) || !(mouseY < (double)(y + IMAGE_HEIGHT))) continue;
                isImageClicked = true;
                clickedImageIndex = i;
                this.zoomLevel = 1.0;
                this.imageOffsetX = 0.0;
                this.imageOffsetY = 0.0;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (isImageClicked && clickedImageIndex >= 0) {
            double mouseXRelative = mouseX - (double)this.field_22789 / 2.0;
            double mouseYRelative = mouseY - (double)this.field_22790 / 2.0;
            double imageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double imageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            double mouseXInImage = -(mouseXRelative - this.imageOffsetX);
            double mouseYInImage = -(mouseYRelative - this.imageOffsetY);
            this.zoomLevel = Math.min(Math.max(this.zoomLevel + (verticalAmount > 0.0 ? 0.1 : -0.1), 0.5), 10.0);
            double newImageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double newImageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            this.imageOffsetX += mouseXInImage * (newImageWidth / imageWidth - 1.0);
            this.imageOffsetY += mouseYInImage * (newImageHeight / imageHeight - 1.0);
            return true;
        }
        if (verticalAmount < 0.0) {
            this.scrollOffset += GAP + IMAGE_HEIGHT;
        } else if (verticalAmount > 0.0) {
            this.scrollOffset -= GAP + IMAGE_HEIGHT;
        }
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, (imageIds.size() / IMAGES_PER_ROW + 2) * (IMAGE_HEIGHT + GAP) - this.field_22790 + TOP_PADDING));
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (isImageClicked && clickedImageIndex >= 0) {
            this.renderEnlargedImage(context);
            this.saveButton.field_22764 = true;
            this.deleteButton.field_22764 = true;
            this.openInAppButton.field_22764 = true;
            this.editButton.field_22764 = true;
            this.configButton.field_22764 = false;
            GalleryScreen.likeButton.field_22764 = false;
            this.sortByButton.field_22764 = false;
            this.sortOrderButton.field_22764 = false;
            this.searchField.field_22764 = false;
            this.viewTagsButton.field_22764 = true;
            this.addToAlbumButton.field_22764 = true;
            this.albumConfigButton.field_22764 = false;
            this.screenshotStatisticsButton.field_22764 = false;
            this.uploadToServerButton.field_22764 = true;
            this.likedScreenshotsButton.field_22764 = false;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = false;
            });
        } else {
            this.renderGallery(context, mouseX, mouseY);
            this.saveButton.field_22764 = false;
            this.deleteButton.field_22764 = false;
            this.openInAppButton.field_22764 = false;
            this.editButton.field_22764 = false;
            this.configButton.field_22764 = true;
            GalleryScreen.likeButton.field_22764 = true;
            this.sortByButton.field_22764 = true;
            this.sortOrderButton.field_22764 = true;
            this.searchField.field_22764 = true;
            this.viewTagsButton.field_22764 = false;
            this.addToAlbumButton.field_22764 = false;
            this.albumConfigButton.field_22764 = true;
            this.screenshotStatisticsButton.field_22764 = true;
            this.uploadToServerButton.field_22764 = false;
            this.likedScreenshotsButton.field_22764 = true;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = true;
            });
        }
        boolean isImageOverlappingButtons = clickedImageIndex >= 0 && this.isImageOverlappingButtons();
        for (class_364 button : this.method_25396()) {
            if (!(button instanceof class_4185) || !this.buttonsToHideOnOverlap.contains(button)) continue;
            if (isImageClicked) {
                ((class_4185)button).field_22764 = !isImageOverlappingButtons;
                continue;
            }
            ((class_4185)button).field_22764 = false;
        }
    }

    private void renderGallery(class_332 context, int mouseX, int mouseY) {
        int startX = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2;
        int startY = TOP_PADDING + 20;
        if (imageIds.isEmpty()) {
            return;
        }
        for (int i = 0; i < imageIds.size() && imagePaths.size() > i; ++i) {
            JsonObject metadata;
            String albumUUID;
            Album album;
            JsonObject metadata2;
            int row = i / IMAGES_PER_ROW;
            int col = i % IMAGES_PER_ROW;
            int x = startX + col * (IMAGE_WIDTH + GAP);
            int y = startY + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
            int fillColor = -7829368;
            if (i < metaDatas.size() && (metadata2 = metaDatas.get(i)) != null && metadata2.has("album") && this.field_22787 != null && (album = AlbumManager.getAlbum(UUID.fromString(albumUUID = metadata2.get("album").getAsString()))) != null) {
                String colorHex = album.getColor();
                try {
                    fillColor = Integer.parseInt(colorHex.replace("#", ""), 16) | 0xFF000000;
                }
                catch (NumberFormatException e) {
                    logger.error("Failed to parse color for album {}: {}; {}", new Object[]{album.getTitle(), colorHex, e});
                }
            }
            context.method_25294(x - 2, y - 2, x + IMAGE_WIDTH + 2, y + IMAGE_HEIGHT + 2, fillColor);
            class_2960 imageId = null;
            if (imageIds.size() > i) {
                imageId = imageIds.get(i);
            }
            if (imageId == null) {
                logger.error("Image ID is null for index {}", (Object)i);
                continue;
            }
            context.method_25290(class_1921::method_62277, imageId, x, y, 0.0f, 0.0f, IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_WIDTH, IMAGE_HEIGHT);
            if (mouseX > x && mouseX < x + IMAGE_WIDTH && mouseY > y && mouseY < y + IMAGE_HEIGHT) {
                context.method_25294(x, y, x + IMAGE_WIDTH, y + IMAGE_HEIGHT, -2130706433);
            }
            if (this.field_22787 != null && likedScreenshots.containsKey(imagePaths.get(i).toString()) && likedScreenshots.get(imagePaths.get(i).toString()).booleanValue()) {
                context.method_51433(this.field_22787.field_1772, "\u2764", x + 5, y + IMAGE_HEIGHT - 10, 0xFFFFFF, false);
            }
            if (imagePaths.size() > i && newScreenshots.contains(imagePaths.get(i)) && this.field_22787 != null) {
                context.method_51433(this.field_22787.field_1772, "\u2605", x + 20, y + IMAGE_HEIGHT - 10 - this.starY, 0xFFFF00, false);
            }
            if (i >= metaDatas.size() || metaDatas.get(i) == null || !(metadata = metaDatas.get(i)).has("tags") || !metadata.get("tags").isJsonArray()) continue;
            JsonArray tags = metadata.getAsJsonArray("tags");
            if (this.field_22787 == null || tags.isEmpty()) continue;
            String firstTag = tags.get(0).getAsString();
            int tagWidth = this.field_22787.field_1772.method_1727(firstTag);
            int tagX = x + IMAGE_WIDTH - tagWidth - 5;
            int tagY = y + IMAGE_HEIGHT - 12;
            int padding = 2;
            Objects.requireNonNull(this.field_22787.field_1772);
            context.method_25294(tagX - 2, tagY - 2, tagX + tagWidth + 2, tagY + 9 + 2, -1605361664);
            context.method_25294(tagX - 2 - 1, tagY - 2 - 1, tagX + tagWidth + 2 + 1, tagY - 2, -2236963);
            Objects.requireNonNull(this.field_22787.field_1772);
            Objects.requireNonNull(this.field_22787.field_1772);
            context.method_25294(tagX - 2 - 1, tagY + 9 + 2, tagX + tagWidth + 2 + 1, tagY + 9 + 2 + 1, -2236963);
            Objects.requireNonNull(this.field_22787.field_1772);
            context.method_25294(tagX - 2 - 1, tagY - 2, tagX - 2, tagY + 9 + 2, -2236963);
            Objects.requireNonNull(this.field_22787.field_1772);
            context.method_25294(tagX + tagWidth + 2, tagY - 2, tagX + tagWidth + 2 + 1, tagY + 9 + 2, -2236963);
            context.method_51433(this.field_22787.field_1772, firstTag, tagX + 1, tagY + 1, 0, false);
            context.method_51433(this.field_22787.field_1772, firstTag, tagX, tagY, 0xFFFFFF, false);
        }
    }

    private void renderEnlargedImage(class_332 context) {
        if (clickedImageIndex < 0 || clickedImageIndex >= imageIds.size()) {
            return;
        }
        class_2960 clickedImageId = imageIds.get(clickedImageIndex);
        GalleryScreen.removeNewScreenshot(imagePaths.get(clickedImageIndex));
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        } else {
            logger.info("Failed to get client while trying to get screen resolution while rendering large image, proceeding with 1920x1080");
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int borderWidth = 5;
        context.method_25294(x - 5, y - 5, x + imageWidth + 5, y + imageHeight + 5, -1);
        context.method_25290(class_1921::method_62277, clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        int sidebarWidth = 300;
        int sidebarXLeft = x - 300;
        if (clickedImageIndex >= 0 && clickedImageIndex < metaDatas.size()) {
            LinkedHashMap<class_2561, class_2561> drawableInfo = this.getStringStringMap();
            int textXLeft = sidebarXLeft + 10;
            int textYLeft = y + 20;
            for (class_2561 info : drawableInfo.keySet()) {
                context.method_51439(this.field_22787.field_1772, (class_2561)info.method_27661().method_10852((class_2561)drawableInfo.get(info)), textXLeft, textYLeft, 0xFFFFFF, false);
                textYLeft += 10;
            }
        }
        if (imagePaths.size() > clickedImageIndex && imagePaths.get(clickedImageIndex) != null) {
            likeButton.method_25355((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.like_screenshot").method_54663(likedScreenshots.containsKey(imagePaths.get(clickedImageIndex).toString()) && likedScreenshots.get(imagePaths.get(clickedImageIndex).toString()) != false ? 0xFFFFFF : 0x2A2A2A));
        } else {
            likeButton.method_25355((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.like_screenshot").method_54663(0x2A2A2A));
        }
    }

    private void loadAllImagesAsync() {
        Path screenshotsDir = Paths.get(System.getProperty("user.dir"), "screenshots");
        CompletableFuture.runAsync(() -> {
            try (Stream<Path> paths = Files.list(screenshotsDir);){
                Set<String> likedScreenshotsSet = GalleryScreen.loadLikedScreenshots();
                Stream<Path> filteredPaths = GalleryScreen.getFilteredPaths(paths);
                List<Path> sortedPaths = filteredPaths.sorted(Comparator.comparing(path -> likedScreenshotsSet.contains(path.toString()) ? 0 : 1).thenComparing(path -> path.toFile().lastModified(), Comparator.reverseOrder())).toList();
                this.originalImagePaths.clear();
                this.originalImagePaths.addAll(sortedPaths);
                imagePaths.clear();
                imagePaths.addAll(sortedPaths);
                this.loadImagesAsync();
            }
            catch (IOException e) {
                logger.error("Failed to load images: {}", (Object)e.getMessage());
            }
        });
    }

    @NotNull
    private static Stream<Path> getFilteredPaths(Stream<Path> paths) {
        Stream<Path> filteredPaths = paths.filter(path -> path.toString().endsWith(".png"));
        if (albumUUID != null) {
            filteredPaths = filteredPaths.filter(path -> {
                File jsonData = new File(path.getParent().toString(), path.getFileName().toString().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                if (jsonData.exists()) {
                    boolean bl;
                    FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);
                    try {
                        JsonObject metadata = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        bl = metadata.has("album") && metadata.get("album").getAsString().equals(albumUUID.toString());
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            logger.error("Error reading metadata for album filtering: {}", (Object)e.getMessage());
                        }
                    }
                    reader.close();
                    return bl;
                }
                return false;
            });
        }
        return filteredPaths;
    }

    private void performSearch(String query) {
        if (query.equals(this.lastSearchQuery)) {
            return;
        }
        this.lastSearchQuery = query;
        if (query.isEmpty()) {
            imagePaths.clear();
            imagePaths.addAll(this.originalImagePaths);
            imageIds.clear();
            metaDatas.clear();
            this.loadImagesAsync();
            return;
        }
        List<SearchTerm> searchTerms = this.parseSearchTerms(query);
        CompletableFuture.runAsync(() -> {
            ArrayList<Path> matchingPaths = new ArrayList<Path>();
            HashMap<Path, JsonObject> pathToMetadata = new HashMap<Path, JsonObject>();
            for (Path path : this.originalImagePaths) {
                try {
                    JsonObject metaData = new JsonObject();
                    File jsonData = new File(path.getParent().toString(), path.getFileName().toString().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                    if (jsonData.exists()) {
                        try (FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);){
                            metaData = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        }
                        catch (JsonSyntaxException e) {
                            logger.error("Corrupt JSON file detected while searching.", (Throwable)e);
                        }
                    }
                    metaData.addProperty("filename", path.getFileName().toString().toLowerCase());
                    pathToMetadata.put(path, metaData);
                }
                catch (IOException e) {
                    logger.error("Failed to load metadata for search: {}", (Object)e.getMessage());
                }
            }
            for (Map.Entry entry : pathToMetadata.entrySet()) {
                Path path = (Path)entry.getKey();
                JsonObject metaData = (JsonObject)entry.getValue();
                boolean matchesAllTerms = true;
                for (SearchTerm term : searchTerms) {
                    if (this.matchesTerm(metaData, term)) continue;
                    matchesAllTerms = false;
                    break;
                }
                if (!matchesAllTerms) continue;
                matchingPaths.add(path);
            }
            class_310.method_1551().execute(() -> {
                imagePaths.clear();
                imagePaths.addAll(matchingPaths);
                imageIds.clear();
                metaDatas.clear();
                this.loadImagesAsync();
            });
        });
    }

    private List<SearchTerm> parseSearchTerms(String query) {
        String[] terms;
        ArrayList<SearchTerm> searchTerms = new ArrayList<SearchTerm>();
        Map<String, String> fieldMappings = GalleryScreen.getSearchFieldTerms();
        for (String term : terms = query.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            if ((term = term.trim()).isEmpty()) continue;
            String fieldName = null;
            String fieldValue = term.toLowerCase();
            for (Map.Entry<String, String> entry : fieldMappings.entrySet()) {
                if (!term.toLowerCase().startsWith(entry.getKey())) continue;
                fieldName = entry.getValue();
                fieldValue = term.substring(entry.getKey().length()).trim().toLowerCase();
                break;
            }
            searchTerms.add(new SearchTerm(fieldName, fieldValue));
        }
        return searchTerms;
    }

    private boolean matchesTerm(JsonObject metaData, SearchTerm term) {
        String searchFieldName = term.fieldName;
        String searchFieldValue = term.fieldValue;
        String operator = this.extractComparisonOperator(searchFieldValue);
        String actualValue = searchFieldValue;
        if (!operator.isEmpty()) {
            actualValue = searchFieldValue.substring(operator.length()).trim();
        }
        if (searchFieldName == null) {
            for (Map.Entry field : metaData.entrySet()) {
                if (!((JsonElement)field.getValue()).isJsonPrimitive() || !((JsonElement)field.getValue()).getAsString().toLowerCase().contains(actualValue)) continue;
                return true;
            }
            return false;
        }
        switch (searchFieldName) {
            case "tags": {
                if (metaData.has("tags") && metaData.get("tags").isJsonArray()) {
                    JsonArray tags = metaData.getAsJsonArray("tags");
                    for (JsonElement tag : tags) {
                        if (!tag.isJsonPrimitive()) continue;
                        String tagValue = tag.getAsString().toLowerCase();
                        if (operator.isEmpty()) {
                            if (!tagValue.equals(actualValue) && !tagValue.contains(actualValue)) continue;
                            return true;
                        }
                        return this.compareValues(tagValue, operator, actualValue);
                    }
                }
                return false;
            }
            case "album": {
                if (metaData.has("album") && metaData.get("album").isJsonPrimitive()) {
                    String albumUUID = metaData.get("album").getAsString();
                    try {
                        Album album = AlbumManager.getAlbum(UUID.fromString(albumUUID));
                        if (album != null) {
                            String albumTitle = album.getTitle().toLowerCase();
                            if (operator.isEmpty()) {
                                return albumTitle.equals(actualValue) || albumTitle.contains(actualValue);
                            }
                            return this.compareValues(albumTitle, operator, actualValue);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error processing album search: {}", (Object)e.getMessage());
                    }
                }
                return false;
            }
            case "date": {
                if (metaData.has("current_time") && metaData.get("current_time").isJsonPrimitive()) {
                    return this.compareDate(metaData.get("current_time").getAsLong(), operator, actualValue);
                }
                if (metaData.has("date") && metaData.get("date").isJsonPrimitive()) {
                    return this.compareDate(metaData.get("date").getAsLong(), operator, actualValue);
                }
                return false;
            }
        }
        if (metaData.has(searchFieldName) && metaData.get(searchFieldName).isJsonPrimitive()) {
            String fieldValue = metaData.get(searchFieldName).getAsString().toLowerCase();
            if (operator.isEmpty()) {
                return fieldValue.contains(actualValue);
            }
            return this.compareValues(fieldValue, operator, actualValue);
        }
        switch (searchFieldName) {
            case "health": 
            case "food": 
            case "air": 
            case "speed": {
                if (!metaData.has("player_state") || !metaData.get("player_state").isJsonPrimitive()) break;
                String playerState = metaData.get("player_state").getAsString().toLowerCase();
                return this.matchesNestedField(playerState, searchFieldName, operator, actualValue);
            }
            case "time": 
            case "weather": 
            case "difficulty": {
                if (!metaData.has("world_info") || !metaData.get("world_info").isJsonPrimitive()) break;
                String worldInfo = metaData.get("world_info").getAsString().toLowerCase();
                return this.matchesNestedField(worldInfo, searchFieldName, operator, actualValue);
            }
            case "x": 
            case "y": 
            case "z": {
                if (!metaData.has("coordinates") || !metaData.get("coordinates").isJsonPrimitive()) break;
                String coordinates = metaData.get("coordinates").getAsString().toLowerCase();
                return this.matchesNestedField(coordinates, searchFieldName, operator, actualValue);
            }
        }
        return false;
    }

    private String extractComparisonOperator(String searchValue) {
        if ((searchValue = searchValue.trim()).startsWith(">=") || searchValue.startsWith("<=")) {
            return searchValue.substring(0, 2);
        }
        if (searchValue.startsWith(">") || searchValue.startsWith("<") || searchValue.startsWith("=")) {
            return searchValue.substring(0, 1);
        }
        return "";
    }

    private boolean matchesNestedField(String fieldString, String subFieldName, String operator, String searchValue) {
        String pattern = subFieldName + ": ";
        int pos = fieldString.indexOf(pattern);
        if (pos == -1) {
            pattern = subFieldName + ":";
            pos = fieldString.indexOf(pattern);
        }
        if (pos != -1) {
            int valueStart = pos + pattern.length();
            int valueEnd = fieldString.indexOf(44, valueStart);
            if (valueEnd == -1) {
                valueEnd = fieldString.length();
            }
            String extractedValue = fieldString.substring(valueStart, valueEnd).trim();
            if (operator.isEmpty()) {
                return extractedValue.contains(searchValue);
            }
            return this.compareValues(extractedValue, operator, searchValue);
        }
        return false;
    }

    private boolean compareDate(long timestamp, String operator, String searchValue) {
        LocalDate screenshotDate = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDate();
        try {
            if (searchValue.equals("today")) {
                LocalDate today = LocalDate.now();
                return this.compareDateWithOperator(screenshotDate, operator, today);
            }
            if (searchValue.equals("yesterday")) {
                LocalDate yesterday = LocalDate.now().minusDays(1L);
                return this.compareDateWithOperator(screenshotDate, operator, yesterday);
            }
            if (searchValue.contains("week")) {
                LocalDate aWeekAgo = LocalDate.now().minusWeeks(1L);
                if (operator.isEmpty()) {
                    return !screenshotDate.isBefore(aWeekAgo);
                }
                return this.compareDateWithOperator(screenshotDate, operator, aWeekAgo);
            }
            if (searchValue.contains("month")) {
                LocalDate aMonthAgo = LocalDate.now().minusMonths(1L);
                if (operator.isEmpty()) {
                    return !screenshotDate.isBefore(aMonthAgo);
                }
                return this.compareDateWithOperator(screenshotDate, operator, aMonthAgo);
            }
            LocalDate searchDate = null;
            if (searchValue.matches("\\d{1,2}\\.\\d{1,2}\\.\\d{4}")) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
                searchDate = LocalDate.parse(searchValue, formatter);
            } else if (searchValue.matches("\\d{1,2}\\.\\d{4}")) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM.yyyy");
                YearMonth queryYearMonth = YearMonth.parse(searchValue, formatter);
                searchDate = queryYearMonth.atDay(1);
            } else if (searchValue.matches("\\d{4}")) {
                int year = Integer.parseInt(searchValue);
                searchDate = LocalDate.of(year, 1, 1);
            }
            if (searchDate != null) {
                return this.compareDateWithOperator(screenshotDate, operator, searchDate);
            }
        }
        catch (Exception searchDate) {
            // empty catch block
        }
        String formattedDate = screenshotDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        return formattedDate.contains(searchValue);
    }

    private boolean compareDateWithOperator(LocalDate screenshotDate, String operator, LocalDate referenceDate) {
        return switch (operator) {
            case ">" -> screenshotDate.isAfter(referenceDate);
            case "<" -> screenshotDate.isBefore(referenceDate);
            case ">=" -> {
                if (screenshotDate.isAfter(referenceDate) || screenshotDate.isEqual(referenceDate)) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (screenshotDate.isBefore(referenceDate) || screenshotDate.isEqual(referenceDate)) {
                    yield true;
                }
                yield false;
            }
            default -> screenshotDate.isEqual(referenceDate);
        };
    }

    private boolean compareValues(String fieldValue, String operator, String searchValue) {
        try {
            double fieldNumeric = Double.parseDouble(fieldValue.replaceAll("[^0-9.-]", ""));
            double searchNumeric = Double.parseDouble(searchValue.replaceAll("[^0-9.-]", ""));
            return switch (operator) {
                case ">" -> {
                    if (fieldNumeric > searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (fieldNumeric < searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (fieldNumeric >= searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (fieldNumeric <= searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case "=" -> {
                    if (fieldNumeric == searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                default -> fieldValue.contains(searchValue);
            };
        }
        catch (NumberFormatException e) {
            return fieldValue.contains(searchValue);
        }
    }

    @NotNull
    private static Map<String, String> getSearchFieldTerms() {
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        fieldMappings.put("seed:", "world_seed");
        fieldMappings.put("biome:", "biome");
        fieldMappings.put("world:", "world_name");
        fieldMappings.put("server:", "server_address");
        fieldMappings.put("username:", "username");
        fieldMappings.put("coordinates:", "coordinates");
        fieldMappings.put("location:", "coordinates");
        fieldMappings.put("facing:", "facing_direction");
        fieldMappings.put("player:", "player_state");
        fieldMappings.put("date:", "date");
        fieldMappings.put("day:", "date");
        fieldMappings.put("time:", "date");
        fieldMappings.put("health:", "health");
        fieldMappings.put("food:", "food");
        fieldMappings.put("air:", "air");
        fieldMappings.put("speed:", "speed");
        fieldMappings.put("worldtime:", "time");
        fieldMappings.put("weather:", "weather");
        fieldMappings.put("difficulty:", "difficulty");
        fieldMappings.put("x:", "x");
        fieldMappings.put("y:", "y");
        fieldMappings.put("z:", "z");
        fieldMappings.put("tag:", "tags");
        fieldMappings.put("album:", "album");
        return fieldMappings;
    }

    private void loadImagesAsync() {
        int currentTaskId = this.sortTaskId.incrementAndGet();
        this.asyncSortFuture = CompletableFuture.runAsync(() -> {
            Set<String> likedScreenshotsSet = GalleryScreen.loadLikedScreenshots();
            if (this.sortTaskId.get() != currentTaskId) {
                return;
            }
            for (Path path : imagePaths) {
                if (this.sortTaskId.get() != currentTaskId) {
                    return;
                }
                try {
                    class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(path, new OpenOption[0]));
                    class_2960 textureId = class_2960.method_60655((String)"gallery", (String)("textures/" + path.getFileName().toString()));
                    if (this.field_22787 != null) {
                        this.field_22787.execute(() -> this.field_22787.method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, image)));
                    }
                    imageIds.add(textureId);
                    String imagePathString = path.toString();
                    if (likedScreenshotsSet.contains(imagePathString)) {
                        likedScreenshots.put(imagePathString, true);
                    }
                    JsonObject metaData = new JsonObject();
                    File jsonData = new File(path.getParent().toString(), path.getFileName().toString().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                    if (jsonData.exists()) {
                        try (FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);){
                            metaData = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        }
                        catch (JsonSyntaxException e) {
                            logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
                        }
                        catch (IOException e) {
                            logger.error("Error reading the JSON file.", (Throwable)e);
                        }
                    }
                    metaData.addProperty("screenshotUrl", imagePathString);
                    metaData.addProperty("liked", Boolean.valueOf(likedScreenshotsSet.contains(imagePathString)));
                    metaData.addProperty("screenshotDate", new Date(jsonData.lastModified()).toString());
                    metaDatas.add(metaData);
                }
                catch (IOException e) {
                    logger.error("Failed to load image '{}': {}", (Object)path, (Object)e.getMessage());
                }
            }
        });
    }

    private static Set<String> loadLikedScreenshots() {
        HashSet<String> likedScreenshots = new HashSet<String>();
        File file = new File(FILE_PATH);
        if (file.exists() && file.length() > 0L) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject obj = element.getAsJsonObject();
                    if (!obj.has("screenshotUrl")) continue;
                    likedScreenshots.add(obj.get("screenshotUrl").getAsString());
                }
            }
            catch (JsonSyntaxException e) {
                logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error reading the like file.", (Throwable)e);
            }
        }
        return likedScreenshots;
    }

    private void saveImage() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(clickedImageIndex);
            Path savePath = Paths.get(System.getProperty("user.home"), "Desktop", "Saved_" + imagePath.getFileName().toString());
            try {
                Files.copy(imagePath, savePath, new CopyOption[0]);
                logger.info("Image saved to: {}", (Object)savePath);
            }
            catch (IOException e) {
                logger.error("Failed to save image: {}", (Object)e.getMessage());
            }
        }
    }

    private void deleteImage() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(clickedImageIndex);
            try {
                Files.delete(imagePath);
                imagePaths.remove(clickedImageIndex);
                imageIds.remove(clickedImageIndex);
                logger.info("Image deleted: {}", (Object)imagePath);
                clickedImageIndex = -1;
                isImageClicked = false;
            }
            catch (IOException e) {
                logger.error("Failed to delete image: {}", (Object)e.getMessage());
            }
        }
    }

    private void openImageInApp() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(clickedImageIndex);
            try {
                ProcessBuilder processBuilder;
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("win")) {
                    processBuilder = new ProcessBuilder("explorer", imagePath.toAbsolutePath().toString());
                } else if (os.contains("mac")) {
                    processBuilder = new ProcessBuilder("open", imagePath.toAbsolutePath().toString());
                } else if (os.contains("nix") || os.contains("nux")) {
                    processBuilder = new ProcessBuilder("xdg-open", imagePath.toAbsolutePath().toString());
                } else {
                    logger.error("Unsupported operating system for opening the image.");
                    return;
                }
                processBuilder.start();
            }
            catch (IOException e) {
                logger.error("Failed to open image with external application: {}", (Object)e.getMessage());
            }
        }
    }

    private boolean isImageOverlappingButtons() {
        if (!isImageClicked || clickedImageIndex < 0) {
            return false;
        }
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        for (class_364 var : this.method_25396()) {
            class_364 element;
            class_342 textFieldWidget;
            class_4185 button;
            if (!(var instanceof class_4185 ? this.isButtonCoveredByImage(button = (class_4185)var, x, y, imageWidth, imageHeight) : (var instanceof class_342 ? this.isTextFieldCoveredByImage(textFieldWidget = (class_342)var, x, y, imageWidth, imageHeight) : var instanceof class_364 && (element = var).method_25405((double)x, (double)y)))) continue;
            return true;
        }
        return false;
    }

    private boolean isButtonCoveredByImage(class_4185 button, int imageX, int imageY, int imageWidth, int imageHeight) {
        int buttonX = button.method_46426();
        int buttonY = button.method_46427();
        int buttonWidth = button.method_25368();
        int buttonHeight = button.method_25364();
        return buttonX + buttonWidth >= imageX && buttonX <= imageX + imageWidth && buttonY + buttonHeight >= imageY && buttonY <= imageY + imageHeight;
    }

    private boolean isTextFieldCoveredByImage(class_342 textFieldWidget, int imageX, int imageY, int imageWidth, int imageHeight) {
        int buttonX = textFieldWidget.method_46426();
        int buttonY = textFieldWidget.method_46427();
        int buttonWidth = textFieldWidget.method_25368();
        int buttonHeight = textFieldWidget.method_25364();
        return buttonX + buttonWidth >= imageX && buttonX <= imageX + imageWidth && buttonY + buttonHeight >= imageY && buttonY <= imageY + imageHeight;
    }

    private static void likeScreenshot() {
        boolean dirsCreated;
        if (imageIds.isEmpty() || clickedImageIndex < 0 || clickedImageIndex >= imageIds.size()) {
            System.err.println("Invalid image index or list is empty.");
            return;
        }
        String screenshotId = String.valueOf(imageIds.get(clickedImageIndex));
        String screenshotUrl = String.valueOf(imagePaths.get(clickedImageIndex));
        File file = new File(FILE_PATH);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists() && (dirsCreated = parentDir.mkdirs())) {
            logger.info("Created missing directories: {}", (Object)parentDir.getAbsolutePath());
        }
        JsonArray jsonArray = new JsonArray();
        if (file.exists() && file.length() > 0L) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            }
            catch (JsonSyntaxException e) {
                logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
                jsonArray = new JsonArray();
            }
            catch (IOException e) {
                logger.error("Error reading the like file.", (Throwable)e);
                return;
            }
        }
        boolean screenshotAlreadyLiked = false;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject existingLike = jsonArray.get(i).getAsJsonObject();
            if (!existingLike.has("screenshotId") || !existingLike.get("screenshotId").getAsString().equals(screenshotId)) continue;
            jsonArray.remove(i);
            screenshotAlreadyLiked = true;
            break;
        }
        if (!screenshotAlreadyLiked) {
            JsonObject newLike = new JsonObject();
            newLike.addProperty("screenshotId", screenshotId);
            newLike.addProperty("screenshotUrl", screenshotUrl);
            jsonArray.add((JsonElement)newLike);
        }
        try (FileWriter writer = new FileWriter(FILE_PATH, StandardCharsets.UTF_8);){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonArray));
        }
        catch (IOException e) {
            logger.error("Error while saving likes.", (Throwable)e);
        }
        isImageClicked = false;
        clickedImageIndex = -1;
    }

    private void loadImageSorted(SortOrder sortOrder, SortBy sortBy) {
        int currentTaskId = this.sortTaskId.incrementAndGet();
        this.sortByButton.field_22763 = false;
        this.sortOrderButton.field_22763 = false;
        if (this.asyncSortFuture != null && !this.asyncSortFuture.isDone()) {
            this.asyncSortFuture.cancel(true);
        }
        Path screenshotsDir = Paths.get(System.getProperty("user.dir"), "screenshots");
        this.asyncSortFuture = CompletableFuture.runAsync(() -> {
            try {
                List<Path> sortedPaths;
                Set<String> likedScreenshotsSet = GalleryScreen.loadLikedScreenshots();
                try (Stream<Path> paths = Files.list(screenshotsDir);){
                    List<PathWithMetadata> pathsWithMetadata = paths.filter(path -> path.toString().endsWith(".png")).map(path -> {
                        JsonObject metadata = new JsonObject();
                        File jsonData = new File(path.getParent().toString(), path.getFileName().toString().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                        if (jsonData.exists()) {
                            try (FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);){
                                metadata = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            }
                            catch (Exception e) {
                                logger.error("Error reading metadata for sorting: {}", (Object)e.getMessage());
                            }
                        }
                        return new PathWithMetadata((Path)path, metadata);
                    }).sorted((pm1, pm2) -> {
                        Path path1 = pm1.path();
                        Path path2 = pm2.path();
                        JsonObject metadata1 = pm1.metadata();
                        JsonObject metadata2 = pm2.metadata();
                        if (sortBy == SortBy.DEFAULT) {
                            if (likedScreenshotsSet.contains(path1.toString()) && !likedScreenshotsSet.contains(path2.toString())) {
                                return -1;
                            }
                            if (!likedScreenshotsSet.contains(path1.toString()) && likedScreenshotsSet.contains(path2.toString())) {
                                return 1;
                            }
                            return Long.compare(path2.toFile().lastModified(), path1.toFile().lastModified());
                        }
                        if (sortBy == SortBy.TAG) {
                            String tag1 = this.getFirstTag(metadata1);
                            String tag2 = this.getFirstTag(metadata2);
                            if (tag1 == null && tag2 == null) {
                                return path1.getFileName().toString().compareTo(path2.getFileName().toString());
                            }
                            if (tag1 == null) {
                                return 1;
                            }
                            if (tag2 == null) {
                                return -1;
                            }
                            return tag1.compareToIgnoreCase(tag2);
                        }
                        int result = switch (sortBy.ordinal()) {
                            case 0 -> path1.getFileName().toString().compareTo(path2.getFileName().toString());
                            case 1 -> Long.compare(path2.toFile().lastModified(), path1.toFile().lastModified());
                            case 2 -> Long.compare(path1.toFile().length(), path2.toFile().length());
                            default -> 0;
                        };
                        return sortOrder == SortOrder.ASCENDING ? result : -result;
                    }).toList();
                    sortedPaths = pathsWithMetadata.stream().map(PathWithMetadata::path).toList();
                }
                if (this.sortTaskId.get() != currentTaskId) {
                    return;
                }
                class_310.method_1551().execute(() -> {
                    imageIds.clear();
                    imagePaths.clear();
                    metaDatas.clear();
                    imagePaths.addAll(sortedPaths);
                    this.sortByButton.field_22763 = true;
                    this.sortOrderButton.field_22763 = true;
                });
                for (Path path2 : sortedPaths) {
                    if (this.sortTaskId.get() != currentTaskId) {
                        return;
                    }
                    JsonObject metaData = new JsonObject();
                    File jsonData = new File(path2.getParent().toString(), path2.getFileName().toString().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                    if (jsonData.exists()) {
                        try (FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);){
                            metaData = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        }
                        catch (JsonSyntaxException e) {
                            logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
                        }
                        catch (IOException e) {
                            logger.error("Error reading the JSON file.", (Throwable)e);
                        }
                    }
                    metaData.addProperty("screenshotUrl", path2.toString());
                    metaData.addProperty("liked", Boolean.valueOf(likedScreenshotsSet.contains(path2.toString())));
                    metaData.addProperty("screenshotDate", new Date(jsonData.lastModified()).toString());
                    class_2960 textureId = null;
                    try {
                        class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(path2, new OpenOption[0]));
                        textureId = class_2960.method_60655((String)"gallery", (String)("textures/" + path2.getFileName().toString()));
                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, image));
                    }
                    catch (IOException e) {
                        logger.error("Failed to load image during sort '{}': {}", (Object)path2, (Object)e.getMessage());
                    }
                    JsonObject finalMetaData = metaData;
                    class_2960 finalTextureId = textureId;
                    class_310.method_1551().execute(() -> {
                        metaDatas.add(finalMetaData);
                        imageIds.add(finalTextureId);
                    });
                }
            }
            catch (IOException e) {
                logger.error("Failed to sort images: {}", (Object)e.getMessage());
            }
        });
    }

    private String getFirstTag(JsonObject metadata) {
        JsonArray tagsArray;
        if (metadata != null && metadata.has("tags") && metadata.get("tags").isJsonArray() && !(tagsArray = metadata.getAsJsonArray("tags")).isEmpty() && tagsArray.get(0).isJsonPrimitive()) {
            return tagsArray.get(0).getAsString();
        }
        return null;
    }

    @NotNull
    private LinkedHashMap<class_2561, class_2561> getStringStringMap() {
        JsonObject metaData = metaDatas.get(clickedImageIndex);
        LinkedHashMap<class_2561, class_2561> drawableInfo = new LinkedHashMap<class_2561, class_2561>();
        if (metaData.has("username")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.username"), (class_2561)(metaData.has("username") && metaData.get("username").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("username").getAsString()) : (metaData.has("fileUsername") && metaData.get("fileUsername").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("fileUsername").getAsString()) : class_2561.method_43470((String)"N/A"))));
        }
        if (metaData.has("server_address")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.serverAddress"), (class_2561)(metaData.has("server_address") && metaData.get("server_address").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("server_address").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_name")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.world"), (class_2561)(metaData.has("world_name") && metaData.get("world_name").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_name").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("coordinates")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.location"), (class_2561)(metaData.has("coordinates") && metaData.get("coordinates").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("coordinates").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("facing_direction")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.facing"), (class_2561)(metaData.has("facing_direction") && metaData.get("facing_direction").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("facing_direction").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("player_state")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.playerState"), (class_2561)(metaData.has("player_state") && metaData.get("player_state").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("player_state").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("biome")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.biome"), (class_2561)(metaData.has("biome") && metaData.get("biome").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("biome").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_info")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.worldInfo"), (class_2561)(metaData.has("world_info") && metaData.get("world_info").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_info").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_seed")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.seed"), (class_2561)(metaData.has("world_seed") && metaData.get("world_seed").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_seed").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        drawableInfo.put((class_2561)class_2561.method_43470((String)" "), (class_2561)class_2561.method_43470((String)" "));
        if (metaData.has("current_time")) {
            drawableInfo.put((class_2561)(metaData.has("current_time") ? GalleryScreen.getTimestamp(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? GalleryScreen.getTimestamp(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        }
        if (metaData.has("current_time")) {
            drawableInfo.put((class_2561)(metaData.has("current_time") ? GalleryScreen.getTimeAgo(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? GalleryScreen.getTimeAgo(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        }
        return drawableInfo;
    }

    public static class_2561 getTimestamp(long millis) {
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        LocalDateTime timestampDateTime = LocalDateTime.ofInstant(timestampInstant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        return class_2561.method_43470((String)timestampDateTime.format(formatter)).method_27694(style -> style.method_30938(Boolean.valueOf(true)));
    }

    private static class_2561 getTimeAgo(long millis) {
        Instant nowInstant;
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        Duration duration = Duration.between(timestampInstant, nowInstant = Instant.now());
        long seconds = duration.getSeconds();
        if (seconds < 60L) {
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.seconds_ago", (Object[])new Object[]{seconds}).method_27693(")"));
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.minutes_ago", (Object[])new Object[]{minutes}).method_27693(")"));
        }
        if (seconds < 86400L) {
            long hours = seconds / 3600L;
            long minutes = seconds % 3600L / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.hours_ago", (Object[])new Object[]{hours, minutes}).method_27693(")"));
        }
        long days = seconds / 86400L;
        return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.days_ago", (Object[])new Object[]{days}).method_27693(")"));
    }

    public void cancelAllAsyncTasks() {
        imageIds.clear();
        imagePaths.clear();
        this.navigatorButtons.clear();
        metaDatas.clear();
        clickedImageIndex = -1;
        isImageClicked = false;
        if (this.asyncSortFuture != null && !this.asyncSortFuture.isDone()) {
            this.asyncSortFuture.cancel(true);
        }
        if (this.searchDebounceTask != null) {
            class_310.method_1551().method_63588(() -> {
                this.searchDebounceTask = null;
            });
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        client.method_1507(null);
        super.method_25410(client, width, height);
    }

    public void method_25419() {
        if (isImageClicked) {
            isImageClicked = false;
            clickedImageIndex = -1;
        }
        imageIds.clear();
        imagePaths.clear();
        metaDatas.clear();
        this.lastSearchQuery = "";
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField.method_25370() && this.searchField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.method_25370() && this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 70 && (modifiers & 2) != 0) {
            this.searchField.method_25365(true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25393() {
        super.method_25393();
        if (this.goingUp) {
            this.starY += 4;
            if (this.starY >= 12) {
                this.goingUp = false;
            }
        } else {
            this.starY -= 4;
            if (this.starY <= 0) {
                this.goingUp = true;
            }
        }
    }

    static {
        likedScreenshots = new LinkedHashMap();
        newScreenshots = new ArrayList<Path>();
    }

    private static enum SortBy {
        NAME,
        DATE,
        SIZE,
        TAG,
        DEFAULT;

    }

    private static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    private record SearchTerm(String fieldName, String fieldValue) {
    }

    private record PathWithMetadata(Path path, JsonObject metadata) {
    }
}

